/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xeustechnologies.jcl.Configuration;
import org.xeustechnologies.jcl.JclJarEntry;
import org.xeustechnologies.jcl.exception.JclException;

public class JarResources {
    protected Map<String, JclJarEntry> jarEntryContents;
    protected boolean collisionAllowed;
    private final transient Logger logger = LoggerFactory.getLogger(JarResources.class);

    public JarResources() {
        this.jarEntryContents = new HashMap<String, JclJarEntry>();
        this.collisionAllowed = Configuration.suppressCollisionException();
    }

    public URL getResourceURL(String name) {
        JclJarEntry entry = this.jarEntryContents.get(name);
        if (entry != null) {
            if (entry.getBaseUrl() == null) {
                throw new JclException("non-URL accessible resource");
            }
            try {
                return new URL(entry.getBaseUrl().toString() + name);
            }
            catch (MalformedURLException e) {
                throw new JclException(e);
            }
        }
        return null;
    }

    public byte[] getResource(String name) {
        JclJarEntry entry = this.jarEntryContents.get(name);
        if (entry != null) {
            return entry.getResourceBytes();
        }
        return null;
    }

    public Map<String, byte[]> getResources() {
        HashMap<String, byte[]> resourcesAsBytes = new HashMap<String, byte[]>(this.jarEntryContents.size());
        for (Map.Entry<String, JclJarEntry> entry : this.jarEntryContents.entrySet()) {
            resourcesAsBytes.put(entry.getKey(), entry.getValue().getResourceBytes());
        }
        return resourcesAsBytes;
    }

    public void loadJar(String jarFile) {
        this.logger.debug("Loading jar: {}", (Object)jarFile);
        FileInputStream fis = null;
        try {
            File file = new File(jarFile);
            String baseUrl = "jar:" + file.toURI().toString() + "!/";
            fis = new FileInputStream(file);
            this.loadJar(baseUrl, fis);
        }
        catch (IOException e) {
            throw new JclException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new JclException(e);
                }
            }
        }
    }

    public void loadJar(URL url) {
        this.logger.debug("Loading jar: {}", (Object)url.toString());
        InputStream in = null;
        try {
            String baseUrl = "jar:" + url.toString() + "!/";
            in = url.openStream();
            this.loadJar(baseUrl, in);
        }
        catch (IOException e) {
            throw new JclException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new JclException(e);
                }
            }
        }
    }

    public void loadJar(String argBaseUrl, InputStream jarStream) {
        this.loadJar(argBaseUrl, jarStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadJar(String argBaseUrl, InputStream jarStream, boolean closeStream) {
        BufferedInputStream bis = null;
        ZipInputStream jis = null;
        try {
            bis = new BufferedInputStream(jarStream);
            jis = new JarInputStream(bis);
            JarEntry jarEntry = null;
            while ((jarEntry = ((JarInputStream)jis).getNextJarEntry()) != null) {
                this.logger.debug(this.dump(jarEntry));
                if (jarEntry.isDirectory()) continue;
                if (this.jarEntryContents.containsKey(jarEntry.getName())) {
                    if (!this.collisionAllowed) {
                        throw new JclException("Class/Resource " + jarEntry.getName() + " already loaded");
                    }
                    this.logger.debug("Class/Resource {} already loaded; ignoring entry...", (Object)jarEntry.getName());
                    continue;
                }
                this.logger.debug("Entry Name: {}, Entry Size: {}", (Object)jarEntry.getName(), (Object)jarEntry.getSize());
                byte[] b = new byte[2048];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int len = 0;
                while ((len = jis.read(b)) > 0) {
                    out.write(b, 0, len);
                }
                JclJarEntry entry = new JclJarEntry();
                entry.setBaseUrl(argBaseUrl);
                entry.setResourceBytes(out.toByteArray());
                this.jarEntryContents.put(jarEntry.getName(), entry);
                this.logger.debug("{}: size={}, csize={}", jarEntry.getName(), out.size(), jarEntry.getCompressedSize());
                out.close();
            }
        }
        catch (IOException e) {
            throw new JclException(e);
        }
        catch (NullPointerException e) {
            this.logger.debug("Done loading.");
        }
        finally {
            if (closeStream) {
                if (jis != null) {
                    try {
                        jis.close();
                    }
                    catch (IOException e) {
                        throw new JclException(e);
                    }
                }
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        throw new JclException(e);
                    }
                }
            }
        }
    }

    private String dump(JarEntry je) {
        StringBuffer sb = new StringBuffer();
        if (je.isDirectory()) {
            sb.append("d ");
        } else {
            sb.append("f ");
        }
        if (je.getMethod() == 0) {
            sb.append("stored   ");
        } else {
            sb.append("defalted ");
        }
        sb.append(je.getName());
        sb.append("\t");
        sb.append("" + je.getSize());
        if (je.getMethod() == 8) {
            sb.append("/" + je.getCompressedSize());
        }
        return sb.toString();
    }
}

