/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.randomvalue;

import java.util.List;
import java.util.Random;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.UUIDUtil;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.randomvalue.Messages;
import org.pentaho.di.trans.steps.randomvalue.RandomValueData;
import org.pentaho.di.trans.steps.randomvalue.RandomValueMeta;

public class RandomValue
extends BaseStep
implements StepInterface {
    private RandomValueMeta meta;
    private RandomValueData data;

    public RandomValue(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.setName(stepMeta.getName());
    }

    private Object[] getRandomValue(RowMetaInterface inputRowMeta, Object[] inputRowData) {
        Object[] row = new Object[this.data.outputRowMeta.size()];
        for (int i = 0; i < inputRowMeta.size(); ++i) {
            row[i] = inputRowData[i];
        }
        Random randomgen = new Random();
        int i = 0;
        int index = inputRowMeta.size();
        while (i < this.meta.getFieldName().length) {
            switch (this.meta.getFieldType()[i]) {
                case 1: {
                    row[index] = randomgen.nextDouble();
                    break;
                }
                case 2: {
                    row[index] = new Long(randomgen.nextInt(Integer.MAX_VALUE));
                    break;
                }
                case 3: {
                    row[index] = Long.toString(Math.abs(randomgen.nextLong()), 32);
                    break;
                }
                case 4: {
                    row[index] = UUIDUtil.getUUIDAsString();
                    break;
                }
                case 5: {
                    row[index] = this.data.u4.getUUID4AsString();
                    break;
                }
            }
            ++i;
            ++index;
        }
        return row;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        RowMetaInterface imeta;
        Object[] row;
        if (this.data.readsRows) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
        } else {
            row = new Object[]{};
            this.incrementLinesRead();
            if (this.first) {
                this.first = false;
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            }
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        row = this.getRandomValue(imeta, row);
        if (this.log.isRowLevel()) {
            this.logRowlevel(Messages.getString("RandomValue.Log.ValueReturned", this.data.outputRowMeta.getString(row)));
        }
        this.putRow(this.data.outputRowMeta, row);
        if (!this.data.readsRows) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RandomValueMeta)smi;
        this.data = (RandomValueData)sdi;
        if (super.init(smi, sdi)) {
            this.data.readsRows = false;
            List<StepMeta> previous = this.getTransMeta().findPreviousSteps(this.getStepMeta());
            if (previous != null && previous.size() > 0) {
                this.data.readsRows = true;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

