/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sysopen;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class SystemOpenAction
extends AbstractAction
implements ContextAwareAction {
    private static final RequestProcessor PROC = new RequestProcessor(SystemOpenAction.class);
    private final Lookup.Result<DataObject> result;
    private final LookupListener resultListener;
    private final Set<File> files;

    public SystemOpenAction() {
        this(Utilities.actionsGlobalContext());
    }

    private SystemOpenAction(Lookup lookup) {
        super(NbBundle.getMessage(SystemOpenAction.class, (String)"CTL_SystemOpenAction"));
        this.putValue("hideWhenDisabled", true);
        this.result = lookup.lookupResult(DataObject.class);
        this.resultListener = lookupEvent -> this.updateFileSet();
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.resultListener, this.result));
        this.files = new HashSet<File>();
        this.updateFileSet();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PROC.post(() -> {
            Desktop desktop = Desktop.getDesktop();
            for (File file : this.files) {
                try {
                    desktop.open(file);
                }
                catch (IOException iOException) {
                    Logger.getLogger(SystemOpenAction.class.getName()).log(Level.INFO, null, iOException);
                }
            }
        });
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new SystemOpenAction(lookup);
    }

    @Override
    public boolean isEnabled() {
        return !this.files.isEmpty() && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
    }

    private void updateFileSet() {
        this.files.clear();
        for (DataObject dataObject : this.result.allInstances()) {
            File file = FileUtil.toFile((FileObject)dataObject.getPrimaryFile());
            if (file == null || this.isIgnoredFile(file)) continue;
            this.files.add(file);
        }
    }

    private boolean isIgnoredFile(File file) {
        if (Utilities.isWindows() && file.isFile() && !file.getName().contains(".")) {
            return true;
        }
        return file.getName().endsWith(".shadow");
    }
}

