/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.internal.Frame;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.Script;
import org.apache.commons.jexl3.parser.ASTJexlLambda;

public class Closure
extends Script {
    protected final Frame frame;
    protected final JexlOptions options;

    protected Closure(Interpreter theCaller, ASTJexlLambda lambda) {
        super(theCaller.jexl, null, lambda);
        this.frame = lambda.createFrame(theCaller.frame, new Object[0]);
        JexlOptions callerOptions = theCaller.options;
        this.options = callerOptions != null ? callerOptions.copy() : null;
    }

    protected Closure(Script base, Object[] args) {
        super(base.jexl, base.source, base.script);
        Frame sf = base instanceof Closure ? ((Closure)base).frame : null;
        this.frame = sf == null ? this.script.createFrame(args) : sf.assign(args);
        JexlOptions closureOptions = null;
        if (base instanceof Closure) {
            closureOptions = ((Closure)base).options;
        }
        this.options = closureOptions != null ? closureOptions.copy() : null;
    }

    @Override
    public Script.Callable callable(JexlContext context, Object ... args) {
        Frame local = this.frame != null ? this.frame.assign(args) : null;
        return new Script.Callable(this.createInterpreter(context, local, this.options)){

            @Override
            public Object interpret() {
                return this.interpreter.runClosure(Closure.this);
            }
        };
    }

    void captureSelfIfRecursive(Frame parentFrame, int symbol) {
        if (this.script instanceof ASTJexlLambda) {
            Integer reg;
            Scope localScope;
            Scope parentScope = parentFrame != null ? parentFrame.getScope() : null;
            Scope scope = localScope = this.frame != null ? this.frame.getScope() : null;
            if (parentScope != null && localScope != null && parentScope == localScope.getParent() && (reg = localScope.getCaptured(symbol)) != null) {
                this.frame.set(reg, this);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Closure other = (Closure)obj;
        if (this.jexl != other.jexl) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        if (this.frame == other.frame) {
            return true;
        }
        return Arrays.deepEquals(this.frame.nocycleStack(this), other.frame.nocycleStack(other));
    }

    @Override
    public Object evaluate(JexlContext context) {
        return this.execute(context, null);
    }

    @Override
    public Object execute(JexlContext context) {
        return this.execute(context, null);
    }

    @Override
    public Object execute(JexlContext context, Object ... args) {
        Frame local = this.frame != null ? this.frame.assign(args) : null;
        Interpreter interpreter = this.createInterpreter(context, local, this.options);
        return interpreter.runClosure(this);
    }

    @Override
    public String[] getUnboundParameters() {
        return this.frame.getUnboundParameters();
    }

    @Override
    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + Objects.hashCode(this.jexl);
        hash = 31 * hash + Objects.hashCode(this.source);
        hash = 31 * hash + (this.frame != null ? Arrays.deepHashCode(this.frame.nocycleStack(this)) : 0);
        return hash;
    }
}

