/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.implicit;

import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class ImplicitResultClassBuilder
implements ResultBuilder {
    private final Class<?> suppliedResultClass;

    public ImplicitResultClassBuilder(Class<?> suppliedResultClass) {
        this.suppliedResultClass = suppliedResultClass;
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        assert (resultPosition == 0);
        SessionFactoryImplementor sessionFactory = domainResultCreationState.getSqlAstCreationState().getCreationContext().getSessionFactory();
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        SqlExpressionResolver sqlExpressionResolver = domainResultCreationState.getSqlAstCreationState().getSqlExpressionResolver();
        boolean jdbcResultPosition = true;
        String columnName = jdbcResultsMetadata.resolveColumnName(1);
        BasicType basicType = jdbcResultsMetadata.resolveType(1, typeConfiguration.getJavaTypeRegistry().resolveDescriptor(this.suppliedResultClass), typeConfiguration);
        SqlSelection selection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(columnName), state -> new ResultSetMappingSqlSelection(resultPosition, basicType)), basicType.getMappedJavaType(), null, typeConfiguration);
        return new BasicResult(selection.getValuesArrayPosition(), columnName, basicType);
    }

    @Override
    public Class<?> getJavaType() {
        return this.suppliedResultClass;
    }

    @Override
    public ResultBuilder cacheKeyInstance() {
        return this;
    }
}

