/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.util.types;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.jboss.resteasy.reactive.RestResponse;

public final class Types {
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    public static Type[] getActualTypeArgumentsOfAnInterface(Class<?> classToSearch, Class<?> interfaceToFind) {
        Type[] types = Types.findParameterizedTypes(classToSearch, interfaceToFind);
        if (types == null) {
            throw new RuntimeException("Unable to find type arguments of " + String.valueOf(interfaceToFind));
        }
        return types;
    }

    public static Type[] findParameterizedTypes(Class<?> root, Class<?> searchedFor) {
        if (searchedFor.isInterface()) {
            return Types.findInterfaceParameterizedTypes(root, null, searchedFor);
        }
        return Types.findClassParameterizedTypes(root, null, searchedFor);
    }

    public static Type[] findClassParameterizedTypes(Class<?> root, ParameterizedType rootType, Class<?> searchedForClass) {
        if (Object.class.equals(root)) {
            return null;
        }
        Map<TypeVariable<?>, Type> typeVarMap = Types.populateParameterizedMap(root, rootType);
        Class<?> superclass = root.getSuperclass();
        Type genericSuper = root.getGenericSuperclass();
        if (superclass.equals(searchedForClass)) {
            return Types.extractTypes(typeVarMap, genericSuper);
        }
        if (genericSuper instanceof ParameterizedType) {
            ParameterizedType intfParam = (ParameterizedType)genericSuper;
            Type[] types = Types.findClassParameterizedTypes(superclass, intfParam, searchedForClass);
            if (types != null) {
                return Types.extractTypeVariables(typeVarMap, types);
            }
        } else {
            Type[] types = Types.findClassParameterizedTypes(superclass, null, searchedForClass);
            if (types != null) {
                return types;
            }
        }
        return null;
    }

    private static Map<TypeVariable<?>, Type> populateParameterizedMap(Class<?> root, ParameterizedType rootType) {
        HashMap typeVarMap = new HashMap();
        if (rootType != null) {
            TypeVariable<Class<?>>[] vars = root.getTypeParameters();
            for (int i = 0; i < vars.length; ++i) {
                typeVarMap.put(vars[i], rootType.getActualTypeArguments()[i]);
            }
        }
        return typeVarMap;
    }

    public static Type[] findInterfaceParameterizedTypes(Class<?> root, ParameterizedType rootType, Class<?> searchedForInterface) {
        int i;
        Map<TypeVariable<?>, Type> typeVarMap = Types.populateParameterizedMap(root, rootType);
        for (i = 0; i < root.getInterfaces().length; ++i) {
            Class<?> sub = root.getInterfaces()[i];
            Type genericSub = root.getGenericInterfaces()[i];
            if (!sub.equals(searchedForInterface)) continue;
            return Types.extractTypes(typeVarMap, genericSub);
        }
        for (i = 0; i < root.getInterfaces().length; ++i) {
            Class<?> sub;
            Type genericSub = root.getGenericInterfaces()[i];
            Type[] types = Types.recurseSuperclassForInterface(searchedForInterface, typeVarMap, genericSub, sub = root.getInterfaces()[i]);
            if (types == null) continue;
            return types;
        }
        if (root.isInterface()) {
            return null;
        }
        Class<?> superclass = root.getSuperclass();
        Type genericSuper = root.getGenericSuperclass();
        return Types.recurseSuperclassForInterface(searchedForInterface, typeVarMap, genericSuper, superclass);
    }

    private static Type[] recurseSuperclassForInterface(Class<?> searchedForInterface, Map<TypeVariable<?>, Type> typeVarMap, Type genericSub, Class<?> sub) {
        if (genericSub instanceof ParameterizedType) {
            ParameterizedType intfParam = (ParameterizedType)genericSub;
            Type[] types = Types.findInterfaceParameterizedTypes(sub, intfParam, searchedForInterface);
            if (types != null) {
                return Types.extractTypeVariables(typeVarMap, types);
            }
        } else {
            Type[] types = Types.findInterfaceParameterizedTypes(sub, null, searchedForInterface);
            if (types != null) {
                return types;
            }
        }
        return null;
    }

    private static Type[] extractTypeVariables(Map<TypeVariable<?>, Type> typeVarMap, Type[] types) {
        Type[] resolvedMethodParameterTypes = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            Type methodParameterType = types[i];
            resolvedMethodParameterTypes[i] = methodParameterType instanceof TypeVariable ? typeVarMap.get(methodParameterType) : methodParameterType;
        }
        return resolvedMethodParameterTypes;
    }

    private static Type[] extractTypes(Map<TypeVariable<?>, Type> typeVarMap, Type genericSub) {
        if (genericSub instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)genericSub;
            Type[] types = param.getActualTypeArguments();
            Type[] returnTypes = Types.extractTypeVariables(typeVarMap, types);
            return returnTypes;
        }
        return EMPTY_TYPE_ARRAY;
    }

    public static Type getEffectiveReturnType(Type returnType) {
        if (returnType instanceof Class) {
            return returnType;
        }
        if (returnType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)returnType;
            Type firstTypeArgument = type.getActualTypeArguments()[0];
            Type rawType = type.getRawType();
            if (rawType == CompletionStage.class) {
                return Types.getEffectiveReturnType(firstTypeArgument);
            }
            if (rawType == Uni.class) {
                return Types.getEffectiveReturnType(firstTypeArgument);
            }
            if (rawType == Multi.class) {
                return Types.getEffectiveReturnType(firstTypeArgument);
            }
            if (rawType == RestResponse.class) {
                return Types.getEffectiveReturnType(firstTypeArgument);
            }
            if ("kotlinx.coroutines.flow.Flow".equals(rawType.getTypeName())) {
                return Types.getEffectiveReturnType(firstTypeArgument);
            }
            return returnType;
        }
        if (returnType instanceof WildcardType) {
            Type[] bounds = ((WildcardType)returnType).getLowerBounds();
            if (bounds.length > 0) {
                return Types.getRawType(bounds[0]);
            }
            return Types.getRawType(((WildcardType)returnType).getUpperBounds()[0]);
        }
        throw new UnsupportedOperationException("Endpoint return type not supported yet: " + String.valueOf(returnType));
    }

    public static Type getMultipartElementType(Type paramType) {
        if (paramType instanceof Class) {
            if (((Class)paramType).isArray()) {
                return ((Class)paramType).getComponentType();
            }
            return paramType;
        }
        if (paramType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)paramType;
            Type firstTypeArgument = type.getActualTypeArguments()[0];
            if (type.getRawType() == List.class) {
                return firstTypeArgument;
            }
            return paramType;
        }
        if (paramType instanceof GenericArrayType) {
            GenericArrayType type = (GenericArrayType)paramType;
            return type.getGenericComponentType();
        }
        throw new UnsupportedOperationException("Endpoint return type not supported yet: " + String.valueOf(paramType));
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Types.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return Types.getRawType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            Type[] bounds = ((WildcardType)type).getLowerBounds();
            if (bounds.length > 0) {
                return Types.getRawType(bounds[0]);
            }
            return Types.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return Types.getRawType(((GenericArrayType)type).getGenericComponentType());
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(type));
    }
}

