from typing import List, Set

from stub_generator.interface_inspector import (
    ClassInfo,
    EnumInfo,
    FunctionInfo,
    InstanceInfo,
)

from stub_generator.stub_generator.class_generator import generate_classes
from stub_generator.stub_generator.enum_generator import generate_enums
from stub_generator.stub_generator.function_generator import generate_functions
from stub_generator.stub_generator.result_builder import ResultBuilder, Import
from stub_generator.stub_generator.rtype import mapping_code


def make_stub(
    classes: List[ClassInfo],
    enums: List[EnumInfo],
    functions: List[FunctionInfo],
    instances: List[InstanceInfo],
    result_path,
    classes_to_ignore: Set[str],
):

    header = (
        "# Autogenerated do not modify manually!\n"
        "# This is a type-hinting python stub file, used by python IDEs to provide type hints. For more information\n"
        "# about stub files, see https://www.python.org/dev/peps/pep-0484/#stub-files\n"
        "# During execution, the actual module is made available via\n"
        "# a C++ Boost-python process as part of the launch."
    )

    res = ResultBuilder(header)
    res.add_built_in_import(Import("enum", ["IntEnum"]))
    res.add_built_in_import(Import("typing", ["Iterator", "Generic", "Iterable", "Tuple", "TypeVar", "overload"]))

    res.add_import(
        Import(
            "common.fo_typing",
            [
                "BuildingId",
                "BuildingName",
                "EmpireId",
                "FleetId",
                "ObjectId",
                "PartName",
                "PlanetId",
                "ShipId",
                "SpeciesName",
                "SystemId",
                "Turn",
            ],
        )
    )

    res.add_extra_declaration(mapping_code)
    res.add_classes(generate_classes(classes, instances, classes_to_ignore, enums))
    res.add_enums(generate_enums(enums))
    res.add_functions(generate_functions(functions))

    with open(result_path, "w") as f:
        res.write(f)
