# Generated from the Telepathy spec
""" Copyright (C) 2005, 2006 Collabora Limited 
 Copyright (C) 2005, 2006 Nokia Corporation 
 Copyright (C) 2006 INdT 

    This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

import dbus.service


class ChannelTypeText(dbus.service.Interface):
    """\
      A channel type for sending and receiving messages in plain text, with no
        formatting.

      When a message is received, an identifier is assigned and a Received signal
      emitted, and the message placed in a pending queue which can be inspected
      with ListPendingMessages. A client which has handled the message by showing
      it to the user (or equivalent) should acknowledge the receipt using the
      AcknowledgePendingMessage method, and the message will then be removed from
      the pending queue. Numeric identifiers for received messages may be reused
      over the lifetime of the channel.

      Each message has an associated 'type' value, which should be one of the
      values allowed by ChannelTextMessageType.

      Each message also has a flags value, which is a bitwise OR of the
      flags given in ChannelTextMessageFlags.

      Sending messages can be requested using the Send method, which will return
      and cause the Sent signal to be emitted when the message has been delivered
      to the server, or SendError if there is a failure.

      On protocols where additional contacts cannot be invited into
        a one-to-one chat, or where a one-to-one chat is just a series of
        individual personal messages rather than being represented by some
        object on the server (i.e. most protocols), one-to-one chats should be
        represented by a Text channel with handle type CONTACT.

      Named chat rooms whose identity can be saved and used again later
        (IRC channels, Jabber MUCs) are expected to be represented by Text
        channels with handle type ROOM and the Group interface; they should
        usually also have the Properties interface.

      Unnamed, transient chat rooms defined only by their members (e.g. on
        MSN) are expected to be represented by Text channels with handle type
        0, handle 0, the Group interface, and optionally the Properties
        interface.

      On protocols where a conversation with a user is actually just
        a nameless chat room starting with exactly two members, to which
        more members can be invited, calling RequestChannel with type Text
        and handle type CONTACT should continue to succeed, but may return
        a channel with handle type 0, handle 0, the group interface,
        and the local and remote contacts in its members.
    """

    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.Text', in_signature='au', out_signature='')
    def AcknowledgePendingMessages(self, ids):
        """
        Inform the channel that you have handled messages by displaying them to
        the user (or equivalent), so they can be removed from the pending queue.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.Text', in_signature='', out_signature='au')
    def GetMessageTypes(self):
        """
        Return an array indicating which types of message may be sent on this
        channel.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.Text', in_signature='b', out_signature='a(uuuuus)')
    def ListPendingMessages(self, clear):
        """
        List the messages currently in the pending queue, and optionally
        remove then all.
      
        """
        raise NotImplementedError
  
    @dbus.service.method('org.freedesktop.Telepathy.Channel.Type.Text', in_signature='us', out_signature='')
    def Send(self, type, text):
        """
        Request that a message be sent on this channel. The Sent signal will be
        emitted when the message has been sent, and this method will return.
      
        """
        raise NotImplementedError
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.Text', signature='')
    def LostMessage(self):
        """
        This signal is emitted to indicate that an incoming message was
        not able to be stored and forwarded by the connection manager
        due to lack of memory.
      
        """
        pass
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.Text', signature='uuuuus')
    def Received(self, id, timestamp, sender, type, flags, text):
        """
        Signals that a message with the given id, timestamp, sender, type
        and text has been received on this channel. Applications that catch
        this signal and reliably inform the user of the message should
        acknowledge that they have dealt with the message with the
        AcknowledgePendingMessage method.
      
        """
        pass
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.Text', signature='uuus')
    def SendError(self, error, timestamp, type, text):
        """
        Signals that an outgoing message has failed to send. The error
        will be one of the values from ChannelTextSendError.
      
        """
        pass
  
    @dbus.service.signal('org.freedesktop.Telepathy.Channel.Type.Text', signature='uus')
    def Sent(self, timestamp, type, text):
        """
        Signals that a message has been sent on this channel.
      
        """
        pass
  