/* this file was generated by the MCOP idl compiler - DO NOT EDIT */

#ifndef ARTSGUI_H
#define ARTSGUI_H

#include "common.h"

#include "arts_export.h"

namespace Arts {
enum SizePolicy {spFixed = 0, spMinimum = 1, spMaximum = 4, spPreferred = 5, spMinimumExpanding = 3, spExpanding = 7, spIgnored = 2};
enum Shape {NoFrame = 0, Box = 1, Panel = 2, WinPanel = 3, HLine = 4, VLine = 5, StyledPanel = 6, PopupPanel = 7, MenuBarPanel = 8, ToolBarPanel = 9, LineEditPanel = 10, TabWidgetPanel = 11, MShape = 15};
enum Shadow {Plain = 16, Raised = 32, Sunken = 48, MShadow = 240};
enum Align {AlignAuto = 0, AlignLeft = 1, AlignRight = 2, AlignHCenter = 4, AlignJustify = 8, AlignTop = 16, AlignBottom = 32, AlignVCenter = 64, AlignCenter = 68};
enum Direction {LeftToRight = 0, RightToLeft = 1, TopToBottom = 2, BottomToTop = 3};
enum TextBottom {South = 0, North = 1, West = 2, East = 3};
enum LevelMeterStyle {lmNormalBars = 0, lmFireBars = 1, lmLineBars = 2, lmLEDs = 3, lmAnalog = 4, lmSmall = 5};
enum Position {posLeft = 1, posRight = 2, posTop = 4, posBottom = 8};
}
namespace Arts {
class ARTS_EXPORT GraphPoint : public Arts::Type {
public:
	GraphPoint();
	GraphPoint(float _a_x, float _a_y);
	GraphPoint(Arts::Buffer& stream);
	GraphPoint(const GraphPoint& copyType);
	GraphPoint& operator=(const GraphPoint& assignType);
	float x;
	float y;

// marshalling functions
	void readType(Arts::Buffer& stream);
	void writeType(Arts::Buffer& stream) const;
	std::string _typeName() const;
};

}
namespace Arts {
class Widget;
class Frame;
class LayoutBox;
class HBox;
class VBox;
class PopupBox;
class Button;
class Poti;
class Fader;
class LineEdit;
class SpinBox;
class ComboBox;
class Graph;
class GraphLine;
class Label;
class LevelMeter;
class Tickmarks;
class VolumeFader;
class GuiFactory;
class GenericGuiFactory;

class ARTS_EXPORT Widget_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static Widget_base *_create(const std::string& subClass = "Arts::Widget");
	static Widget_base *_fromString(const std::string& objectref);
	static Widget_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Widget_base *_fromDynamicCast(const Arts::Object& object);
	inline Widget_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long widgetID() = 0;
	virtual Arts::Widget parent() = 0;
	virtual void parent(Arts::Widget newValue) = 0;
	virtual long x() = 0;
	virtual void x(long newValue) = 0;
	virtual long y() = 0;
	virtual void y(long newValue) = 0;
	virtual long width() = 0;
	virtual void width(long newValue) = 0;
	virtual long height() = 0;
	virtual void height(long newValue) = 0;
	virtual bool visible() = 0;
	virtual void visible(bool newValue) = 0;
	virtual Arts::SizePolicy hSizePolicy() = 0;
	virtual void hSizePolicy(Arts::SizePolicy newValue) = 0;
	virtual Arts::SizePolicy vSizePolicy() = 0;
	virtual void vSizePolicy(Arts::SizePolicy newValue) = 0;
	virtual void show() = 0;
	virtual void hide() = 0;
};

class ARTS_EXPORT Widget_stub : virtual public Widget_base, virtual public Arts::Object_stub {
protected:
	Widget_stub();

public:
	Widget_stub(Arts::Connection *connection, long objectID);

	long widgetID();
	Arts::Widget parent();
	void parent(Arts::Widget newValue);
	long x();
	void x(long newValue);
	long y();
	void y(long newValue);
	long width();
	void width(long newValue);
	long height();
	void height(long newValue);
	bool visible();
	void visible(bool newValue);
	Arts::SizePolicy hSizePolicy();
	void hSizePolicy(Arts::SizePolicy newValue);
	Arts::SizePolicy vSizePolicy();
	void vSizePolicy(Arts::SizePolicy newValue);
	void show();
	void hide();
};

class ARTS_EXPORT Widget_skel : virtual public Widget_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void widgetID_changed(long newValue) {
		_emit_changed("widgetID_changed",newValue);
	}
	inline void x_changed(long newValue) {
		_emit_changed("x_changed",newValue);
	}
	inline void y_changed(long newValue) {
		_emit_changed("y_changed",newValue);
	}
	inline void width_changed(long newValue) {
		_emit_changed("width_changed",newValue);
	}
	inline void height_changed(long newValue) {
		_emit_changed("height_changed",newValue);
	}
	inline void visible_changed(bool newValue) {
		_emit_changed("visible_changed",newValue);
	}
	inline void hSizePolicy_changed(Arts::SizePolicy newValue) {
		_emit_changed("hSizePolicy_changed",newValue);
	}
	inline void vSizePolicy_changed(Arts::SizePolicy newValue) {
		_emit_changed("vSizePolicy_changed",newValue);
	}

public:
	Widget_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT Widget : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Widget_base *_cache;
	inline Widget_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Widget_base *)_pool->base->_cast(Widget_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Widget(Widget_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Widget_base _base_class;

	inline Widget() : Arts::Object(_Creator), _cache(0) {}
	inline Widget(const Arts::SubClass& s) :
		Arts::Object(Widget_base::_create(s.string())), _cache(0) {}
	inline Widget(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Widget_base::_fromString(r.string())):(Widget_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Widget(const Arts::DynamicCast& c) : Arts::Object(Widget_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Widget(const Widget& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Widget(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Widget null() {return Widget((Widget_base*)0);}
	inline static Widget _from_base(Widget_base* b) {return Widget(b);}
	inline Widget& operator=(const Widget& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline Widget_base* _base() {return _cache?_cache:_method_call();}

	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
};

class ARTS_EXPORT Frame_base : virtual public Arts::Widget_base {
public:
	static unsigned long _IID; // interface ID

	static Frame_base *_create(const std::string& subClass = "Arts::Frame");
	static Frame_base *_fromString(const std::string& objectref);
	static Frame_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Frame_base *_fromDynamicCast(const Arts::Object& object);
	inline Frame_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long margin() = 0;
	virtual void margin(long newValue) = 0;
	virtual long linewidth() = 0;
	virtual void linewidth(long newValue) = 0;
	virtual long midlinewidth() = 0;
	virtual void midlinewidth(long newValue) = 0;
	virtual long framestyle() = 0;
	virtual void framestyle(long newValue) = 0;
	virtual Arts::Shape frameshape() = 0;
	virtual void frameshape(Arts::Shape newValue) = 0;
	virtual Arts::Shadow frameshadow() = 0;
	virtual void frameshadow(Arts::Shadow newValue) = 0;
	virtual void constructor(Arts::Widget parent) = 0;
};

class ARTS_EXPORT Frame_stub : virtual public Frame_base, virtual public Arts::Widget_stub {
protected:
	Frame_stub();

public:
	Frame_stub(Arts::Connection *connection, long objectID);

	long margin();
	void margin(long newValue);
	long linewidth();
	void linewidth(long newValue);
	long midlinewidth();
	void midlinewidth(long newValue);
	long framestyle();
	void framestyle(long newValue);
	Arts::Shape frameshape();
	void frameshape(Arts::Shape newValue);
	Arts::Shadow frameshadow();
	void frameshadow(Arts::Shadow newValue);
	void constructor(Arts::Widget parent);
};

class ARTS_EXPORT Frame_skel : virtual public Frame_base, virtual public Arts::Widget_skel {
protected:
	// emitters for change notifications
	inline void margin_changed(long newValue) {
		_emit_changed("margin_changed",newValue);
	}
	inline void linewidth_changed(long newValue) {
		_emit_changed("linewidth_changed",newValue);
	}
	inline void midlinewidth_changed(long newValue) {
		_emit_changed("midlinewidth_changed",newValue);
	}
	inline void framestyle_changed(long newValue) {
		_emit_changed("framestyle_changed",newValue);
	}
	inline void frameshape_changed(Arts::Shape newValue) {
		_emit_changed("frameshape_changed",newValue);
	}
	inline void frameshadow_changed(Arts::Shadow newValue) {
		_emit_changed("frameshadow_changed",newValue);
	}

public:
	Frame_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT Frame : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Frame_base *_cache;
	inline Frame_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Frame_base *)_pool->base->_cast(Frame_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Frame(Frame_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Frame_base _base_class;

	inline Frame() : Arts::Object(_Creator), _cache(0) {}
	inline Frame(const Arts::SubClass& s) :
		Arts::Object(Frame_base::_create(s.string())), _cache(0) {}
	inline Frame(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Frame_base::_fromString(r.string())):(Frame_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Frame(const Arts::DynamicCast& c) : Arts::Object(Frame_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Frame(const Frame& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Frame(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Frame null() {return Frame((Frame_base*)0);}
	inline static Frame _from_base(Frame_base* b) {return Frame(b);}
	inline Frame& operator=(const Frame& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline Frame_base* _base() {return _cache?_cache:_method_call();}

	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline Frame(Arts::Widget parent);
};

class ARTS_EXPORT LayoutBox_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static LayoutBox_base *_create(const std::string& subClass = "Arts::LayoutBox");
	static LayoutBox_base *_fromString(const std::string& objectref);
	static LayoutBox_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static LayoutBox_base *_fromDynamicCast(const Arts::Object& object);
	inline LayoutBox_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::Direction direction() = 0;
	virtual void direction(Arts::Direction newValue) = 0;
	virtual long spacing() = 0;
	virtual void spacing(long newValue) = 0;
	virtual long layoutmargin() = 0;
	virtual void layoutmargin(long newValue) = 0;
	virtual void addWidget(Arts::Widget widget, long stretch, long align) = 0;
	virtual void addWidget(Arts::Widget widget, long stretch) = 0;
	virtual void addWidget(Arts::Widget widget) = 0;
	virtual void insertWidget(long position, Arts::Widget widget, long stretch, long align) = 0;
	virtual void insertWidget(long position, Arts::Widget widget, long stretch) = 0;
	virtual void insertWidget(long position, Arts::Widget widget) = 0;
	virtual void addStretch(long stretch) = 0;
	virtual void addStretch() = 0;
	virtual void addSpace(long space) = 0;
	virtual void addStrut(long size) = 0;
	virtual void addSeparator(long stretch, long align) = 0;
	virtual void addSeparator(long stretch) = 0;
	virtual void addSeparator() = 0;
	virtual void addLine(long width, long space, long stretch, long align) = 0;
	virtual void addLine(long width, long space, long stretch) = 0;
	virtual void addLine(long width, long space) = 0;
};

class ARTS_EXPORT LayoutBox_stub : virtual public LayoutBox_base, virtual public Arts::Frame_stub {
protected:
	LayoutBox_stub();

public:
	LayoutBox_stub(Arts::Connection *connection, long objectID);

	Arts::Direction direction();
	void direction(Arts::Direction newValue);
	long spacing();
	void spacing(long newValue);
	long layoutmargin();
	void layoutmargin(long newValue);
	void addWidget(Arts::Widget widget, long stretch, long align);
	void addWidget(Arts::Widget widget, long stretch);
	void addWidget(Arts::Widget widget);
	void insertWidget(long position, Arts::Widget widget, long stretch, long align);
	void insertWidget(long position, Arts::Widget widget, long stretch);
	void insertWidget(long position, Arts::Widget widget);
	void addStretch(long stretch);
	void addStretch();
	void addSpace(long space);
	void addStrut(long size);
	void addSeparator(long stretch, long align);
	void addSeparator(long stretch);
	void addSeparator();
	void addLine(long width, long space, long stretch, long align);
	void addLine(long width, long space, long stretch);
	void addLine(long width, long space);
};

class ARTS_EXPORT LayoutBox_skel : virtual public LayoutBox_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void direction_changed(Arts::Direction newValue) {
		_emit_changed("direction_changed",newValue);
	}
	inline void spacing_changed(long newValue) {
		_emit_changed("spacing_changed",newValue);
	}
	inline void layoutmargin_changed(long newValue) {
		_emit_changed("layoutmargin_changed",newValue);
	}

public:
	LayoutBox_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT LayoutBox : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	LayoutBox_base *_cache;
	inline LayoutBox_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(LayoutBox_base *)_pool->base->_cast(LayoutBox_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline LayoutBox(LayoutBox_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef LayoutBox_base _base_class;

	inline LayoutBox() : Arts::Object(_Creator), _cache(0) {}
	inline LayoutBox(const Arts::SubClass& s) :
		Arts::Object(LayoutBox_base::_create(s.string())), _cache(0) {}
	inline LayoutBox(const Arts::Reference &r) :
		Arts::Object(r.isString()?(LayoutBox_base::_fromString(r.string())):(LayoutBox_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline LayoutBox(const Arts::DynamicCast& c) : Arts::Object(LayoutBox_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline LayoutBox(const LayoutBox& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline LayoutBox(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static LayoutBox null() {return LayoutBox((LayoutBox_base*)0);}
	inline static LayoutBox _from_base(LayoutBox_base* b) {return LayoutBox(b);}
	inline LayoutBox& operator=(const LayoutBox& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline LayoutBox_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline LayoutBox(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline Arts::Direction direction();
	inline void direction(Arts::Direction _newValue);
	inline long spacing();
	inline void spacing(long _newValue);
	inline long layoutmargin();
	inline void layoutmargin(long _newValue);
	inline void addWidget(Arts::Widget widget, long stretch, long align);
	inline void addWidget(Arts::Widget widget, long stretch);
	inline void addWidget(Arts::Widget widget);
	inline void insertWidget(long position, Arts::Widget widget, long stretch, long align);
	inline void insertWidget(long position, Arts::Widget widget, long stretch);
	inline void insertWidget(long position, Arts::Widget widget);
	inline void addStretch(long stretch);
	inline void addStretch();
	inline void addSpace(long space);
	inline void addStrut(long size);
	inline void addSeparator(long stretch, long align);
	inline void addSeparator(long stretch);
	inline void addSeparator();
	inline void addLine(long width, long space, long stretch, long align);
	inline void addLine(long width, long space, long stretch);
	inline void addLine(long width, long space);
};

class ARTS_EXPORT HBox_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static HBox_base *_create(const std::string& subClass = "Arts::HBox");
	static HBox_base *_fromString(const std::string& objectref);
	static HBox_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static HBox_base *_fromDynamicCast(const Arts::Object& object);
	inline HBox_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long spacing() = 0;
	virtual void spacing(long newValue) = 0;
};

class ARTS_EXPORT HBox_stub : virtual public HBox_base, virtual public Arts::Frame_stub {
protected:
	HBox_stub();

public:
	HBox_stub(Arts::Connection *connection, long objectID);

	long spacing();
	void spacing(long newValue);
};

class ARTS_EXPORT HBox_skel : virtual public HBox_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void spacing_changed(long newValue) {
		_emit_changed("spacing_changed",newValue);
	}

public:
	HBox_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT HBox : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	HBox_base *_cache;
	inline HBox_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(HBox_base *)_pool->base->_cast(HBox_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline HBox(HBox_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef HBox_base _base_class;

	inline HBox() : Arts::Object(_Creator), _cache(0) {}
	inline HBox(const Arts::SubClass& s) :
		Arts::Object(HBox_base::_create(s.string())), _cache(0) {}
	inline HBox(const Arts::Reference &r) :
		Arts::Object(r.isString()?(HBox_base::_fromString(r.string())):(HBox_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline HBox(const Arts::DynamicCast& c) : Arts::Object(HBox_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline HBox(const HBox& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline HBox(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static HBox null() {return HBox((HBox_base*)0);}
	inline static HBox _from_base(HBox_base* b) {return HBox(b);}
	inline HBox& operator=(const HBox& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline HBox_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline HBox(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline long spacing();
	inline void spacing(long _newValue);
};

class ARTS_EXPORT VBox_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static VBox_base *_create(const std::string& subClass = "Arts::VBox");
	static VBox_base *_fromString(const std::string& objectref);
	static VBox_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static VBox_base *_fromDynamicCast(const Arts::Object& object);
	inline VBox_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual long spacing() = 0;
	virtual void spacing(long newValue) = 0;
};

class ARTS_EXPORT VBox_stub : virtual public VBox_base, virtual public Arts::Frame_stub {
protected:
	VBox_stub();

public:
	VBox_stub(Arts::Connection *connection, long objectID);

	long spacing();
	void spacing(long newValue);
};

class ARTS_EXPORT VBox_skel : virtual public VBox_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void spacing_changed(long newValue) {
		_emit_changed("spacing_changed",newValue);
	}

public:
	VBox_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT VBox : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	VBox_base *_cache;
	inline VBox_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(VBox_base *)_pool->base->_cast(VBox_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline VBox(VBox_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef VBox_base _base_class;

	inline VBox() : Arts::Object(_Creator), _cache(0) {}
	inline VBox(const Arts::SubClass& s) :
		Arts::Object(VBox_base::_create(s.string())), _cache(0) {}
	inline VBox(const Arts::Reference &r) :
		Arts::Object(r.isString()?(VBox_base::_fromString(r.string())):(VBox_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline VBox(const Arts::DynamicCast& c) : Arts::Object(VBox_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline VBox(const VBox& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline VBox(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static VBox null() {return VBox((VBox_base*)0);}
	inline static VBox _from_base(VBox_base* b) {return VBox(b);}
	inline VBox& operator=(const VBox& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline VBox_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline VBox(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline long spacing();
	inline void spacing(long _newValue);
};

class ARTS_EXPORT PopupBox_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static PopupBox_base *_create(const std::string& subClass = "Arts::PopupBox");
	static PopupBox_base *_fromString(const std::string& objectref);
	static PopupBox_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static PopupBox_base *_fromDynamicCast(const Arts::Object& object);
	inline PopupBox_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::Direction direction() = 0;
	virtual void direction(Arts::Direction newValue) = 0;
	virtual std::string name() = 0;
	virtual void name(const std::string& newValue) = 0;
	virtual Arts::Widget widget() = 0;
	virtual void widget(Arts::Widget newValue) = 0;
};

class ARTS_EXPORT PopupBox_stub : virtual public PopupBox_base, virtual public Arts::Frame_stub {
protected:
	PopupBox_stub();

public:
	PopupBox_stub(Arts::Connection *connection, long objectID);

	Arts::Direction direction();
	void direction(Arts::Direction newValue);
	std::string name();
	void name(const std::string& newValue);
	Arts::Widget widget();
	void widget(Arts::Widget newValue);
};

class ARTS_EXPORT PopupBox_skel : virtual public PopupBox_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void direction_changed(Arts::Direction newValue) {
		_emit_changed("direction_changed",newValue);
	}
	inline void name_changed(const std::string& newValue) {
		_emit_changed("name_changed",newValue);
	}

public:
	PopupBox_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT PopupBox : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	PopupBox_base *_cache;
	inline PopupBox_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(PopupBox_base *)_pool->base->_cast(PopupBox_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline PopupBox(PopupBox_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef PopupBox_base _base_class;

	inline PopupBox() : Arts::Object(_Creator), _cache(0) {}
	inline PopupBox(const Arts::SubClass& s) :
		Arts::Object(PopupBox_base::_create(s.string())), _cache(0) {}
	inline PopupBox(const Arts::Reference &r) :
		Arts::Object(r.isString()?(PopupBox_base::_fromString(r.string())):(PopupBox_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline PopupBox(const Arts::DynamicCast& c) : Arts::Object(PopupBox_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline PopupBox(const PopupBox& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline PopupBox(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static PopupBox null() {return PopupBox((PopupBox_base*)0);}
	inline static PopupBox _from_base(PopupBox_base* b) {return PopupBox(b);}
	inline PopupBox& operator=(const PopupBox& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline PopupBox_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline PopupBox(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline Arts::Direction direction();
	inline void direction(Arts::Direction _newValue);
	inline std::string name();
	inline void name(const std::string& _newValue);
	inline Arts::Widget widget();
	inline void widget(Arts::Widget _newValue);
};

class ARTS_EXPORT Button_base : virtual public Arts::Widget_base {
public:
	static unsigned long _IID; // interface ID

	static Button_base *_create(const std::string& subClass = "Arts::Button");
	static Button_base *_fromString(const std::string& objectref);
	static Button_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Button_base *_fromDynamicCast(const Arts::Object& object);
	inline Button_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string text() = 0;
	virtual void text(const std::string& newValue) = 0;
	virtual bool toggle() = 0;
	virtual void toggle(bool newValue) = 0;
	virtual bool pressed() = 0;
	virtual bool clicked() = 0;
	virtual void constructor(Arts::Widget parent) = 0;
	virtual void constructor(const std::string& text, Arts::Widget parent) = 0;
};

class ARTS_EXPORT Button_stub : virtual public Button_base, virtual public Arts::Widget_stub {
protected:
	Button_stub();

public:
	Button_stub(Arts::Connection *connection, long objectID);

	std::string text();
	void text(const std::string& newValue);
	bool toggle();
	void toggle(bool newValue);
	bool pressed();
	bool clicked();
	void constructor(Arts::Widget parent);
	void constructor(const std::string& text, Arts::Widget parent);
};

class ARTS_EXPORT Button_skel : virtual public Button_base, virtual public Arts::Widget_skel {
protected:
	// emitters for change notifications
	inline void text_changed(const std::string& newValue) {
		_emit_changed("text_changed",newValue);
	}
	inline void toggle_changed(bool newValue) {
		_emit_changed("toggle_changed",newValue);
	}
	inline void pressed_changed(bool newValue) {
		_emit_changed("pressed_changed",newValue);
	}
	inline void clicked_changed(bool newValue) {
		_emit_changed("clicked_changed",newValue);
	}

public:
	Button_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT Button : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Button_base *_cache;
	inline Button_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Button_base *)_pool->base->_cast(Button_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Button(Button_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Button_base _base_class;

	inline Button() : Arts::Object(_Creator), _cache(0) {}
	inline Button(const Arts::SubClass& s) :
		Arts::Object(Button_base::_create(s.string())), _cache(0) {}
	inline Button(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Button_base::_fromString(r.string())):(Button_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Button(const Arts::DynamicCast& c) : Arts::Object(Button_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Button(const Button& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Button(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Button null() {return Button((Button_base*)0);}
	inline static Button _from_base(Button_base* b) {return Button(b);}
	inline Button& operator=(const Button& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline Button_base* _base() {return _cache?_cache:_method_call();}

	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline std::string text();
	inline void text(const std::string& _newValue);
	inline bool toggle();
	inline void toggle(bool _newValue);
	inline bool pressed();
	inline bool clicked();
	inline Button(Arts::Widget parent);
	inline Button(const std::string& text, Arts::Widget parent);
};

class ARTS_EXPORT Poti_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static Poti_base *_create(const std::string& subClass = "Arts::Poti");
	static Poti_base *_fromString(const std::string& objectref);
	static Poti_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Poti_base *_fromDynamicCast(const Arts::Object& object);
	inline Poti_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string caption() = 0;
	virtual void caption(const std::string& newValue) = 0;
	virtual std::string color() = 0;
	virtual void color(const std::string& newValue) = 0;
	virtual float min() = 0;
	virtual void min(float newValue) = 0;
	virtual float max() = 0;
	virtual void max(float newValue) = 0;
	virtual float value() = 0;
	virtual void value(float newValue) = 0;
	virtual float logarithmic() = 0;
	virtual void logarithmic(float newValue) = 0;
	virtual long range() = 0;
	virtual void range(long newValue) = 0;
};

class ARTS_EXPORT Poti_stub : virtual public Poti_base, virtual public Arts::Frame_stub {
protected:
	Poti_stub();

public:
	Poti_stub(Arts::Connection *connection, long objectID);

	std::string caption();
	void caption(const std::string& newValue);
	std::string color();
	void color(const std::string& newValue);
	float min();
	void min(float newValue);
	float max();
	void max(float newValue);
	float value();
	void value(float newValue);
	float logarithmic();
	void logarithmic(float newValue);
	long range();
	void range(long newValue);
};

class ARTS_EXPORT Poti_skel : virtual public Poti_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void caption_changed(const std::string& newValue) {
		_emit_changed("caption_changed",newValue);
	}
	inline void color_changed(const std::string& newValue) {
		_emit_changed("color_changed",newValue);
	}
	inline void min_changed(float newValue) {
		_emit_changed("min_changed",newValue);
	}
	inline void max_changed(float newValue) {
		_emit_changed("max_changed",newValue);
	}
	inline void value_changed(float newValue) {
		_emit_changed("value_changed",newValue);
	}
	inline void logarithmic_changed(float newValue) {
		_emit_changed("logarithmic_changed",newValue);
	}
	inline void range_changed(long newValue) {
		_emit_changed("range_changed",newValue);
	}

public:
	Poti_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT Poti : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Poti_base *_cache;
	inline Poti_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Poti_base *)_pool->base->_cast(Poti_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Poti(Poti_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Poti_base _base_class;

	inline Poti() : Arts::Object(_Creator), _cache(0) {}
	inline Poti(const Arts::SubClass& s) :
		Arts::Object(Poti_base::_create(s.string())), _cache(0) {}
	inline Poti(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Poti_base::_fromString(r.string())):(Poti_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Poti(const Arts::DynamicCast& c) : Arts::Object(Poti_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Poti(const Poti& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Poti(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Poti null() {return Poti((Poti_base*)0);}
	inline static Poti _from_base(Poti_base* b) {return Poti(b);}
	inline Poti& operator=(const Poti& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline Poti_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline Poti(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline std::string caption();
	inline void caption(const std::string& _newValue);
	inline std::string color();
	inline void color(const std::string& _newValue);
	inline float min();
	inline void min(float _newValue);
	inline float max();
	inline void max(float _newValue);
	inline float value();
	inline void value(float _newValue);
	inline float logarithmic();
	inline void logarithmic(float _newValue);
	inline long range();
	inline void range(long _newValue);
};

class ARTS_EXPORT Fader_base : virtual public Arts::Widget_base {
public:
	static unsigned long _IID; // interface ID

	static Fader_base *_create(const std::string& subClass = "Arts::Fader");
	static Fader_base *_fromString(const std::string& objectref);
	static Fader_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Fader_base *_fromDynamicCast(const Arts::Object& object);
	inline Fader_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string caption() = 0;
	virtual void caption(const std::string& newValue) = 0;
	virtual std::string color() = 0;
	virtual void color(const std::string& newValue) = 0;
	virtual float min() = 0;
	virtual void min(float newValue) = 0;
	virtual float max() = 0;
	virtual void max(float newValue) = 0;
	virtual float value() = 0;
	virtual void value(float newValue) = 0;
	virtual float logarithmic() = 0;
	virtual void logarithmic(float newValue) = 0;
	virtual void constructor(Arts::Widget parent) = 0;
};

class ARTS_EXPORT Fader_stub : virtual public Fader_base, virtual public Arts::Widget_stub {
protected:
	Fader_stub();

public:
	Fader_stub(Arts::Connection *connection, long objectID);

	std::string caption();
	void caption(const std::string& newValue);
	std::string color();
	void color(const std::string& newValue);
	float min();
	void min(float newValue);
	float max();
	void max(float newValue);
	float value();
	void value(float newValue);
	float logarithmic();
	void logarithmic(float newValue);
	void constructor(Arts::Widget parent);
};

class ARTS_EXPORT Fader_skel : virtual public Fader_base, virtual public Arts::Widget_skel {
protected:
	// emitters for change notifications
	inline void caption_changed(const std::string& newValue) {
		_emit_changed("caption_changed",newValue);
	}
	inline void color_changed(const std::string& newValue) {
		_emit_changed("color_changed",newValue);
	}
	inline void min_changed(float newValue) {
		_emit_changed("min_changed",newValue);
	}
	inline void max_changed(float newValue) {
		_emit_changed("max_changed",newValue);
	}
	inline void value_changed(float newValue) {
		_emit_changed("value_changed",newValue);
	}
	inline void logarithmic_changed(float newValue) {
		_emit_changed("logarithmic_changed",newValue);
	}

public:
	Fader_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT Fader : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Fader_base *_cache;
	inline Fader_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Fader_base *)_pool->base->_cast(Fader_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Fader(Fader_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Fader_base _base_class;

	inline Fader() : Arts::Object(_Creator), _cache(0) {}
	inline Fader(const Arts::SubClass& s) :
		Arts::Object(Fader_base::_create(s.string())), _cache(0) {}
	inline Fader(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Fader_base::_fromString(r.string())):(Fader_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Fader(const Arts::DynamicCast& c) : Arts::Object(Fader_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Fader(const Fader& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Fader(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Fader null() {return Fader((Fader_base*)0);}
	inline static Fader _from_base(Fader_base* b) {return Fader(b);}
	inline Fader& operator=(const Fader& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline Fader_base* _base() {return _cache?_cache:_method_call();}

	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline std::string caption();
	inline void caption(const std::string& _newValue);
	inline std::string color();
	inline void color(const std::string& _newValue);
	inline float min();
	inline void min(float _newValue);
	inline float max();
	inline void max(float _newValue);
	inline float value();
	inline void value(float _newValue);
	inline float logarithmic();
	inline void logarithmic(float _newValue);
	inline Fader(Arts::Widget parent);
};

class ARTS_EXPORT LineEdit_base : virtual public Arts::Widget_base {
public:
	static unsigned long _IID; // interface ID

	static LineEdit_base *_create(const std::string& subClass = "Arts::LineEdit");
	static LineEdit_base *_fromString(const std::string& objectref);
	static LineEdit_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static LineEdit_base *_fromDynamicCast(const Arts::Object& object);
	inline LineEdit_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string caption() = 0;
	virtual void caption(const std::string& newValue) = 0;
	virtual std::string text() = 0;
	virtual void text(const std::string& newValue) = 0;
	virtual void constructor(Arts::Widget parent) = 0;
};

class ARTS_EXPORT LineEdit_stub : virtual public LineEdit_base, virtual public Arts::Widget_stub {
protected:
	LineEdit_stub();

public:
	LineEdit_stub(Arts::Connection *connection, long objectID);

	std::string caption();
	void caption(const std::string& newValue);
	std::string text();
	void text(const std::string& newValue);
	void constructor(Arts::Widget parent);
};

class ARTS_EXPORT LineEdit_skel : virtual public LineEdit_base, virtual public Arts::Widget_skel {
protected:
	// emitters for change notifications
	inline void caption_changed(const std::string& newValue) {
		_emit_changed("caption_changed",newValue);
	}
	inline void text_changed(const std::string& newValue) {
		_emit_changed("text_changed",newValue);
	}

public:
	LineEdit_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT LineEdit : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	LineEdit_base *_cache;
	inline LineEdit_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(LineEdit_base *)_pool->base->_cast(LineEdit_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline LineEdit(LineEdit_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef LineEdit_base _base_class;

	inline LineEdit() : Arts::Object(_Creator), _cache(0) {}
	inline LineEdit(const Arts::SubClass& s) :
		Arts::Object(LineEdit_base::_create(s.string())), _cache(0) {}
	inline LineEdit(const Arts::Reference &r) :
		Arts::Object(r.isString()?(LineEdit_base::_fromString(r.string())):(LineEdit_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline LineEdit(const Arts::DynamicCast& c) : Arts::Object(LineEdit_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline LineEdit(const LineEdit& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline LineEdit(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static LineEdit null() {return LineEdit((LineEdit_base*)0);}
	inline static LineEdit _from_base(LineEdit_base* b) {return LineEdit(b);}
	inline LineEdit& operator=(const LineEdit& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline LineEdit_base* _base() {return _cache?_cache:_method_call();}

	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline std::string caption();
	inline void caption(const std::string& _newValue);
	inline std::string text();
	inline void text(const std::string& _newValue);
	inline LineEdit(Arts::Widget parent);
};

class ARTS_EXPORT SpinBox_base : virtual public Arts::Widget_base {
public:
	static unsigned long _IID; // interface ID

	static SpinBox_base *_create(const std::string& subClass = "Arts::SpinBox");
	static SpinBox_base *_fromString(const std::string& objectref);
	static SpinBox_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static SpinBox_base *_fromDynamicCast(const Arts::Object& object);
	inline SpinBox_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string caption() = 0;
	virtual void caption(const std::string& newValue) = 0;
	virtual long min() = 0;
	virtual void min(long newValue) = 0;
	virtual long max() = 0;
	virtual void max(long newValue) = 0;
	virtual long value() = 0;
	virtual void value(long newValue) = 0;
	virtual void constructor(Arts::Widget parent) = 0;
};

class ARTS_EXPORT SpinBox_stub : virtual public SpinBox_base, virtual public Arts::Widget_stub {
protected:
	SpinBox_stub();

public:
	SpinBox_stub(Arts::Connection *connection, long objectID);

	std::string caption();
	void caption(const std::string& newValue);
	long min();
	void min(long newValue);
	long max();
	void max(long newValue);
	long value();
	void value(long newValue);
	void constructor(Arts::Widget parent);
};

class ARTS_EXPORT SpinBox_skel : virtual public SpinBox_base, virtual public Arts::Widget_skel {
protected:
	// emitters for change notifications
	inline void caption_changed(const std::string& newValue) {
		_emit_changed("caption_changed",newValue);
	}
	inline void min_changed(long newValue) {
		_emit_changed("min_changed",newValue);
	}
	inline void max_changed(long newValue) {
		_emit_changed("max_changed",newValue);
	}
	inline void value_changed(long newValue) {
		_emit_changed("value_changed",newValue);
	}

public:
	SpinBox_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT SpinBox : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	SpinBox_base *_cache;
	inline SpinBox_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(SpinBox_base *)_pool->base->_cast(SpinBox_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline SpinBox(SpinBox_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef SpinBox_base _base_class;

	inline SpinBox() : Arts::Object(_Creator), _cache(0) {}
	inline SpinBox(const Arts::SubClass& s) :
		Arts::Object(SpinBox_base::_create(s.string())), _cache(0) {}
	inline SpinBox(const Arts::Reference &r) :
		Arts::Object(r.isString()?(SpinBox_base::_fromString(r.string())):(SpinBox_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline SpinBox(const Arts::DynamicCast& c) : Arts::Object(SpinBox_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline SpinBox(const SpinBox& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline SpinBox(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static SpinBox null() {return SpinBox((SpinBox_base*)0);}
	inline static SpinBox _from_base(SpinBox_base* b) {return SpinBox(b);}
	inline SpinBox& operator=(const SpinBox& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline SpinBox_base* _base() {return _cache?_cache:_method_call();}

	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline std::string caption();
	inline void caption(const std::string& _newValue);
	inline long min();
	inline void min(long _newValue);
	inline long max();
	inline void max(long _newValue);
	inline long value();
	inline void value(long _newValue);
	inline SpinBox(Arts::Widget parent);
};

class ARTS_EXPORT ComboBox_base : virtual public Arts::Widget_base {
public:
	static unsigned long _IID; // interface ID

	static ComboBox_base *_create(const std::string& subClass = "Arts::ComboBox");
	static ComboBox_base *_fromString(const std::string& objectref);
	static ComboBox_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static ComboBox_base *_fromDynamicCast(const Arts::Object& object);
	inline ComboBox_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string caption() = 0;
	virtual void caption(const std::string& newValue) = 0;
	virtual std::vector<std::string> * choices() = 0;
	virtual void choices(const std::vector<std::string>& newValue) = 0;
	virtual std::string value() = 0;
	virtual void value(const std::string& newValue) = 0;
	virtual void constructor(Arts::Widget parent) = 0;
};

class ARTS_EXPORT ComboBox_stub : virtual public ComboBox_base, virtual public Arts::Widget_stub {
protected:
	ComboBox_stub();

public:
	ComboBox_stub(Arts::Connection *connection, long objectID);

	std::string caption();
	void caption(const std::string& newValue);
	std::vector<std::string> * choices();
	void choices(const std::vector<std::string>& newValue);
	std::string value();
	void value(const std::string& newValue);
	void constructor(Arts::Widget parent);
};

class ARTS_EXPORT ComboBox_skel : virtual public ComboBox_base, virtual public Arts::Widget_skel {
protected:
	// emitters for change notifications
	inline void caption_changed(const std::string& newValue) {
		_emit_changed("caption_changed",newValue);
	}
	inline void choices_changed(const std::vector<std::string>& newValue) {
		_emit_changed("choices_changed",newValue);
	}
	inline void value_changed(const std::string& newValue) {
		_emit_changed("value_changed",newValue);
	}

public:
	ComboBox_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT ComboBox : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	ComboBox_base *_cache;
	inline ComboBox_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(ComboBox_base *)_pool->base->_cast(ComboBox_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline ComboBox(ComboBox_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef ComboBox_base _base_class;

	inline ComboBox() : Arts::Object(_Creator), _cache(0) {}
	inline ComboBox(const Arts::SubClass& s) :
		Arts::Object(ComboBox_base::_create(s.string())), _cache(0) {}
	inline ComboBox(const Arts::Reference &r) :
		Arts::Object(r.isString()?(ComboBox_base::_fromString(r.string())):(ComboBox_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline ComboBox(const Arts::DynamicCast& c) : Arts::Object(ComboBox_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline ComboBox(const ComboBox& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline ComboBox(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static ComboBox null() {return ComboBox((ComboBox_base*)0);}
	inline static ComboBox _from_base(ComboBox_base* b) {return ComboBox(b);}
	inline ComboBox& operator=(const ComboBox& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline ComboBox_base* _base() {return _cache?_cache:_method_call();}

	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline std::string caption();
	inline void caption(const std::string& _newValue);
	inline std::vector<std::string> * choices();
	inline void choices(const std::vector<std::string>& _newValue);
	inline std::string value();
	inline void value(const std::string& _newValue);
	inline ComboBox(Arts::Widget parent);
};

class ARTS_EXPORT Graph_base : virtual public Arts::Widget_base {
public:
	static unsigned long _IID; // interface ID

	static Graph_base *_create(const std::string& subClass = "Arts::Graph");
	static Graph_base *_fromString(const std::string& objectref);
	static Graph_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Graph_base *_fromDynamicCast(const Arts::Object& object);
	inline Graph_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string caption() = 0;
	virtual void caption(const std::string& newValue) = 0;
	virtual float minx() = 0;
	virtual void minx(float newValue) = 0;
	virtual float maxx() = 0;
	virtual void maxx(float newValue) = 0;
	virtual float miny() = 0;
	virtual void miny(float newValue) = 0;
	virtual float maxy() = 0;
	virtual void maxy(float newValue) = 0;
	virtual void constructor(Arts::Widget parent) = 0;
};

class ARTS_EXPORT Graph_stub : virtual public Graph_base, virtual public Arts::Widget_stub {
protected:
	Graph_stub();

public:
	Graph_stub(Arts::Connection *connection, long objectID);

	std::string caption();
	void caption(const std::string& newValue);
	float minx();
	void minx(float newValue);
	float maxx();
	void maxx(float newValue);
	float miny();
	void miny(float newValue);
	float maxy();
	void maxy(float newValue);
	void constructor(Arts::Widget parent);
};

class ARTS_EXPORT Graph_skel : virtual public Graph_base, virtual public Arts::Widget_skel {
protected:
	// emitters for change notifications
	inline void caption_changed(const std::string& newValue) {
		_emit_changed("caption_changed",newValue);
	}
	inline void minx_changed(float newValue) {
		_emit_changed("minx_changed",newValue);
	}
	inline void maxx_changed(float newValue) {
		_emit_changed("maxx_changed",newValue);
	}
	inline void miny_changed(float newValue) {
		_emit_changed("miny_changed",newValue);
	}
	inline void maxy_changed(float newValue) {
		_emit_changed("maxy_changed",newValue);
	}

public:
	Graph_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT Graph : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Graph_base *_cache;
	inline Graph_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Graph_base *)_pool->base->_cast(Graph_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Graph(Graph_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Graph_base _base_class;

	inline Graph() : Arts::Object(_Creator), _cache(0) {}
	inline Graph(const Arts::SubClass& s) :
		Arts::Object(Graph_base::_create(s.string())), _cache(0) {}
	inline Graph(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Graph_base::_fromString(r.string())):(Graph_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Graph(const Arts::DynamicCast& c) : Arts::Object(Graph_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Graph(const Graph& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Graph(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Graph null() {return Graph((Graph_base*)0);}
	inline static Graph _from_base(Graph_base* b) {return Graph(b);}
	inline Graph& operator=(const Graph& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline Graph_base* _base() {return _cache?_cache:_method_call();}

	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline std::string caption();
	inline void caption(const std::string& _newValue);
	inline float minx();
	inline void minx(float _newValue);
	inline float maxx();
	inline void maxx(float _newValue);
	inline float miny();
	inline void miny(float _newValue);
	inline float maxy();
	inline void maxy(float _newValue);
	inline Graph(Arts::Widget parent);
};

class ARTS_EXPORT GraphLine_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static GraphLine_base *_create(const std::string& subClass = "Arts::GraphLine");
	static GraphLine_base *_fromString(const std::string& objectref);
	static GraphLine_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static GraphLine_base *_fromDynamicCast(const Arts::Object& object);
	inline GraphLine_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::Graph graph() = 0;
	virtual void graph(Arts::Graph newValue) = 0;
	virtual bool editable() = 0;
	virtual void editable(bool newValue) = 0;
	virtual std::string color() = 0;
	virtual void color(const std::string& newValue) = 0;
	virtual std::vector<Arts::GraphPoint> * points() = 0;
	virtual void points(const std::vector<Arts::GraphPoint>& newValue) = 0;
};

class ARTS_EXPORT GraphLine_stub : virtual public GraphLine_base, virtual public Arts::Object_stub {
protected:
	GraphLine_stub();

public:
	GraphLine_stub(Arts::Connection *connection, long objectID);

	Arts::Graph graph();
	void graph(Arts::Graph newValue);
	bool editable();
	void editable(bool newValue);
	std::string color();
	void color(const std::string& newValue);
	std::vector<Arts::GraphPoint> * points();
	void points(const std::vector<Arts::GraphPoint>& newValue);
};

class ARTS_EXPORT GraphLine_skel : virtual public GraphLine_base, virtual public Arts::Object_skel {
protected:
	// emitters for change notifications
	inline void editable_changed(bool newValue) {
		_emit_changed("editable_changed",newValue);
	}
	inline void color_changed(const std::string& newValue) {
		_emit_changed("color_changed",newValue);
	}

public:
	GraphLine_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT GraphLine : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	GraphLine_base *_cache;
	inline GraphLine_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(GraphLine_base *)_pool->base->_cast(GraphLine_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline GraphLine(GraphLine_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef GraphLine_base _base_class;

	inline GraphLine() : Arts::Object(_Creator), _cache(0) {}
	inline GraphLine(const Arts::SubClass& s) :
		Arts::Object(GraphLine_base::_create(s.string())), _cache(0) {}
	inline GraphLine(const Arts::Reference &r) :
		Arts::Object(r.isString()?(GraphLine_base::_fromString(r.string())):(GraphLine_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline GraphLine(const Arts::DynamicCast& c) : Arts::Object(GraphLine_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline GraphLine(const GraphLine& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline GraphLine(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static GraphLine null() {return GraphLine((GraphLine_base*)0);}
	inline static GraphLine _from_base(GraphLine_base* b) {return GraphLine(b);}
	inline GraphLine& operator=(const GraphLine& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline GraphLine_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Graph graph();
	inline void graph(Arts::Graph _newValue);
	inline bool editable();
	inline void editable(bool _newValue);
	inline std::string color();
	inline void color(const std::string& _newValue);
	inline std::vector<Arts::GraphPoint> * points();
	inline void points(const std::vector<Arts::GraphPoint>& _newValue);
};

class ARTS_EXPORT Label_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static Label_base *_create(const std::string& subClass = "Arts::Label");
	static Label_base *_fromString(const std::string& objectref);
	static Label_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Label_base *_fromDynamicCast(const Arts::Object& object);
	inline Label_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual std::string text() = 0;
	virtual void text(const std::string& newValue) = 0;
	virtual long align() = 0;
	virtual void align(long newValue) = 0;
	virtual long fontsize() = 0;
	virtual void fontsize(long newValue) = 0;
	virtual std::string fontfamily() = 0;
	virtual void fontfamily(const std::string& newValue) = 0;
	virtual Arts::TextBottom bottom() = 0;
	virtual void bottom(Arts::TextBottom newValue) = 0;
};

class ARTS_EXPORT Label_stub : virtual public Label_base, virtual public Arts::Frame_stub {
protected:
	Label_stub();

public:
	Label_stub(Arts::Connection *connection, long objectID);

	std::string text();
	void text(const std::string& newValue);
	long align();
	void align(long newValue);
	long fontsize();
	void fontsize(long newValue);
	std::string fontfamily();
	void fontfamily(const std::string& newValue);
	Arts::TextBottom bottom();
	void bottom(Arts::TextBottom newValue);
};

class ARTS_EXPORT Label_skel : virtual public Label_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void text_changed(const std::string& newValue) {
		_emit_changed("text_changed",newValue);
	}
	inline void align_changed(long newValue) {
		_emit_changed("align_changed",newValue);
	}
	inline void fontsize_changed(long newValue) {
		_emit_changed("fontsize_changed",newValue);
	}
	inline void fontfamily_changed(const std::string& newValue) {
		_emit_changed("fontfamily_changed",newValue);
	}
	inline void bottom_changed(Arts::TextBottom newValue) {
		_emit_changed("bottom_changed",newValue);
	}

public:
	Label_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT Label : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Label_base *_cache;
	inline Label_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Label_base *)_pool->base->_cast(Label_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Label(Label_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Label_base _base_class;

	inline Label() : Arts::Object(_Creator), _cache(0) {}
	inline Label(const Arts::SubClass& s) :
		Arts::Object(Label_base::_create(s.string())), _cache(0) {}
	inline Label(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Label_base::_fromString(r.string())):(Label_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Label(const Arts::DynamicCast& c) : Arts::Object(Label_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Label(const Label& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Label(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Label null() {return Label((Label_base*)0);}
	inline static Label _from_base(Label_base* b) {return Label(b);}
	inline Label& operator=(const Label& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline Label_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline Label(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline std::string text();
	inline void text(const std::string& _newValue);
	inline long align();
	inline void align(long _newValue);
	inline long fontsize();
	inline void fontsize(long _newValue);
	inline std::string fontfamily();
	inline void fontfamily(const std::string& _newValue);
	inline Arts::TextBottom bottom();
	inline void bottom(Arts::TextBottom _newValue);
};

class ARTS_EXPORT LevelMeter_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static LevelMeter_base *_create(const std::string& subClass = "Arts::LevelMeter");
	static LevelMeter_base *_fromString(const std::string& objectref);
	static LevelMeter_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static LevelMeter_base *_fromDynamicCast(const Arts::Object& object);
	inline LevelMeter_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::LevelMeterStyle style() = 0;
	virtual void style(Arts::LevelMeterStyle newValue) = 0;
	virtual long substyle() = 0;
	virtual void substyle(long newValue) = 0;
	virtual long count() = 0;
	virtual void count(long newValue) = 0;
	virtual long peakfalloff() = 0;
	virtual void peakfalloff(long newValue) = 0;
	virtual float mindB() = 0;
	virtual void mindB(float newValue) = 0;
	virtual float maxdB() = 0;
	virtual void maxdB(float newValue) = 0;
	virtual float invalue() = 0;
	virtual void invalue(float newValue) = 0;
	virtual Arts::Direction direction() = 0;
	virtual void direction(Arts::Direction newValue) = 0;
};

class ARTS_EXPORT LevelMeter_stub : virtual public LevelMeter_base, virtual public Arts::Frame_stub {
protected:
	LevelMeter_stub();

public:
	LevelMeter_stub(Arts::Connection *connection, long objectID);

	Arts::LevelMeterStyle style();
	void style(Arts::LevelMeterStyle newValue);
	long substyle();
	void substyle(long newValue);
	long count();
	void count(long newValue);
	long peakfalloff();
	void peakfalloff(long newValue);
	float mindB();
	void mindB(float newValue);
	float maxdB();
	void maxdB(float newValue);
	float invalue();
	void invalue(float newValue);
	Arts::Direction direction();
	void direction(Arts::Direction newValue);
};

class ARTS_EXPORT LevelMeter_skel : virtual public LevelMeter_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void style_changed(Arts::LevelMeterStyle newValue) {
		_emit_changed("style_changed",newValue);
	}
	inline void substyle_changed(long newValue) {
		_emit_changed("substyle_changed",newValue);
	}
	inline void count_changed(long newValue) {
		_emit_changed("count_changed",newValue);
	}
	inline void peakfalloff_changed(long newValue) {
		_emit_changed("peakfalloff_changed",newValue);
	}
	inline void mindB_changed(float newValue) {
		_emit_changed("mindB_changed",newValue);
	}
	inline void maxdB_changed(float newValue) {
		_emit_changed("maxdB_changed",newValue);
	}
	inline void invalue_changed(float newValue) {
		_emit_changed("invalue_changed",newValue);
	}
	inline void direction_changed(Arts::Direction newValue) {
		_emit_changed("direction_changed",newValue);
	}

public:
	LevelMeter_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT LevelMeter : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	LevelMeter_base *_cache;
	inline LevelMeter_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(LevelMeter_base *)_pool->base->_cast(LevelMeter_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline LevelMeter(LevelMeter_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef LevelMeter_base _base_class;

	inline LevelMeter() : Arts::Object(_Creator), _cache(0) {}
	inline LevelMeter(const Arts::SubClass& s) :
		Arts::Object(LevelMeter_base::_create(s.string())), _cache(0) {}
	inline LevelMeter(const Arts::Reference &r) :
		Arts::Object(r.isString()?(LevelMeter_base::_fromString(r.string())):(LevelMeter_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline LevelMeter(const Arts::DynamicCast& c) : Arts::Object(LevelMeter_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline LevelMeter(const LevelMeter& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline LevelMeter(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static LevelMeter null() {return LevelMeter((LevelMeter_base*)0);}
	inline static LevelMeter _from_base(LevelMeter_base* b) {return LevelMeter(b);}
	inline LevelMeter& operator=(const LevelMeter& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline LevelMeter_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline LevelMeter(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline Arts::LevelMeterStyle style();
	inline void style(Arts::LevelMeterStyle _newValue);
	inline long substyle();
	inline void substyle(long _newValue);
	inline long count();
	inline void count(long _newValue);
	inline long peakfalloff();
	inline void peakfalloff(long _newValue);
	inline float mindB();
	inline void mindB(float _newValue);
	inline float maxdB();
	inline void maxdB(float _newValue);
	inline float invalue();
	inline void invalue(float _newValue);
	inline Arts::Direction direction();
	inline void direction(Arts::Direction _newValue);
};

class ARTS_EXPORT Tickmarks_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static Tickmarks_base *_create(const std::string& subClass = "Arts::Tickmarks");
	static Tickmarks_base *_fromString(const std::string& objectref);
	static Tickmarks_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static Tickmarks_base *_fromDynamicCast(const Arts::Object& object);
	inline Tickmarks_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float min() = 0;
	virtual void min(float newValue) = 0;
	virtual float max() = 0;
	virtual void max(float newValue) = 0;
	virtual float minstep() = 0;
	virtual void minstep(float newValue) = 0;
	virtual float substep() = 0;
	virtual void substep(float newValue) = 0;
	virtual Arts::Direction direction() = 0;
	virtual void direction(Arts::Direction newValue) = 0;
	virtual long position() = 0;
	virtual void position(long newValue) = 0;
	virtual void constructor(float min, float max, Arts::Direction dir, long pos) = 0;
};

class ARTS_EXPORT Tickmarks_stub : virtual public Tickmarks_base, virtual public Arts::Frame_stub {
protected:
	Tickmarks_stub();

public:
	Tickmarks_stub(Arts::Connection *connection, long objectID);

	float min();
	void min(float newValue);
	float max();
	void max(float newValue);
	float minstep();
	void minstep(float newValue);
	float substep();
	void substep(float newValue);
	Arts::Direction direction();
	void direction(Arts::Direction newValue);
	long position();
	void position(long newValue);
	void constructor(float min, float max, Arts::Direction dir, long pos);
};

class ARTS_EXPORT Tickmarks_skel : virtual public Tickmarks_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void min_changed(float newValue) {
		_emit_changed("min_changed",newValue);
	}
	inline void max_changed(float newValue) {
		_emit_changed("max_changed",newValue);
	}
	inline void minstep_changed(float newValue) {
		_emit_changed("minstep_changed",newValue);
	}
	inline void substep_changed(float newValue) {
		_emit_changed("substep_changed",newValue);
	}
	inline void direction_changed(Arts::Direction newValue) {
		_emit_changed("direction_changed",newValue);
	}
	inline void position_changed(long newValue) {
		_emit_changed("position_changed",newValue);
	}

public:
	Tickmarks_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT Tickmarks : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	Tickmarks_base *_cache;
	inline Tickmarks_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(Tickmarks_base *)_pool->base->_cast(Tickmarks_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline Tickmarks(Tickmarks_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef Tickmarks_base _base_class;

	inline Tickmarks() : Arts::Object(_Creator), _cache(0) {}
	inline Tickmarks(const Arts::SubClass& s) :
		Arts::Object(Tickmarks_base::_create(s.string())), _cache(0) {}
	inline Tickmarks(const Arts::Reference &r) :
		Arts::Object(r.isString()?(Tickmarks_base::_fromString(r.string())):(Tickmarks_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline Tickmarks(const Arts::DynamicCast& c) : Arts::Object(Tickmarks_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline Tickmarks(const Tickmarks& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline Tickmarks(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static Tickmarks null() {return Tickmarks((Tickmarks_base*)0);}
	inline static Tickmarks _from_base(Tickmarks_base* b) {return Tickmarks(b);}
	inline Tickmarks& operator=(const Tickmarks& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline Tickmarks_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline Tickmarks(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline float min();
	inline void min(float _newValue);
	inline float max();
	inline void max(float _newValue);
	inline float minstep();
	inline void minstep(float _newValue);
	inline float substep();
	inline void substep(float _newValue);
	inline Arts::Direction direction();
	inline void direction(Arts::Direction _newValue);
	inline long position();
	inline void position(long _newValue);
	inline Tickmarks(float min, float max, Arts::Direction dir, long pos);
};

class ARTS_EXPORT VolumeFader_base : virtual public Arts::Frame_base {
public:
	static unsigned long _IID; // interface ID

	static VolumeFader_base *_create(const std::string& subClass = "Arts::VolumeFader");
	static VolumeFader_base *_fromString(const std::string& objectref);
	static VolumeFader_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static VolumeFader_base *_fromDynamicCast(const Arts::Object& object);
	inline VolumeFader_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual float dbmin() = 0;
	virtual void dbmin(float newValue) = 0;
	virtual float dbmax() = 0;
	virtual void dbmax(float newValue) = 0;
	virtual Arts::Direction direction() = 0;
	virtual void direction(Arts::Direction newValue) = 0;
	virtual float volume() = 0;
	virtual void volume(float newValue) = 0;
	virtual float dbvolume() = 0;
	virtual void dbvolume(float newValue) = 0;
	virtual void constructor(float dbmin, float dbmax, Arts::Direction dir) = 0;
};

class ARTS_EXPORT VolumeFader_stub : virtual public VolumeFader_base, virtual public Arts::Frame_stub {
protected:
	VolumeFader_stub();

public:
	VolumeFader_stub(Arts::Connection *connection, long objectID);

	float dbmin();
	void dbmin(float newValue);
	float dbmax();
	void dbmax(float newValue);
	Arts::Direction direction();
	void direction(Arts::Direction newValue);
	float volume();
	void volume(float newValue);
	float dbvolume();
	void dbvolume(float newValue);
	void constructor(float dbmin, float dbmax, Arts::Direction dir);
};

class ARTS_EXPORT VolumeFader_skel : virtual public VolumeFader_base, virtual public Arts::Frame_skel {
protected:
	// emitters for change notifications
	inline void dbmin_changed(float newValue) {
		_emit_changed("dbmin_changed",newValue);
	}
	inline void dbmax_changed(float newValue) {
		_emit_changed("dbmax_changed",newValue);
	}
	inline void direction_changed(Arts::Direction newValue) {
		_emit_changed("direction_changed",newValue);
	}
	inline void volume_changed(float newValue) {
		_emit_changed("volume_changed",newValue);
	}
	inline void dbvolume_changed(float newValue) {
		_emit_changed("dbvolume_changed",newValue);
	}

public:
	VolumeFader_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT VolumeFader : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	VolumeFader_base *_cache;
	inline VolumeFader_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(VolumeFader_base *)_pool->base->_cast(VolumeFader_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline VolumeFader(VolumeFader_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef VolumeFader_base _base_class;

	inline VolumeFader() : Arts::Object(_Creator), _cache(0) {}
	inline VolumeFader(const Arts::SubClass& s) :
		Arts::Object(VolumeFader_base::_create(s.string())), _cache(0) {}
	inline VolumeFader(const Arts::Reference &r) :
		Arts::Object(r.isString()?(VolumeFader_base::_fromString(r.string())):(VolumeFader_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline VolumeFader(const Arts::DynamicCast& c) : Arts::Object(VolumeFader_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline VolumeFader(const VolumeFader& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline VolumeFader(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static VolumeFader null() {return VolumeFader((VolumeFader_base*)0);}
	inline static VolumeFader _from_base(VolumeFader_base* b) {return VolumeFader(b);}
	inline VolumeFader& operator=(const VolumeFader& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::Frame() const { return Arts::Frame(*_pool); }
	inline operator Arts::Widget() const { return Arts::Widget(*_pool); }
	inline VolumeFader_base* _base() {return _cache?_cache:_method_call();}

	inline long margin();
	inline void margin(long _newValue);
	inline long linewidth();
	inline void linewidth(long _newValue);
	inline long midlinewidth();
	inline void midlinewidth(long _newValue);
	inline long framestyle();
	inline void framestyle(long _newValue);
	inline Arts::Shape frameshape();
	inline void frameshape(Arts::Shape _newValue);
	inline Arts::Shadow frameshadow();
	inline void frameshadow(Arts::Shadow _newValue);
	inline VolumeFader(Arts::Widget parent);
	inline long widgetID();
	inline Arts::Widget parent();
	inline void parent(Arts::Widget _newValue);
	inline long x();
	inline void x(long _newValue);
	inline long y();
	inline void y(long _newValue);
	inline long width();
	inline void width(long _newValue);
	inline long height();
	inline void height(long _newValue);
	inline bool visible();
	inline void visible(bool _newValue);
	inline Arts::SizePolicy hSizePolicy();
	inline void hSizePolicy(Arts::SizePolicy _newValue);
	inline Arts::SizePolicy vSizePolicy();
	inline void vSizePolicy(Arts::SizePolicy _newValue);
	inline void show();
	inline void hide();
	inline float dbmin();
	inline void dbmin(float _newValue);
	inline float dbmax();
	inline void dbmax(float _newValue);
	inline Arts::Direction direction();
	inline void direction(Arts::Direction _newValue);
	inline float volume();
	inline void volume(float _newValue);
	inline float dbvolume();
	inline void dbvolume(float _newValue);
	inline VolumeFader(float dbmin, float dbmax, Arts::Direction dir);
};

class ARTS_EXPORT GuiFactory_base : virtual public Arts::Object_base {
public:
	static unsigned long _IID; // interface ID

	static GuiFactory_base *_create(const std::string& subClass = "Arts::GuiFactory");
	static GuiFactory_base *_fromString(const std::string& objectref);
	static GuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static GuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline GuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

	virtual Arts::Widget createGui(Arts::Object runningObject) = 0;
};

class ARTS_EXPORT GuiFactory_stub : virtual public GuiFactory_base, virtual public Arts::Object_stub {
protected:
	GuiFactory_stub();

public:
	GuiFactory_stub(Arts::Connection *connection, long objectID);

	Arts::Widget createGui(Arts::Object runningObject);
};

class ARTS_EXPORT GuiFactory_skel : virtual public GuiFactory_base, virtual public Arts::Object_skel {
public:
	GuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT GuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	GuiFactory_base *_cache;
	inline GuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(GuiFactory_base *)_pool->base->_cast(GuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline GuiFactory(GuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef GuiFactory_base _base_class;

	inline GuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline GuiFactory(const Arts::SubClass& s) :
		Arts::Object(GuiFactory_base::_create(s.string())), _cache(0) {}
	inline GuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(GuiFactory_base::_fromString(r.string())):(GuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline GuiFactory(const Arts::DynamicCast& c) : Arts::Object(GuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline GuiFactory(const GuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline GuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static GuiFactory null() {return GuiFactory((GuiFactory_base*)0);}
	inline static GuiFactory _from_base(GuiFactory_base* b) {return GuiFactory(b);}
	inline GuiFactory& operator=(const GuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline GuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

class ARTS_EXPORT GenericGuiFactory_base : virtual public Arts::GuiFactory_base {
public:
	static unsigned long _IID; // interface ID

	static GenericGuiFactory_base *_create(const std::string& subClass = "Arts::GenericGuiFactory");
	static GenericGuiFactory_base *_fromString(const std::string& objectref);
	static GenericGuiFactory_base *_fromReference(Arts::ObjectReference ref, bool needcopy);

	static GenericGuiFactory_base *_fromDynamicCast(const Arts::Object& object);
	inline GenericGuiFactory_base *_copy() {
		assert(_refCnt > 0);
		_refCnt++;
		return this;
	}

	virtual std::vector<std::string> _defaultPortsIn() const;
	virtual std::vector<std::string> _defaultPortsOut() const;

	void *_cast(unsigned long iid);

};

class ARTS_EXPORT GenericGuiFactory_stub : virtual public GenericGuiFactory_base, virtual public Arts::GuiFactory_stub {
protected:
	GenericGuiFactory_stub();

public:
	GenericGuiFactory_stub(Arts::Connection *connection, long objectID);

};

class ARTS_EXPORT GenericGuiFactory_skel : virtual public GenericGuiFactory_base, virtual public Arts::GuiFactory_skel {
public:
	GenericGuiFactory_skel();

	static std::string _interfaceNameSkel();
	std::string _interfaceName();
	bool _isCompatibleWith(const std::string& interfacename);
	void _buildMethodTable();
	void dispatch(Arts::Buffer *request, Arts::Buffer *result,long methodID);
};

}
#include "reference.h"
namespace Arts {
class ARTS_EXPORT GenericGuiFactory : public Arts::Object {
private:
	static Arts::Object_base* _Creator();
	GenericGuiFactory_base *_cache;
	inline GenericGuiFactory_base *_method_call() {
		_pool->checkcreate();
		if(_pool->base) {
			_cache=(GenericGuiFactory_base *)_pool->base->_cast(GenericGuiFactory_base::_IID);
			assert(_cache);
		}
		return _cache;
	}

protected:
	inline GenericGuiFactory(GenericGuiFactory_base* b) : Arts::Object(b), _cache(0) {}


public:
	typedef GenericGuiFactory_base _base_class;

	inline GenericGuiFactory() : Arts::Object(_Creator), _cache(0) {}
	inline GenericGuiFactory(const Arts::SubClass& s) :
		Arts::Object(GenericGuiFactory_base::_create(s.string())), _cache(0) {}
	inline GenericGuiFactory(const Arts::Reference &r) :
		Arts::Object(r.isString()?(GenericGuiFactory_base::_fromString(r.string())):(GenericGuiFactory_base::_fromReference(r.reference(),true))), _cache(0) {}
	inline GenericGuiFactory(const Arts::DynamicCast& c) : Arts::Object(GenericGuiFactory_base::_fromDynamicCast(c.object())), _cache(0) {}
	inline GenericGuiFactory(const GenericGuiFactory& target) : Arts::Object(target._pool), _cache(target._cache) {}
	inline GenericGuiFactory(Arts::Object::Pool& p) : Arts::Object(p), _cache(0) {}
	inline static GenericGuiFactory null() {return GenericGuiFactory((GenericGuiFactory_base*)0);}
	inline static GenericGuiFactory _from_base(GenericGuiFactory_base* b) {return GenericGuiFactory(b);}
	inline GenericGuiFactory& operator=(const GenericGuiFactory& target) {
		if (_pool == target._pool) return *this;
		_pool->Dec();
		_pool = target._pool;
		_cache = target._cache;
		_pool->Inc();
		return *this;
	}
	inline operator Arts::GuiFactory() const { return Arts::GuiFactory(*_pool); }
	inline GenericGuiFactory_base* _base() {return _cache?_cache:_method_call();}

	inline Arts::Widget createGui(Arts::Object runningObject);
};

}
// Forward wrapper calls to _base classes:

inline long Arts::Widget::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::Widget::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::Widget::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::Widget::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::Widget::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::Widget::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::Widget::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::Widget::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::Widget::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::Widget::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::Widget::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::Widget::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::Widget::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::Widget::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::Widget::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::Widget::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::Widget::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::Widget::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::Widget::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline long Arts::Frame::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::Frame::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::Frame::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::Frame::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::Frame::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::Frame::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::Frame::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::Frame::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::Frame::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::Frame::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::Frame::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::Frame::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::Frame::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::Frame::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::Frame::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::Frame::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::Frame::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::Frame::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::Frame::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline long Arts::Frame::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::Frame::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::Frame::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::Frame::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::Frame::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::Frame::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::Frame::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::Frame::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::Frame::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::Frame::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::Frame::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::Frame::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::Frame::Frame(Arts::Widget parent)
		: Arts::Object(Frame_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::LayoutBox::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::LayoutBox::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::LayoutBox::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::LayoutBox::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::LayoutBox::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::LayoutBox::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::LayoutBox::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::LayoutBox::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::LayoutBox::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::LayoutBox::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::LayoutBox::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::LayoutBox::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::LayoutBox::LayoutBox(Arts::Widget parent)
		: Arts::Object(LayoutBox_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::LayoutBox::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::LayoutBox::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::LayoutBox::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::LayoutBox::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::LayoutBox::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::LayoutBox::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::LayoutBox::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::LayoutBox::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::LayoutBox::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::LayoutBox::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::LayoutBox::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::LayoutBox::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::LayoutBox::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::LayoutBox::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::LayoutBox::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::LayoutBox::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::LayoutBox::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::LayoutBox::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::LayoutBox::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline Arts::Direction Arts::LayoutBox::direction()
{
	return _cache?static_cast<Arts::LayoutBox_base*>(_cache)->direction():static_cast<Arts::LayoutBox_base*>(_method_call())->direction();
}

inline void Arts::LayoutBox::direction(Arts::Direction _newValue)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->direction(_newValue):static_cast<Arts::LayoutBox_base*>(_method_call())->direction(_newValue);
}

inline long Arts::LayoutBox::spacing()
{
	return _cache?static_cast<Arts::LayoutBox_base*>(_cache)->spacing():static_cast<Arts::LayoutBox_base*>(_method_call())->spacing();
}

inline void Arts::LayoutBox::spacing(long _newValue)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->spacing(_newValue):static_cast<Arts::LayoutBox_base*>(_method_call())->spacing(_newValue);
}

inline long Arts::LayoutBox::layoutmargin()
{
	return _cache?static_cast<Arts::LayoutBox_base*>(_cache)->layoutmargin():static_cast<Arts::LayoutBox_base*>(_method_call())->layoutmargin();
}

inline void Arts::LayoutBox::layoutmargin(long _newValue)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->layoutmargin(_newValue):static_cast<Arts::LayoutBox_base*>(_method_call())->layoutmargin(_newValue);
}

inline void Arts::LayoutBox::addWidget(Arts::Widget widget, long stretch, long align)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addWidget(widget, stretch, align):static_cast<Arts::LayoutBox_base*>(_method_call())->addWidget(widget, stretch, align);
}

inline void Arts::LayoutBox::addWidget(Arts::Widget widget, long stretch)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addWidget(widget, stretch):static_cast<Arts::LayoutBox_base*>(_method_call())->addWidget(widget, stretch);
}

inline void Arts::LayoutBox::addWidget(Arts::Widget widget)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addWidget(widget):static_cast<Arts::LayoutBox_base*>(_method_call())->addWidget(widget);
}

inline void Arts::LayoutBox::insertWidget(long position, Arts::Widget widget, long stretch, long align)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->insertWidget(position, widget, stretch, align):static_cast<Arts::LayoutBox_base*>(_method_call())->insertWidget(position, widget, stretch, align);
}

inline void Arts::LayoutBox::insertWidget(long position, Arts::Widget widget, long stretch)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->insertWidget(position, widget, stretch):static_cast<Arts::LayoutBox_base*>(_method_call())->insertWidget(position, widget, stretch);
}

inline void Arts::LayoutBox::insertWidget(long position, Arts::Widget widget)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->insertWidget(position, widget):static_cast<Arts::LayoutBox_base*>(_method_call())->insertWidget(position, widget);
}

inline void Arts::LayoutBox::addStretch(long stretch)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addStretch(stretch):static_cast<Arts::LayoutBox_base*>(_method_call())->addStretch(stretch);
}

inline void Arts::LayoutBox::addStretch()
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addStretch():static_cast<Arts::LayoutBox_base*>(_method_call())->addStretch();
}

inline void Arts::LayoutBox::addSpace(long space)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addSpace(space):static_cast<Arts::LayoutBox_base*>(_method_call())->addSpace(space);
}

inline void Arts::LayoutBox::addStrut(long size)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addStrut(size):static_cast<Arts::LayoutBox_base*>(_method_call())->addStrut(size);
}

inline void Arts::LayoutBox::addSeparator(long stretch, long align)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addSeparator(stretch, align):static_cast<Arts::LayoutBox_base*>(_method_call())->addSeparator(stretch, align);
}

inline void Arts::LayoutBox::addSeparator(long stretch)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addSeparator(stretch):static_cast<Arts::LayoutBox_base*>(_method_call())->addSeparator(stretch);
}

inline void Arts::LayoutBox::addSeparator()
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addSeparator():static_cast<Arts::LayoutBox_base*>(_method_call())->addSeparator();
}

inline void Arts::LayoutBox::addLine(long width, long space, long stretch, long align)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addLine(width, space, stretch, align):static_cast<Arts::LayoutBox_base*>(_method_call())->addLine(width, space, stretch, align);
}

inline void Arts::LayoutBox::addLine(long width, long space, long stretch)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addLine(width, space, stretch):static_cast<Arts::LayoutBox_base*>(_method_call())->addLine(width, space, stretch);
}

inline void Arts::LayoutBox::addLine(long width, long space)
{
	 _cache?static_cast<Arts::LayoutBox_base*>(_cache)->addLine(width, space):static_cast<Arts::LayoutBox_base*>(_method_call())->addLine(width, space);
}

inline long Arts::HBox::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::HBox::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::HBox::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::HBox::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::HBox::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::HBox::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::HBox::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::HBox::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::HBox::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::HBox::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::HBox::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::HBox::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::HBox::HBox(Arts::Widget parent)
		: Arts::Object(HBox_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::HBox::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::HBox::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::HBox::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::HBox::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::HBox::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::HBox::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::HBox::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::HBox::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::HBox::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::HBox::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::HBox::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::HBox::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::HBox::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::HBox::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::HBox::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::HBox::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::HBox::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::HBox::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::HBox::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline long Arts::HBox::spacing()
{
	return _cache?static_cast<Arts::HBox_base*>(_cache)->spacing():static_cast<Arts::HBox_base*>(_method_call())->spacing();
}

inline void Arts::HBox::spacing(long _newValue)
{
	 _cache?static_cast<Arts::HBox_base*>(_cache)->spacing(_newValue):static_cast<Arts::HBox_base*>(_method_call())->spacing(_newValue);
}

inline long Arts::VBox::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::VBox::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::VBox::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::VBox::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::VBox::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::VBox::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::VBox::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::VBox::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::VBox::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::VBox::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::VBox::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::VBox::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::VBox::VBox(Arts::Widget parent)
		: Arts::Object(VBox_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::VBox::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::VBox::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::VBox::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::VBox::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::VBox::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::VBox::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::VBox::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::VBox::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::VBox::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::VBox::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::VBox::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::VBox::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::VBox::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::VBox::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::VBox::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::VBox::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::VBox::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::VBox::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::VBox::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline long Arts::VBox::spacing()
{
	return _cache?static_cast<Arts::VBox_base*>(_cache)->spacing():static_cast<Arts::VBox_base*>(_method_call())->spacing();
}

inline void Arts::VBox::spacing(long _newValue)
{
	 _cache?static_cast<Arts::VBox_base*>(_cache)->spacing(_newValue):static_cast<Arts::VBox_base*>(_method_call())->spacing(_newValue);
}

inline long Arts::PopupBox::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::PopupBox::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::PopupBox::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::PopupBox::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::PopupBox::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::PopupBox::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::PopupBox::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::PopupBox::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::PopupBox::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::PopupBox::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::PopupBox::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::PopupBox::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::PopupBox::PopupBox(Arts::Widget parent)
		: Arts::Object(PopupBox_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::PopupBox::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::PopupBox::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::PopupBox::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::PopupBox::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::PopupBox::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::PopupBox::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::PopupBox::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::PopupBox::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::PopupBox::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::PopupBox::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::PopupBox::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::PopupBox::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::PopupBox::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::PopupBox::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::PopupBox::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::PopupBox::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::PopupBox::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::PopupBox::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::PopupBox::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline Arts::Direction Arts::PopupBox::direction()
{
	return _cache?static_cast<Arts::PopupBox_base*>(_cache)->direction():static_cast<Arts::PopupBox_base*>(_method_call())->direction();
}

inline void Arts::PopupBox::direction(Arts::Direction _newValue)
{
	 _cache?static_cast<Arts::PopupBox_base*>(_cache)->direction(_newValue):static_cast<Arts::PopupBox_base*>(_method_call())->direction(_newValue);
}

inline std::string Arts::PopupBox::name()
{
	return _cache?static_cast<Arts::PopupBox_base*>(_cache)->name():static_cast<Arts::PopupBox_base*>(_method_call())->name();
}

inline void Arts::PopupBox::name(const std::string& _newValue)
{
	 _cache?static_cast<Arts::PopupBox_base*>(_cache)->name(_newValue):static_cast<Arts::PopupBox_base*>(_method_call())->name(_newValue);
}

inline Arts::Widget Arts::PopupBox::widget()
{
	return _cache?static_cast<Arts::PopupBox_base*>(_cache)->widget():static_cast<Arts::PopupBox_base*>(_method_call())->widget();
}

inline void Arts::PopupBox::widget(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::PopupBox_base*>(_cache)->widget(_newValue):static_cast<Arts::PopupBox_base*>(_method_call())->widget(_newValue);
}

inline long Arts::Button::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::Button::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::Button::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::Button::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::Button::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::Button::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::Button::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::Button::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::Button::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::Button::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::Button::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::Button::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::Button::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::Button::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::Button::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::Button::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::Button::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::Button::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::Button::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline std::string Arts::Button::text()
{
	return _cache?static_cast<Arts::Button_base*>(_cache)->text():static_cast<Arts::Button_base*>(_method_call())->text();
}

inline void Arts::Button::text(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Button_base*>(_cache)->text(_newValue):static_cast<Arts::Button_base*>(_method_call())->text(_newValue);
}

inline bool Arts::Button::toggle()
{
	return _cache?static_cast<Arts::Button_base*>(_cache)->toggle():static_cast<Arts::Button_base*>(_method_call())->toggle();
}

inline void Arts::Button::toggle(bool _newValue)
{
	 _cache?static_cast<Arts::Button_base*>(_cache)->toggle(_newValue):static_cast<Arts::Button_base*>(_method_call())->toggle(_newValue);
}

inline bool Arts::Button::pressed()
{
	return _cache?static_cast<Arts::Button_base*>(_cache)->pressed():static_cast<Arts::Button_base*>(_method_call())->pressed();
}

inline bool Arts::Button::clicked()
{
	return _cache?static_cast<Arts::Button_base*>(_cache)->clicked():static_cast<Arts::Button_base*>(_method_call())->clicked();
}

inline Arts::Button::Button(Arts::Widget parent)
		: Arts::Object(Button_base::_create())
{
	static_cast<Arts::Button_base*>(_method_call())->constructor(parent);
}

inline Arts::Button::Button(const std::string& text, Arts::Widget parent)
		: Arts::Object(Button_base::_create())
{
	static_cast<Arts::Button_base*>(_method_call())->constructor(text, parent);
}

inline long Arts::Poti::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::Poti::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::Poti::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::Poti::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::Poti::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::Poti::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::Poti::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::Poti::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::Poti::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::Poti::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::Poti::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::Poti::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::Poti::Poti(Arts::Widget parent)
		: Arts::Object(Poti_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::Poti::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::Poti::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::Poti::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::Poti::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::Poti::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::Poti::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::Poti::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::Poti::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::Poti::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::Poti::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::Poti::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::Poti::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::Poti::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::Poti::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::Poti::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::Poti::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::Poti::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::Poti::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::Poti::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline std::string Arts::Poti::caption()
{
	return _cache?static_cast<Arts::Poti_base*>(_cache)->caption():static_cast<Arts::Poti_base*>(_method_call())->caption();
}

inline void Arts::Poti::caption(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Poti_base*>(_cache)->caption(_newValue):static_cast<Arts::Poti_base*>(_method_call())->caption(_newValue);
}

inline std::string Arts::Poti::color()
{
	return _cache?static_cast<Arts::Poti_base*>(_cache)->color():static_cast<Arts::Poti_base*>(_method_call())->color();
}

inline void Arts::Poti::color(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Poti_base*>(_cache)->color(_newValue):static_cast<Arts::Poti_base*>(_method_call())->color(_newValue);
}

inline float Arts::Poti::min()
{
	return _cache?static_cast<Arts::Poti_base*>(_cache)->min():static_cast<Arts::Poti_base*>(_method_call())->min();
}

inline void Arts::Poti::min(float _newValue)
{
	 _cache?static_cast<Arts::Poti_base*>(_cache)->min(_newValue):static_cast<Arts::Poti_base*>(_method_call())->min(_newValue);
}

inline float Arts::Poti::max()
{
	return _cache?static_cast<Arts::Poti_base*>(_cache)->max():static_cast<Arts::Poti_base*>(_method_call())->max();
}

inline void Arts::Poti::max(float _newValue)
{
	 _cache?static_cast<Arts::Poti_base*>(_cache)->max(_newValue):static_cast<Arts::Poti_base*>(_method_call())->max(_newValue);
}

inline float Arts::Poti::value()
{
	return _cache?static_cast<Arts::Poti_base*>(_cache)->value():static_cast<Arts::Poti_base*>(_method_call())->value();
}

inline void Arts::Poti::value(float _newValue)
{
	 _cache?static_cast<Arts::Poti_base*>(_cache)->value(_newValue):static_cast<Arts::Poti_base*>(_method_call())->value(_newValue);
}

inline float Arts::Poti::logarithmic()
{
	return _cache?static_cast<Arts::Poti_base*>(_cache)->logarithmic():static_cast<Arts::Poti_base*>(_method_call())->logarithmic();
}

inline void Arts::Poti::logarithmic(float _newValue)
{
	 _cache?static_cast<Arts::Poti_base*>(_cache)->logarithmic(_newValue):static_cast<Arts::Poti_base*>(_method_call())->logarithmic(_newValue);
}

inline long Arts::Poti::range()
{
	return _cache?static_cast<Arts::Poti_base*>(_cache)->range():static_cast<Arts::Poti_base*>(_method_call())->range();
}

inline void Arts::Poti::range(long _newValue)
{
	 _cache?static_cast<Arts::Poti_base*>(_cache)->range(_newValue):static_cast<Arts::Poti_base*>(_method_call())->range(_newValue);
}

inline long Arts::Fader::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::Fader::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::Fader::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::Fader::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::Fader::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::Fader::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::Fader::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::Fader::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::Fader::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::Fader::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::Fader::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::Fader::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::Fader::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::Fader::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::Fader::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::Fader::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::Fader::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::Fader::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::Fader::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline std::string Arts::Fader::caption()
{
	return _cache?static_cast<Arts::Fader_base*>(_cache)->caption():static_cast<Arts::Fader_base*>(_method_call())->caption();
}

inline void Arts::Fader::caption(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Fader_base*>(_cache)->caption(_newValue):static_cast<Arts::Fader_base*>(_method_call())->caption(_newValue);
}

inline std::string Arts::Fader::color()
{
	return _cache?static_cast<Arts::Fader_base*>(_cache)->color():static_cast<Arts::Fader_base*>(_method_call())->color();
}

inline void Arts::Fader::color(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Fader_base*>(_cache)->color(_newValue):static_cast<Arts::Fader_base*>(_method_call())->color(_newValue);
}

inline float Arts::Fader::min()
{
	return _cache?static_cast<Arts::Fader_base*>(_cache)->min():static_cast<Arts::Fader_base*>(_method_call())->min();
}

inline void Arts::Fader::min(float _newValue)
{
	 _cache?static_cast<Arts::Fader_base*>(_cache)->min(_newValue):static_cast<Arts::Fader_base*>(_method_call())->min(_newValue);
}

inline float Arts::Fader::max()
{
	return _cache?static_cast<Arts::Fader_base*>(_cache)->max():static_cast<Arts::Fader_base*>(_method_call())->max();
}

inline void Arts::Fader::max(float _newValue)
{
	 _cache?static_cast<Arts::Fader_base*>(_cache)->max(_newValue):static_cast<Arts::Fader_base*>(_method_call())->max(_newValue);
}

inline float Arts::Fader::value()
{
	return _cache?static_cast<Arts::Fader_base*>(_cache)->value():static_cast<Arts::Fader_base*>(_method_call())->value();
}

inline void Arts::Fader::value(float _newValue)
{
	 _cache?static_cast<Arts::Fader_base*>(_cache)->value(_newValue):static_cast<Arts::Fader_base*>(_method_call())->value(_newValue);
}

inline float Arts::Fader::logarithmic()
{
	return _cache?static_cast<Arts::Fader_base*>(_cache)->logarithmic():static_cast<Arts::Fader_base*>(_method_call())->logarithmic();
}

inline void Arts::Fader::logarithmic(float _newValue)
{
	 _cache?static_cast<Arts::Fader_base*>(_cache)->logarithmic(_newValue):static_cast<Arts::Fader_base*>(_method_call())->logarithmic(_newValue);
}

inline Arts::Fader::Fader(Arts::Widget parent)
		: Arts::Object(Fader_base::_create())
{
	static_cast<Arts::Fader_base*>(_method_call())->constructor(parent);
}

inline long Arts::LineEdit::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::LineEdit::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::LineEdit::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::LineEdit::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::LineEdit::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::LineEdit::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::LineEdit::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::LineEdit::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::LineEdit::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::LineEdit::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::LineEdit::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::LineEdit::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::LineEdit::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::LineEdit::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::LineEdit::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::LineEdit::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::LineEdit::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::LineEdit::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::LineEdit::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline std::string Arts::LineEdit::caption()
{
	return _cache?static_cast<Arts::LineEdit_base*>(_cache)->caption():static_cast<Arts::LineEdit_base*>(_method_call())->caption();
}

inline void Arts::LineEdit::caption(const std::string& _newValue)
{
	 _cache?static_cast<Arts::LineEdit_base*>(_cache)->caption(_newValue):static_cast<Arts::LineEdit_base*>(_method_call())->caption(_newValue);
}

inline std::string Arts::LineEdit::text()
{
	return _cache?static_cast<Arts::LineEdit_base*>(_cache)->text():static_cast<Arts::LineEdit_base*>(_method_call())->text();
}

inline void Arts::LineEdit::text(const std::string& _newValue)
{
	 _cache?static_cast<Arts::LineEdit_base*>(_cache)->text(_newValue):static_cast<Arts::LineEdit_base*>(_method_call())->text(_newValue);
}

inline Arts::LineEdit::LineEdit(Arts::Widget parent)
		: Arts::Object(LineEdit_base::_create())
{
	static_cast<Arts::LineEdit_base*>(_method_call())->constructor(parent);
}

inline long Arts::SpinBox::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::SpinBox::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::SpinBox::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::SpinBox::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::SpinBox::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::SpinBox::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::SpinBox::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::SpinBox::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::SpinBox::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::SpinBox::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::SpinBox::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::SpinBox::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::SpinBox::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::SpinBox::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::SpinBox::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::SpinBox::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::SpinBox::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::SpinBox::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::SpinBox::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline std::string Arts::SpinBox::caption()
{
	return _cache?static_cast<Arts::SpinBox_base*>(_cache)->caption():static_cast<Arts::SpinBox_base*>(_method_call())->caption();
}

inline void Arts::SpinBox::caption(const std::string& _newValue)
{
	 _cache?static_cast<Arts::SpinBox_base*>(_cache)->caption(_newValue):static_cast<Arts::SpinBox_base*>(_method_call())->caption(_newValue);
}

inline long Arts::SpinBox::min()
{
	return _cache?static_cast<Arts::SpinBox_base*>(_cache)->min():static_cast<Arts::SpinBox_base*>(_method_call())->min();
}

inline void Arts::SpinBox::min(long _newValue)
{
	 _cache?static_cast<Arts::SpinBox_base*>(_cache)->min(_newValue):static_cast<Arts::SpinBox_base*>(_method_call())->min(_newValue);
}

inline long Arts::SpinBox::max()
{
	return _cache?static_cast<Arts::SpinBox_base*>(_cache)->max():static_cast<Arts::SpinBox_base*>(_method_call())->max();
}

inline void Arts::SpinBox::max(long _newValue)
{
	 _cache?static_cast<Arts::SpinBox_base*>(_cache)->max(_newValue):static_cast<Arts::SpinBox_base*>(_method_call())->max(_newValue);
}

inline long Arts::SpinBox::value()
{
	return _cache?static_cast<Arts::SpinBox_base*>(_cache)->value():static_cast<Arts::SpinBox_base*>(_method_call())->value();
}

inline void Arts::SpinBox::value(long _newValue)
{
	 _cache?static_cast<Arts::SpinBox_base*>(_cache)->value(_newValue):static_cast<Arts::SpinBox_base*>(_method_call())->value(_newValue);
}

inline Arts::SpinBox::SpinBox(Arts::Widget parent)
		: Arts::Object(SpinBox_base::_create())
{
	static_cast<Arts::SpinBox_base*>(_method_call())->constructor(parent);
}

inline long Arts::ComboBox::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::ComboBox::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::ComboBox::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::ComboBox::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::ComboBox::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::ComboBox::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::ComboBox::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::ComboBox::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::ComboBox::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::ComboBox::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::ComboBox::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::ComboBox::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::ComboBox::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::ComboBox::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::ComboBox::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::ComboBox::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::ComboBox::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::ComboBox::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::ComboBox::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline std::string Arts::ComboBox::caption()
{
	return _cache?static_cast<Arts::ComboBox_base*>(_cache)->caption():static_cast<Arts::ComboBox_base*>(_method_call())->caption();
}

inline void Arts::ComboBox::caption(const std::string& _newValue)
{
	 _cache?static_cast<Arts::ComboBox_base*>(_cache)->caption(_newValue):static_cast<Arts::ComboBox_base*>(_method_call())->caption(_newValue);
}

inline std::vector<std::string> * Arts::ComboBox::choices()
{
	return _cache?static_cast<Arts::ComboBox_base*>(_cache)->choices():static_cast<Arts::ComboBox_base*>(_method_call())->choices();
}

inline void Arts::ComboBox::choices(const std::vector<std::string>& _newValue)
{
	 _cache?static_cast<Arts::ComboBox_base*>(_cache)->choices(_newValue):static_cast<Arts::ComboBox_base*>(_method_call())->choices(_newValue);
}

inline std::string Arts::ComboBox::value()
{
	return _cache?static_cast<Arts::ComboBox_base*>(_cache)->value():static_cast<Arts::ComboBox_base*>(_method_call())->value();
}

inline void Arts::ComboBox::value(const std::string& _newValue)
{
	 _cache?static_cast<Arts::ComboBox_base*>(_cache)->value(_newValue):static_cast<Arts::ComboBox_base*>(_method_call())->value(_newValue);
}

inline Arts::ComboBox::ComboBox(Arts::Widget parent)
		: Arts::Object(ComboBox_base::_create())
{
	static_cast<Arts::ComboBox_base*>(_method_call())->constructor(parent);
}

inline long Arts::Graph::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::Graph::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::Graph::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::Graph::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::Graph::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::Graph::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::Graph::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::Graph::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::Graph::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::Graph::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::Graph::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::Graph::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::Graph::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::Graph::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::Graph::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::Graph::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::Graph::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::Graph::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::Graph::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline std::string Arts::Graph::caption()
{
	return _cache?static_cast<Arts::Graph_base*>(_cache)->caption():static_cast<Arts::Graph_base*>(_method_call())->caption();
}

inline void Arts::Graph::caption(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Graph_base*>(_cache)->caption(_newValue):static_cast<Arts::Graph_base*>(_method_call())->caption(_newValue);
}

inline float Arts::Graph::minx()
{
	return _cache?static_cast<Arts::Graph_base*>(_cache)->minx():static_cast<Arts::Graph_base*>(_method_call())->minx();
}

inline void Arts::Graph::minx(float _newValue)
{
	 _cache?static_cast<Arts::Graph_base*>(_cache)->minx(_newValue):static_cast<Arts::Graph_base*>(_method_call())->minx(_newValue);
}

inline float Arts::Graph::maxx()
{
	return _cache?static_cast<Arts::Graph_base*>(_cache)->maxx():static_cast<Arts::Graph_base*>(_method_call())->maxx();
}

inline void Arts::Graph::maxx(float _newValue)
{
	 _cache?static_cast<Arts::Graph_base*>(_cache)->maxx(_newValue):static_cast<Arts::Graph_base*>(_method_call())->maxx(_newValue);
}

inline float Arts::Graph::miny()
{
	return _cache?static_cast<Arts::Graph_base*>(_cache)->miny():static_cast<Arts::Graph_base*>(_method_call())->miny();
}

inline void Arts::Graph::miny(float _newValue)
{
	 _cache?static_cast<Arts::Graph_base*>(_cache)->miny(_newValue):static_cast<Arts::Graph_base*>(_method_call())->miny(_newValue);
}

inline float Arts::Graph::maxy()
{
	return _cache?static_cast<Arts::Graph_base*>(_cache)->maxy():static_cast<Arts::Graph_base*>(_method_call())->maxy();
}

inline void Arts::Graph::maxy(float _newValue)
{
	 _cache?static_cast<Arts::Graph_base*>(_cache)->maxy(_newValue):static_cast<Arts::Graph_base*>(_method_call())->maxy(_newValue);
}

inline Arts::Graph::Graph(Arts::Widget parent)
		: Arts::Object(Graph_base::_create())
{
	static_cast<Arts::Graph_base*>(_method_call())->constructor(parent);
}

inline Arts::Graph Arts::GraphLine::graph()
{
	return _cache?static_cast<Arts::GraphLine_base*>(_cache)->graph():static_cast<Arts::GraphLine_base*>(_method_call())->graph();
}

inline void Arts::GraphLine::graph(Arts::Graph _newValue)
{
	 _cache?static_cast<Arts::GraphLine_base*>(_cache)->graph(_newValue):static_cast<Arts::GraphLine_base*>(_method_call())->graph(_newValue);
}

inline bool Arts::GraphLine::editable()
{
	return _cache?static_cast<Arts::GraphLine_base*>(_cache)->editable():static_cast<Arts::GraphLine_base*>(_method_call())->editable();
}

inline void Arts::GraphLine::editable(bool _newValue)
{
	 _cache?static_cast<Arts::GraphLine_base*>(_cache)->editable(_newValue):static_cast<Arts::GraphLine_base*>(_method_call())->editable(_newValue);
}

inline std::string Arts::GraphLine::color()
{
	return _cache?static_cast<Arts::GraphLine_base*>(_cache)->color():static_cast<Arts::GraphLine_base*>(_method_call())->color();
}

inline void Arts::GraphLine::color(const std::string& _newValue)
{
	 _cache?static_cast<Arts::GraphLine_base*>(_cache)->color(_newValue):static_cast<Arts::GraphLine_base*>(_method_call())->color(_newValue);
}

inline std::vector<Arts::GraphPoint> * Arts::GraphLine::points()
{
	return _cache?static_cast<Arts::GraphLine_base*>(_cache)->points():static_cast<Arts::GraphLine_base*>(_method_call())->points();
}

inline void Arts::GraphLine::points(const std::vector<Arts::GraphPoint>& _newValue)
{
	 _cache?static_cast<Arts::GraphLine_base*>(_cache)->points(_newValue):static_cast<Arts::GraphLine_base*>(_method_call())->points(_newValue);
}

inline long Arts::Label::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::Label::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::Label::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::Label::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::Label::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::Label::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::Label::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::Label::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::Label::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::Label::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::Label::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::Label::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::Label::Label(Arts::Widget parent)
		: Arts::Object(Label_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::Label::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::Label::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::Label::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::Label::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::Label::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::Label::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::Label::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::Label::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::Label::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::Label::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::Label::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::Label::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::Label::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::Label::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::Label::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::Label::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::Label::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::Label::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::Label::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline std::string Arts::Label::text()
{
	return _cache?static_cast<Arts::Label_base*>(_cache)->text():static_cast<Arts::Label_base*>(_method_call())->text();
}

inline void Arts::Label::text(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Label_base*>(_cache)->text(_newValue):static_cast<Arts::Label_base*>(_method_call())->text(_newValue);
}

inline long Arts::Label::align()
{
	return _cache?static_cast<Arts::Label_base*>(_cache)->align():static_cast<Arts::Label_base*>(_method_call())->align();
}

inline void Arts::Label::align(long _newValue)
{
	 _cache?static_cast<Arts::Label_base*>(_cache)->align(_newValue):static_cast<Arts::Label_base*>(_method_call())->align(_newValue);
}

inline long Arts::Label::fontsize()
{
	return _cache?static_cast<Arts::Label_base*>(_cache)->fontsize():static_cast<Arts::Label_base*>(_method_call())->fontsize();
}

inline void Arts::Label::fontsize(long _newValue)
{
	 _cache?static_cast<Arts::Label_base*>(_cache)->fontsize(_newValue):static_cast<Arts::Label_base*>(_method_call())->fontsize(_newValue);
}

inline std::string Arts::Label::fontfamily()
{
	return _cache?static_cast<Arts::Label_base*>(_cache)->fontfamily():static_cast<Arts::Label_base*>(_method_call())->fontfamily();
}

inline void Arts::Label::fontfamily(const std::string& _newValue)
{
	 _cache?static_cast<Arts::Label_base*>(_cache)->fontfamily(_newValue):static_cast<Arts::Label_base*>(_method_call())->fontfamily(_newValue);
}

inline Arts::TextBottom Arts::Label::bottom()
{
	return _cache?static_cast<Arts::Label_base*>(_cache)->bottom():static_cast<Arts::Label_base*>(_method_call())->bottom();
}

inline void Arts::Label::bottom(Arts::TextBottom _newValue)
{
	 _cache?static_cast<Arts::Label_base*>(_cache)->bottom(_newValue):static_cast<Arts::Label_base*>(_method_call())->bottom(_newValue);
}

inline long Arts::LevelMeter::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::LevelMeter::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::LevelMeter::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::LevelMeter::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::LevelMeter::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::LevelMeter::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::LevelMeter::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::LevelMeter::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::LevelMeter::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::LevelMeter::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::LevelMeter::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::LevelMeter::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::LevelMeter::LevelMeter(Arts::Widget parent)
		: Arts::Object(LevelMeter_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::LevelMeter::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::LevelMeter::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::LevelMeter::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::LevelMeter::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::LevelMeter::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::LevelMeter::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::LevelMeter::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::LevelMeter::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::LevelMeter::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::LevelMeter::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::LevelMeter::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::LevelMeter::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::LevelMeter::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::LevelMeter::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::LevelMeter::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::LevelMeter::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::LevelMeter::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::LevelMeter::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::LevelMeter::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline Arts::LevelMeterStyle Arts::LevelMeter::style()
{
	return _cache?static_cast<Arts::LevelMeter_base*>(_cache)->style():static_cast<Arts::LevelMeter_base*>(_method_call())->style();
}

inline void Arts::LevelMeter::style(Arts::LevelMeterStyle _newValue)
{
	 _cache?static_cast<Arts::LevelMeter_base*>(_cache)->style(_newValue):static_cast<Arts::LevelMeter_base*>(_method_call())->style(_newValue);
}

inline long Arts::LevelMeter::substyle()
{
	return _cache?static_cast<Arts::LevelMeter_base*>(_cache)->substyle():static_cast<Arts::LevelMeter_base*>(_method_call())->substyle();
}

inline void Arts::LevelMeter::substyle(long _newValue)
{
	 _cache?static_cast<Arts::LevelMeter_base*>(_cache)->substyle(_newValue):static_cast<Arts::LevelMeter_base*>(_method_call())->substyle(_newValue);
}

inline long Arts::LevelMeter::count()
{
	return _cache?static_cast<Arts::LevelMeter_base*>(_cache)->count():static_cast<Arts::LevelMeter_base*>(_method_call())->count();
}

inline void Arts::LevelMeter::count(long _newValue)
{
	 _cache?static_cast<Arts::LevelMeter_base*>(_cache)->count(_newValue):static_cast<Arts::LevelMeter_base*>(_method_call())->count(_newValue);
}

inline long Arts::LevelMeter::peakfalloff()
{
	return _cache?static_cast<Arts::LevelMeter_base*>(_cache)->peakfalloff():static_cast<Arts::LevelMeter_base*>(_method_call())->peakfalloff();
}

inline void Arts::LevelMeter::peakfalloff(long _newValue)
{
	 _cache?static_cast<Arts::LevelMeter_base*>(_cache)->peakfalloff(_newValue):static_cast<Arts::LevelMeter_base*>(_method_call())->peakfalloff(_newValue);
}

inline float Arts::LevelMeter::mindB()
{
	return _cache?static_cast<Arts::LevelMeter_base*>(_cache)->mindB():static_cast<Arts::LevelMeter_base*>(_method_call())->mindB();
}

inline void Arts::LevelMeter::mindB(float _newValue)
{
	 _cache?static_cast<Arts::LevelMeter_base*>(_cache)->mindB(_newValue):static_cast<Arts::LevelMeter_base*>(_method_call())->mindB(_newValue);
}

inline float Arts::LevelMeter::maxdB()
{
	return _cache?static_cast<Arts::LevelMeter_base*>(_cache)->maxdB():static_cast<Arts::LevelMeter_base*>(_method_call())->maxdB();
}

inline void Arts::LevelMeter::maxdB(float _newValue)
{
	 _cache?static_cast<Arts::LevelMeter_base*>(_cache)->maxdB(_newValue):static_cast<Arts::LevelMeter_base*>(_method_call())->maxdB(_newValue);
}

inline float Arts::LevelMeter::invalue()
{
	return _cache?static_cast<Arts::LevelMeter_base*>(_cache)->invalue():static_cast<Arts::LevelMeter_base*>(_method_call())->invalue();
}

inline void Arts::LevelMeter::invalue(float _newValue)
{
	 _cache?static_cast<Arts::LevelMeter_base*>(_cache)->invalue(_newValue):static_cast<Arts::LevelMeter_base*>(_method_call())->invalue(_newValue);
}

inline Arts::Direction Arts::LevelMeter::direction()
{
	return _cache?static_cast<Arts::LevelMeter_base*>(_cache)->direction():static_cast<Arts::LevelMeter_base*>(_method_call())->direction();
}

inline void Arts::LevelMeter::direction(Arts::Direction _newValue)
{
	 _cache?static_cast<Arts::LevelMeter_base*>(_cache)->direction(_newValue):static_cast<Arts::LevelMeter_base*>(_method_call())->direction(_newValue);
}

inline long Arts::Tickmarks::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::Tickmarks::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::Tickmarks::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::Tickmarks::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::Tickmarks::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::Tickmarks::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::Tickmarks::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::Tickmarks::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::Tickmarks::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::Tickmarks::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::Tickmarks::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::Tickmarks::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::Tickmarks::Tickmarks(Arts::Widget parent)
		: Arts::Object(Tickmarks_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::Tickmarks::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::Tickmarks::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::Tickmarks::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::Tickmarks::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::Tickmarks::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::Tickmarks::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::Tickmarks::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::Tickmarks::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::Tickmarks::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::Tickmarks::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::Tickmarks::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::Tickmarks::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::Tickmarks::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::Tickmarks::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::Tickmarks::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::Tickmarks::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::Tickmarks::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::Tickmarks::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::Tickmarks::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline float Arts::Tickmarks::min()
{
	return _cache?static_cast<Arts::Tickmarks_base*>(_cache)->min():static_cast<Arts::Tickmarks_base*>(_method_call())->min();
}

inline void Arts::Tickmarks::min(float _newValue)
{
	 _cache?static_cast<Arts::Tickmarks_base*>(_cache)->min(_newValue):static_cast<Arts::Tickmarks_base*>(_method_call())->min(_newValue);
}

inline float Arts::Tickmarks::max()
{
	return _cache?static_cast<Arts::Tickmarks_base*>(_cache)->max():static_cast<Arts::Tickmarks_base*>(_method_call())->max();
}

inline void Arts::Tickmarks::max(float _newValue)
{
	 _cache?static_cast<Arts::Tickmarks_base*>(_cache)->max(_newValue):static_cast<Arts::Tickmarks_base*>(_method_call())->max(_newValue);
}

inline float Arts::Tickmarks::minstep()
{
	return _cache?static_cast<Arts::Tickmarks_base*>(_cache)->minstep():static_cast<Arts::Tickmarks_base*>(_method_call())->minstep();
}

inline void Arts::Tickmarks::minstep(float _newValue)
{
	 _cache?static_cast<Arts::Tickmarks_base*>(_cache)->minstep(_newValue):static_cast<Arts::Tickmarks_base*>(_method_call())->minstep(_newValue);
}

inline float Arts::Tickmarks::substep()
{
	return _cache?static_cast<Arts::Tickmarks_base*>(_cache)->substep():static_cast<Arts::Tickmarks_base*>(_method_call())->substep();
}

inline void Arts::Tickmarks::substep(float _newValue)
{
	 _cache?static_cast<Arts::Tickmarks_base*>(_cache)->substep(_newValue):static_cast<Arts::Tickmarks_base*>(_method_call())->substep(_newValue);
}

inline Arts::Direction Arts::Tickmarks::direction()
{
	return _cache?static_cast<Arts::Tickmarks_base*>(_cache)->direction():static_cast<Arts::Tickmarks_base*>(_method_call())->direction();
}

inline void Arts::Tickmarks::direction(Arts::Direction _newValue)
{
	 _cache?static_cast<Arts::Tickmarks_base*>(_cache)->direction(_newValue):static_cast<Arts::Tickmarks_base*>(_method_call())->direction(_newValue);
}

inline long Arts::Tickmarks::position()
{
	return _cache?static_cast<Arts::Tickmarks_base*>(_cache)->position():static_cast<Arts::Tickmarks_base*>(_method_call())->position();
}

inline void Arts::Tickmarks::position(long _newValue)
{
	 _cache?static_cast<Arts::Tickmarks_base*>(_cache)->position(_newValue):static_cast<Arts::Tickmarks_base*>(_method_call())->position(_newValue);
}

inline Arts::Tickmarks::Tickmarks(float min, float max, Arts::Direction dir, long pos)
		: Arts::Object(Tickmarks_base::_create())
{
	static_cast<Arts::Tickmarks_base*>(_method_call())->constructor(min, max, dir, pos);
}

inline long Arts::VolumeFader::margin()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->margin():static_cast<Arts::Frame_base*>(_method_call())->margin();
}

inline void Arts::VolumeFader::margin(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->margin(_newValue):static_cast<Arts::Frame_base*>(_method_call())->margin(_newValue);
}

inline long Arts::VolumeFader::linewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth():static_cast<Arts::Frame_base*>(_method_call())->linewidth();
}

inline void Arts::VolumeFader::linewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->linewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->linewidth(_newValue);
}

inline long Arts::VolumeFader::midlinewidth()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth():static_cast<Arts::Frame_base*>(_method_call())->midlinewidth();
}

inline void Arts::VolumeFader::midlinewidth(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->midlinewidth(_newValue):static_cast<Arts::Frame_base*>(_method_call())->midlinewidth(_newValue);
}

inline long Arts::VolumeFader::framestyle()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle():static_cast<Arts::Frame_base*>(_method_call())->framestyle();
}

inline void Arts::VolumeFader::framestyle(long _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->framestyle(_newValue):static_cast<Arts::Frame_base*>(_method_call())->framestyle(_newValue);
}

inline Arts::Shape Arts::VolumeFader::frameshape()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape():static_cast<Arts::Frame_base*>(_method_call())->frameshape();
}

inline void Arts::VolumeFader::frameshape(Arts::Shape _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshape(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshape(_newValue);
}

inline Arts::Shadow Arts::VolumeFader::frameshadow()
{
	return _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow():static_cast<Arts::Frame_base*>(_method_call())->frameshadow();
}

inline void Arts::VolumeFader::frameshadow(Arts::Shadow _newValue)
{
	 _cache?static_cast<Arts::Frame_base*>(_cache)->frameshadow(_newValue):static_cast<Arts::Frame_base*>(_method_call())->frameshadow(_newValue);
}

inline Arts::VolumeFader::VolumeFader(Arts::Widget parent)
		: Arts::Object(VolumeFader_base::_create())
{
	static_cast<Arts::Frame_base*>(_method_call())->constructor(parent);
}

inline long Arts::VolumeFader::widgetID()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->widgetID():static_cast<Arts::Widget_base*>(_method_call())->widgetID();
}

inline Arts::Widget Arts::VolumeFader::parent()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->parent():static_cast<Arts::Widget_base*>(_method_call())->parent();
}

inline void Arts::VolumeFader::parent(Arts::Widget _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->parent(_newValue):static_cast<Arts::Widget_base*>(_method_call())->parent(_newValue);
}

inline long Arts::VolumeFader::x()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->x():static_cast<Arts::Widget_base*>(_method_call())->x();
}

inline void Arts::VolumeFader::x(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->x(_newValue):static_cast<Arts::Widget_base*>(_method_call())->x(_newValue);
}

inline long Arts::VolumeFader::y()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->y():static_cast<Arts::Widget_base*>(_method_call())->y();
}

inline void Arts::VolumeFader::y(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->y(_newValue):static_cast<Arts::Widget_base*>(_method_call())->y(_newValue);
}

inline long Arts::VolumeFader::width()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->width():static_cast<Arts::Widget_base*>(_method_call())->width();
}

inline void Arts::VolumeFader::width(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->width(_newValue):static_cast<Arts::Widget_base*>(_method_call())->width(_newValue);
}

inline long Arts::VolumeFader::height()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->height():static_cast<Arts::Widget_base*>(_method_call())->height();
}

inline void Arts::VolumeFader::height(long _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->height(_newValue):static_cast<Arts::Widget_base*>(_method_call())->height(_newValue);
}

inline bool Arts::VolumeFader::visible()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->visible():static_cast<Arts::Widget_base*>(_method_call())->visible();
}

inline void Arts::VolumeFader::visible(bool _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->visible(_newValue):static_cast<Arts::Widget_base*>(_method_call())->visible(_newValue);
}

inline Arts::SizePolicy Arts::VolumeFader::hSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy();
}

inline void Arts::VolumeFader::hSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->hSizePolicy(_newValue);
}

inline Arts::SizePolicy Arts::VolumeFader::vSizePolicy()
{
	return _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy():static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy();
}

inline void Arts::VolumeFader::vSizePolicy(Arts::SizePolicy _newValue)
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->vSizePolicy(_newValue):static_cast<Arts::Widget_base*>(_method_call())->vSizePolicy(_newValue);
}

inline void Arts::VolumeFader::show()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->show():static_cast<Arts::Widget_base*>(_method_call())->show();
}

inline void Arts::VolumeFader::hide()
{
	 _cache?static_cast<Arts::Widget_base*>(_cache)->hide():static_cast<Arts::Widget_base*>(_method_call())->hide();
}

inline float Arts::VolumeFader::dbmin()
{
	return _cache?static_cast<Arts::VolumeFader_base*>(_cache)->dbmin():static_cast<Arts::VolumeFader_base*>(_method_call())->dbmin();
}

inline void Arts::VolumeFader::dbmin(float _newValue)
{
	 _cache?static_cast<Arts::VolumeFader_base*>(_cache)->dbmin(_newValue):static_cast<Arts::VolumeFader_base*>(_method_call())->dbmin(_newValue);
}

inline float Arts::VolumeFader::dbmax()
{
	return _cache?static_cast<Arts::VolumeFader_base*>(_cache)->dbmax():static_cast<Arts::VolumeFader_base*>(_method_call())->dbmax();
}

inline void Arts::VolumeFader::dbmax(float _newValue)
{
	 _cache?static_cast<Arts::VolumeFader_base*>(_cache)->dbmax(_newValue):static_cast<Arts::VolumeFader_base*>(_method_call())->dbmax(_newValue);
}

inline Arts::Direction Arts::VolumeFader::direction()
{
	return _cache?static_cast<Arts::VolumeFader_base*>(_cache)->direction():static_cast<Arts::VolumeFader_base*>(_method_call())->direction();
}

inline void Arts::VolumeFader::direction(Arts::Direction _newValue)
{
	 _cache?static_cast<Arts::VolumeFader_base*>(_cache)->direction(_newValue):static_cast<Arts::VolumeFader_base*>(_method_call())->direction(_newValue);
}

inline float Arts::VolumeFader::volume()
{
	return _cache?static_cast<Arts::VolumeFader_base*>(_cache)->volume():static_cast<Arts::VolumeFader_base*>(_method_call())->volume();
}

inline void Arts::VolumeFader::volume(float _newValue)
{
	 _cache?static_cast<Arts::VolumeFader_base*>(_cache)->volume(_newValue):static_cast<Arts::VolumeFader_base*>(_method_call())->volume(_newValue);
}

inline float Arts::VolumeFader::dbvolume()
{
	return _cache?static_cast<Arts::VolumeFader_base*>(_cache)->dbvolume():static_cast<Arts::VolumeFader_base*>(_method_call())->dbvolume();
}

inline void Arts::VolumeFader::dbvolume(float _newValue)
{
	 _cache?static_cast<Arts::VolumeFader_base*>(_cache)->dbvolume(_newValue):static_cast<Arts::VolumeFader_base*>(_method_call())->dbvolume(_newValue);
}

inline Arts::VolumeFader::VolumeFader(float dbmin, float dbmax, Arts::Direction dir)
		: Arts::Object(VolumeFader_base::_create())
{
	static_cast<Arts::VolumeFader_base*>(_method_call())->constructor(dbmin, dbmax, dir);
}

inline Arts::Widget Arts::GuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

inline Arts::Widget Arts::GenericGuiFactory::createGui(Arts::Object runningObject)
{
	return _cache?static_cast<Arts::GuiFactory_base*>(_cache)->createGui(runningObject):static_cast<Arts::GuiFactory_base*>(_method_call())->createGui(runningObject);
}

#endif /* ARTSGUI_H */
