/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.physics;

import br.arca.morcego.Config;
import br.arca.morcego.physics.Vector3D;

public class Matrix3x3 {
    private Vector3D x;
    private Vector3D y;
    private Vector3D z;
    private boolean identity = false;

    public Matrix3x3() {
        this.x = new Vector3D();
        this.y = new Vector3D();
        this.z = new Vector3D();
        this.setIdentity();
    }

    public Matrix3x3(Vector3D x, Vector3D y, Vector3D z) {
        this.x = new Vector3D(x.x, x.y, x.z);
        this.y = new Vector3D(y.x, y.y, y.z);
        this.z = new Vector3D(z.x, z.y, z.z);
    }

    public Matrix3x3(float xx, float xy, float xz, float yx, float yy, float yz, float zx, float zy, float zz) {
        this.x = new Vector3D(xx, xy, xz);
        this.y = new Vector3D(yx, yy, yz);
        this.z = new Vector3D(zx, zy, zz);
    }

    private static float fitAngle(float theta) {
        float maxTheta = Config.getFloat("morcego.maxTheta");
        float minTheta = Config.getFloat("morcego.minTheta");
        if (Math.abs(theta) > 0.0f) {
            if (Math.abs(theta) > maxTheta) {
                theta = maxTheta * Math.abs(theta) / theta;
            } else if (Math.abs(theta) < minTheta) {
                theta = minTheta * Math.abs(theta) / theta;
            }
        }
        return theta;
    }

    public static Matrix3x3 getXRotation(float theta) {
        theta = Matrix3x3.fitAngle(theta);
        theta = (float)((double)theta * (Math.PI / 180));
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        Vector3D nX = new Vector3D(1.0f, 0.0f, 0.0f);
        Vector3D nY = new Vector3D(0.0f, cos, sin);
        Vector3D nZ = new Vector3D(0.0f, -sin, cos);
        return new Matrix3x3(nX, nY, nZ);
    }

    public static Matrix3x3 getYRotation(float theta) {
        theta = Matrix3x3.fitAngle(theta);
        theta = (float)((double)theta * (Math.PI / 180));
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        Vector3D nX = new Vector3D(cos, 0.0f, -sin);
        Vector3D nY = new Vector3D(0.0f, 1.0f, 0.0f);
        Vector3D nZ = new Vector3D(sin, 0.0f, cos);
        return new Matrix3x3(nX, nY, nZ);
    }

    public static Matrix3x3 getZRotation(float theta) {
        theta = Matrix3x3.fitAngle(theta);
        theta = (float)((double)theta * (Math.PI / 180));
        float cos = (float)Math.cos(theta);
        float sin = (float)Math.sin(theta);
        Vector3D nX = new Vector3D(cos, sin, 0.0f);
        Vector3D nY = new Vector3D(-sin, cos, 0.0f);
        Vector3D nZ = new Vector3D(0.0f, 0.0f, 1.0f);
        return new Matrix3x3(nX, nY, nZ);
    }

    public Matrix3x3 multiplyByScalar(float n) {
        this.identity = false;
        Vector3D X = this.x.multiplyByScalar(n);
        Vector3D Y = this.y.multiplyByScalar(n);
        Vector3D Z = this.z.multiplyByScalar(n);
        return new Matrix3x3(X, Y, Z);
    }

    public Matrix3x3 multiplyByMatrix(Matrix3x3 matrix) {
        if (matrix.isIdentity()) {
            return new Matrix3x3(this.x, this.y, this.z);
        }
        Matrix3x3 m = matrix.transpose();
        Vector3D X = new Vector3D(this.x.scalarProduct(m.x), this.x.scalarProduct(m.y), this.x.scalarProduct(m.z));
        Vector3D Y = new Vector3D(this.y.scalarProduct(m.x), this.y.scalarProduct(m.y), this.y.scalarProduct(m.z));
        Vector3D Z = new Vector3D(this.z.scalarProduct(m.x), this.z.scalarProduct(m.y), this.z.scalarProduct(m.z));
        return new Matrix3x3(X, Y, Z);
    }

    public Vector3D multiplyByVector(Vector3D vector) {
        return new Vector3D(this.x.scalarProduct(vector), this.y.scalarProduct(vector), this.z.scalarProduct(vector));
    }

    public Matrix3x3 transpose() {
        Vector3D X = new Vector3D(this.x.x, this.y.x, this.z.x);
        Vector3D Y = new Vector3D(this.x.y, this.y.y, this.z.y);
        Vector3D Z = new Vector3D(this.x.z, this.y.z, this.z.z);
        return new Matrix3x3(X, Y, Z);
    }

    public void setIdentity() {
        this.identity = true;
        this.x = new Vector3D(1.0f, 0.0f, 0.0f);
        this.y = new Vector3D(0.0f, 1.0f, 0.0f);
        this.z = new Vector3D(0.0f, 0.0f, 1.0f);
    }

    public boolean isIdentity() {
        if (this.identity) {
            return true;
        }
        this.identity = this.x.x == 1.0f && this.x.y == 0.0f && this.x.z == 0.0f && this.y.x == 0.0f && this.y.y == 1.0f && this.y.z == 0.0f && this.z.x == 0.0f && this.z.y == 0.0f && this.z.z == 1.0f;
        return this.identity;
    }

    public String toString() {
        return new String("[," + this.x.x + "," + this.x.y + "," + this.x.z + ";" + "," + this.y.x + "," + this.y.y + "," + this.y.z + ";" + "," + this.z.x + "," + this.z.y + "," + this.z.z + "]");
    }
}

