/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.pad.resources;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.Vector;
import org.jgraph.pad.resources.DefaultResourceBundle;
import org.jgraph.pad.resources.LocaleChangeEvent;
import org.jgraph.pad.resources.LocaleChangeListener;

public class Translator {
    protected static Vector listeners = new Vector();
    protected static boolean logNotFoundResources = false;
    protected static Stack bundles = new Stack();
    protected static Stack bundleNames = new Stack();
    protected static DefaultResourceBundle defaultBundle = new DefaultResourceBundle();

    public static DefaultResourceBundle getDefaultResourceBundle() {
        return defaultBundle;
    }

    public static String getString(String string) {
        return Translator.getString(bundles.size() - 1, string);
    }

    public static String getString(int n, String string) {
        if (n < bundles.size() && n >= 0) {
            ResourceBundle resourceBundle = (ResourceBundle)bundles.get(n);
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return Translator.getString(n - 1, string);
            }
        }
        try {
            return defaultBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (logNotFoundResources) {
                System.err.println("Resource for the following key not found:" + string);
            }
            return null;
        }
    }

    public static String getString(String string, Object[] objectArray) {
        return Translator.getString(bundles.size() - 1, string, objectArray);
    }

    public static String getString(int n, String string, Object[] objectArray) {
        if (n < bundles.size() && n >= 0) {
            ResourceBundle resourceBundle = (ResourceBundle)bundles.get(n);
            try {
                return MessageFormat.format(resourceBundle.getString(string), objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                return Translator.getString(n - 1, string, objectArray);
            }
        }
        try {
            return defaultBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            if (logNotFoundResources) {
                System.err.println("Resource for the following key not found:" + string);
            }
            return null;
        }
    }

    public static void addLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        listeners.add(localeChangeListener);
    }

    public static void removeLocaleChangeListener(LocaleChangeListener localeChangeListener) {
        listeners.remove(localeChangeListener);
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) {
        Vector vector;
        Locale locale2 = Locale.getDefault();
        Locale.setDefault(locale);
        Translator.reloadBundles();
        Vector vector2 = listeners;
        synchronized (vector2) {
            vector = (Vector)listeners.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            LocaleChangeListener localeChangeListener = (LocaleChangeListener)enumeration.nextElement();
            localeChangeListener.localeChanged(new LocaleChangeEvent(locale2, locale));
        }
    }

    public static void reloadBundles() {
        defaultBundle.requeryDefaultNames();
        int n = 0;
        while (n < bundleNames.size()) {
            ResourceBundle resourceBundle = PropertyResourceBundle.getBundle((String)bundleNames.get(n));
            bundles.set(n, resourceBundle);
            ++n;
        }
    }

    public static void pushBundle(String string) {
        ResourceBundle resourceBundle = PropertyResourceBundle.getBundle(string);
        bundles.push(resourceBundle);
        bundleNames.push(string);
    }

    public static void popBundle() {
        bundles.pop();
        bundleNames.pop();
    }

    public static void removeBundle(int n) {
        bundles.remove(n);
        bundleNames.remove(n);
    }

    public static boolean isLogNotFoundResources() {
        return logNotFoundResources;
    }

    public static void setLogNotFoundResources(boolean bl) {
        logNotFoundResources = bl;
    }

    static {
        Translator.pushBundle("org.jgraph.pad.resources.Graphpad");
    }
}

