/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.GraphSelectionModel;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class JGraph
extends JComponent
implements CellViewFactory,
Scrollable,
Accessible,
Serializable {
    public static final String VERSION = "JGraph Lucerne (v3.0)";
    public static final int DOT_GRID_MODE = 0;
    public static final int CROSS_GRID_MODE = 1;
    public static final int LINE_GRID_MODE = 2;
    private static final String uiClassID = "GraphUI";
    protected transient GraphSelectionRedirector selectionRedirector;
    protected transient GraphModel graphModel;
    protected transient GraphLayoutCache graphLayoutCache;
    protected transient BasicMarqueeHandler marquee;
    protected transient GraphSelectionModel selectionModel;
    protected double scale = 1.0;
    protected boolean antiAliased = false;
    protected boolean editable = true;
    protected boolean gridVisible = false;
    protected int gridSize = 10;
    protected int gridMode = 0;
    protected boolean portsVisible = false;
    protected Color highlightColor = Color.green;
    protected Color handleColor;
    protected Color lockedHandleColor;
    protected Color marqueeColor;
    protected Color gridColor;
    protected boolean dragEnabled = false;
    protected boolean dropEnabled = true;
    protected int editClickCount = 2;
    protected boolean enabled = true;
    protected boolean gridEnabled = false;
    protected int handleSize = 3;
    protected int tolerance = 4;
    protected int minimumMove = 5;
    protected boolean selectNewCells = false;
    protected boolean disconnectOnMove = false;
    protected boolean moveable = true;
    protected boolean cloneable = true;
    protected boolean sizeable = true;
    protected boolean bendable = true;
    protected boolean connectable = true;
    protected boolean disconnectable = true;
    protected boolean invokesStopCellEditing;
    private boolean settingUI;
    public static final String GRAPH_MODEL_PROPERTY = "model";
    public static final String GRAPH_LAYOUT_CACHE_PROPERTY = "view";
    public static final String MARQUEE_HANDLER_PROPERTY = "marquee";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String SCALE_PROPERTY = "scale";
    public static final String ANTIALIASED_PROPERTY = "antiAliased";
    public static final String GRID_SIZE_PROPERTY = "gridSize";
    public static final String GRID_VISIBLE_PROPERTY = "gridVisible";
    public static final String PORTS_VISIBLE_PROPERTY = "portsVisible";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    static /* synthetic */ Class class$org$jgraph$event$GraphSelectionListener;

    protected static GraphLayoutCache createDefaultGraphView(JGraph jGraph) {
        return new GraphLayoutCache(jGraph.getModel(), jGraph);
    }

    public static void addSampleData(GraphModel graphModel) {
        ConnectionSet connectionSet = new ConnectionSet();
        Hashtable<DefaultGraphCell, Map> hashtable = new Hashtable<DefaultGraphCell, Map>();
        Map map = GraphConstants.createMap();
        GraphConstants.setLineBegin(map, 2);
        GraphConstants.setBeginSize(map, 10);
        GraphConstants.setDashPattern(map, new float[]{3.0f, 3.0f});
        GraphConstants.setFont(map, GraphConstants.defaultFont.deriveFont(10));
        Map map2 = GraphConstants.createMap();
        GraphConstants.setLineBegin(map2, 2);
        GraphConstants.setBeginFill(map2, true);
        GraphConstants.setBeginSize(map2, 10);
        GraphConstants.setFont(map2, GraphConstants.defaultFont.deriveFont(10));
        Map map3 = GraphConstants.createMap();
        GraphConstants.setLineBegin(map3, 9);
        GraphConstants.setBeginFill(map3, true);
        GraphConstants.setBeginSize(map3, 6);
        GraphConstants.setLineEnd(map3, 4);
        GraphConstants.setEndSize(map3, 8);
        GraphConstants.setLabelPosition(map3, new Point(500, 1200));
        GraphConstants.setFont(map3, GraphConstants.defaultFont.deriveFont(10));
        DefaultGraphCell defaultGraphCell = new DefaultGraphCell("GraphModel");
        hashtable.put(defaultGraphCell, JGraph.createBounds(20, 100, Color.blue));
        defaultGraphCell.add(new DefaultPort("GraphModel/Center"));
        DefaultGraphCell defaultGraphCell2 = new DefaultGraphCell("DefaultGraphModel");
        hashtable.put(defaultGraphCell2, JGraph.createBounds(20, 180, Color.blue));
        defaultGraphCell2.add(new DefaultPort("DefaultGraphModel/Center"));
        DefaultEdge defaultEdge = new DefaultEdge("implements");
        connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), defaultGraphCell2.getChildAt(0));
        hashtable.put(defaultEdge, map);
        DefaultGraphCell defaultGraphCell3 = new DefaultGraphCell("ModelGroup");
        defaultGraphCell3.add(defaultGraphCell);
        defaultGraphCell3.add(defaultGraphCell2);
        defaultGraphCell3.add(defaultEdge);
        DefaultGraphCell defaultGraphCell4 = new DefaultGraphCell("JComponent");
        hashtable.put(defaultGraphCell4, JGraph.createBounds(150, 20, Color.green));
        defaultGraphCell4.add(new DefaultPort("JComponent/Center"));
        DefaultGraphCell defaultGraphCell5 = new DefaultGraphCell("JGraph");
        hashtable.put(defaultGraphCell5, JGraph.createBounds(150, 100, Color.green));
        defaultGraphCell5.add(new DefaultPort("JGraph/Center"));
        DefaultEdge defaultEdge2 = new DefaultEdge("extends");
        connectionSet.connect((Object)defaultEdge2, (Object)defaultGraphCell4.getChildAt(0), defaultGraphCell5.getChildAt(0));
        hashtable.put(defaultEdge2, map2);
        DefaultGraphCell defaultGraphCell6 = new DefaultGraphCell("ComponentUI");
        hashtable.put(defaultGraphCell6, JGraph.createBounds(280, 20, Color.red));
        defaultGraphCell6.add(new DefaultPort("ComponentUI/Center"));
        DefaultGraphCell defaultGraphCell7 = new DefaultGraphCell(uiClassID);
        hashtable.put(defaultGraphCell7, JGraph.createBounds(280, 100, Color.red));
        defaultGraphCell7.add(new DefaultPort("GraphUI/Center"));
        DefaultGraphCell defaultGraphCell8 = new DefaultGraphCell("BasicGraphUI");
        hashtable.put(defaultGraphCell8, JGraph.createBounds(280, 180, Color.red));
        defaultGraphCell8.add(new DefaultPort("BasicGraphUI/Center"));
        DefaultEdge defaultEdge3 = new DefaultEdge("extends");
        connectionSet.connect((Object)defaultEdge3, (Object)defaultGraphCell6.getChildAt(0), defaultGraphCell7.getChildAt(0));
        hashtable.put(defaultEdge3, map2);
        DefaultEdge defaultEdge4 = new DefaultEdge("implements");
        connectionSet.connect((Object)defaultEdge4, (Object)defaultGraphCell7.getChildAt(0), defaultGraphCell8.getChildAt(0));
        hashtable.put(defaultEdge4, map);
        DefaultGraphCell defaultGraphCell9 = new DefaultGraphCell("UIGroup");
        defaultGraphCell9.add(defaultGraphCell6);
        defaultGraphCell9.add(defaultGraphCell7);
        defaultGraphCell9.add(defaultGraphCell8);
        defaultGraphCell9.add(defaultEdge4);
        defaultGraphCell9.add(defaultEdge3);
        DefaultEdge defaultEdge5 = new DefaultEdge(GRAPH_MODEL_PROPERTY);
        connectionSet.connect((Object)defaultEdge5, (Object)defaultGraphCell5.getChildAt(0), defaultGraphCell.getChildAt(0));
        hashtable.put(defaultEdge5, map3);
        DefaultEdge defaultEdge6 = new DefaultEdge("ui");
        connectionSet.connect((Object)defaultEdge6, (Object)defaultGraphCell4.getChildAt(0), defaultGraphCell6.getChildAt(0));
        hashtable.put(defaultEdge6, map3);
        Object[] objectArray = new Object[]{defaultEdge5, defaultEdge6, defaultGraphCell3, defaultGraphCell4, defaultGraphCell5, defaultEdge2, defaultGraphCell9};
        graphModel.insert(objectArray, hashtable, connectionSet, null, null);
    }

    public static Map createBounds(int n, int n2, Color color) {
        Map map = GraphConstants.createMap();
        GraphConstants.setBounds(map, new Rectangle(n, n2, 90, 30));
        GraphConstants.setBorder(map, BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground(map, color.darker());
        GraphConstants.setForeground(map, Color.white);
        GraphConstants.setFont(map, GraphConstants.defaultFont.deriveFont(1, 12.0f));
        GraphConstants.setOpaque(map, true);
        return map;
    }

    public JGraph() {
        this(null);
    }

    public JGraph(GraphModel graphModel) {
        this(graphModel, (GraphLayoutCache)null);
    }

    public JGraph(GraphModel graphModel, GraphLayoutCache graphLayoutCache) {
        this(graphModel, graphLayoutCache, new BasicMarqueeHandler());
    }

    public JGraph(GraphModel graphModel, BasicMarqueeHandler basicMarqueeHandler) {
        this(graphModel, null, basicMarqueeHandler);
    }

    public JGraph(GraphModel graphModel, GraphLayoutCache graphLayoutCache, BasicMarqueeHandler basicMarqueeHandler) {
        this.selectionModel = new DefaultGraphSelectionModel(this);
        this.setLayout(null);
        this.marquee = basicMarqueeHandler;
        if (graphLayoutCache == null) {
            graphLayoutCache = JGraph.createDefaultGraphView(this);
        }
        this.setGraphLayoutCache(graphLayoutCache);
        this.updateUI();
        if (graphModel == null) {
            graphModel = new DefaultGraphModel();
            this.setModel(graphModel);
            JGraph.addSampleData(graphModel);
        } else {
            this.setModel(graphModel);
        }
        this.setDoubleBuffered(true);
    }

    public GraphUI getUI() {
        return (GraphUI)this.ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUI(GraphUI graphUI) {
        if ((GraphUI)this.ui != graphUI) {
            this.settingUI = true;
            try {
                super.setUI(graphUI);
                Object var3_2 = null;
                this.settingUI = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.settingUI = false;
                throw throwable;
            }
        }
    }

    public void updateUI() {
        this.setUI(new BasicGraphUI());
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public Object[] getRoots() {
        return DefaultGraphModel.getRoots(this.graphModel);
    }

    public Object[] getRoots(Rectangle rectangle) {
        CellView[] cellViewArray = this.graphLayoutCache.getRoots(rectangle);
        Object[] objectArray = new Object[cellViewArray.length];
        int n = 0;
        while (n < cellViewArray.length) {
            objectArray[n] = cellViewArray[n].getCell();
            ++n;
        }
        return objectArray;
    }

    public Object[] getDescendants(Object[] objectArray) {
        Set set = DefaultGraphModel.getDescendants(this.getModel(), objectArray);
        return set.toArray();
    }

    public Object[] getDescendantList(Object[] objectArray) {
        return DefaultGraphModel.getDescendantList(this.getModel(), objectArray).toArray();
    }

    public Map cloneCells(Object[] objectArray) {
        return this.graphModel.cloneCells(objectArray);
    }

    public Object getFirstCellForLocation(int n, int n2) {
        return this.getNextCellForLocation(null, n, n2);
    }

    public Object getNextCellForLocation(Object object, int n, int n2) {
        n = (int)((double)n / this.scale);
        n2 = (int)((double)n2 / this.scale);
        CellView cellView = this.graphLayoutCache.getMapping(object, false);
        CellView cellView2 = this.getNextViewAt(cellView, n, n2);
        if (cellView2 != null) {
            return cellView2.getCell();
        }
        return null;
    }

    public Rectangle getCellBounds(Object object) {
        CellView cellView = this.graphLayoutCache.getMapping(object, false);
        if (cellView != null) {
            return cellView.getBounds();
        }
        return null;
    }

    public Rectangle getCellBounds(Object[] objectArray) {
        Rectangle rectangle;
        if (objectArray != null && objectArray.length > 0 && (rectangle = this.getCellBounds(objectArray[0])) != null) {
            rectangle = new Rectangle(rectangle);
            int n = 1;
            while (n < objectArray.length) {
                Rectangle rectangle2 = this.getCellBounds(objectArray[n]);
                if (rectangle2 != null) {
                    SwingUtilities.computeUnion(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
                }
                ++n;
            }
            return rectangle;
        }
        return null;
    }

    public CellView getNextViewAt(CellView cellView, int n, int n2) {
        Object[] objectArray = this.graphLayoutCache.order(this.getSelectionModel().getSelectables());
        CellView[] cellViewArray = this.graphLayoutCache.getMapping(objectArray);
        CellView cellView2 = this.getNextViewAt(cellViewArray, cellView, n, n2);
        return cellView2;
    }

    public CellView getNextViewAt(CellView[] cellViewArray, CellView cellView, int n, int n2) {
        if (cellViewArray != null) {
            Rectangle rectangle = new Rectangle(n - this.tolerance, n2 - this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
            CellView cellView2 = null;
            boolean bl = cellView == null;
            Graphics graphics = this.getGraphics();
            int n3 = cellViewArray.length - 1;
            while (n3 >= 0) {
                if (cellViewArray[n3] != null && cellViewArray[n3].intersects(graphics, rectangle)) {
                    if (bl && !this.selectionModel.isChildrenSelected(cellViewArray[n3].getCell())) {
                        return cellViewArray[n3];
                    }
                    if (cellView2 == null) {
                        cellView2 = cellViewArray[n3];
                    }
                    bl |= cellViewArray[n3] == cellView;
                }
                --n3;
            }
            return cellView2;
        }
        return null;
    }

    public Object getPortForLocation(int n, int n2) {
        PortView portView = this.getPortViewAt(n, n2);
        if (portView != null) {
            return portView.getCell();
        }
        return null;
    }

    public PortView getPortViewAt(int n, int n2) {
        Rectangle rectangle = new Rectangle(n - this.tolerance, n2 - this.tolerance, 2 * this.tolerance, 2 * this.tolerance);
        PortView[] portViewArray = this.graphLayoutCache.getPorts();
        int n3 = portViewArray.length - 1;
        while (n3 >= 0) {
            if (portViewArray[n3] != null && portViewArray[n3].intersects(this.getGraphics(), rectangle)) {
                return portViewArray[n3];
            }
            --n3;
        }
        return null;
    }

    public String convertValueToString(Object object) {
        CellView cellView;
        CellView cellView2 = cellView = object instanceof CellView ? (CellView)object : this.getGraphLayoutCache().getMapping(object, false);
        if (cellView != null) {
            Object object2 = GraphConstants.getValue(cellView.getAllAttributes());
            object = object2 != null ? object2 : cellView.getCell();
        }
        if (object instanceof DefaultMutableTreeNode && ((DefaultMutableTreeNode)object).getUserObject() != null) {
            return ((DefaultMutableTreeNode)object).getUserObject().toString();
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public Point snap(Point point) {
        if (this.gridEnabled && point != null) {
            double d = (double)this.gridSize * this.getScale();
            point.x = (int)Math.round((double)Math.round((double)point.x / d) * d);
            point.y = (int)Math.round((double)Math.round((double)point.y / d) * d);
        }
        return point;
    }

    public Dimension snap(Dimension dimension) {
        if (this.gridEnabled && dimension != null) {
            double d = (double)this.gridSize * this.getScale();
            dimension.width = 1 + (int)Math.round((double)Math.round((double)dimension.width / d) * d);
            dimension.height = 1 + (int)Math.round((double)Math.round((double)dimension.height / d) * d);
        }
        return dimension;
    }

    public Point toScreen(Point point) {
        if (point == null) {
            return null;
        }
        point.x = (int)Math.round((double)point.x * this.scale);
        point.y = (int)Math.round((double)point.y * this.scale);
        return point;
    }

    public Point fromScreen(Point point) {
        if (point == null) {
            return null;
        }
        point.x = (int)Math.round((double)point.x / this.scale);
        point.y = (int)Math.round((double)point.y / this.scale);
        return point;
    }

    public Rectangle toScreen(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        rectangle.x = (int)((double)rectangle.x * this.scale);
        rectangle.y = (int)((double)rectangle.y * this.scale);
        rectangle.width = (int)((double)rectangle.width * this.scale);
        rectangle.height = (int)((double)rectangle.height * this.scale);
        return rectangle;
    }

    public Rectangle fromScreen(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        rectangle.x = (int)((double)rectangle.x / this.scale);
        rectangle.y = (int)((double)rectangle.y / this.scale);
        rectangle.width = (int)((double)rectangle.width / this.scale);
        rectangle.height = (int)((double)rectangle.height / this.scale);
        return rectangle;
    }

    public CellView createView(Object object, CellMapper cellMapper) {
        AbstractCellView abstractCellView = null;
        abstractCellView = this.graphModel.isPort(object) ? this.createPortView(object, cellMapper) : (this.graphModel.isEdge(object) ? this.createEdgeView(object, cellMapper) : this.createVertexView(object, cellMapper));
        cellMapper.putMapping(object, abstractCellView);
        abstractCellView.refresh(true);
        abstractCellView.update();
        return abstractCellView;
    }

    public void updateAutoSize(CellView cellView) {
        Rectangle rectangle;
        if (cellView != null && !this.isEditing() && GraphConstants.isAutoSize(cellView.getAllAttributes()) && (rectangle = cellView.getBounds()) != null) {
            Dimension dimension = this.getUI().getPreferredSize(this, cellView);
            rectangle.setSize(dimension);
        }
    }

    protected EdgeView createEdgeView(Object object, CellMapper cellMapper) {
        if (object instanceof Edge) {
            return this.createEdgeView((Edge)object, cellMapper);
        }
        return new EdgeView(object, this, cellMapper);
    }

    protected PortView createPortView(Object object, CellMapper cellMapper) {
        if (object instanceof Port) {
            return this.createPortView((Port)object, cellMapper);
        }
        return new PortView(object, this, cellMapper);
    }

    protected EdgeView createEdgeView(Edge edge, CellMapper cellMapper) {
        return new EdgeView(edge, this, cellMapper);
    }

    protected PortView createPortView(Port port, CellMapper cellMapper) {
        return new PortView(port, this, cellMapper);
    }

    protected VertexView createVertexView(Object object, CellMapper cellMapper) {
        return new VertexView(object, this, cellMapper);
    }

    public int getEditClickCount() {
        return this.editClickCount;
    }

    public void setEditClickCount(int n) {
        this.editClickCount = n;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean bl) {
        this.dropEnabled = bl;
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean bl) {
        this.dragEnabled = bl;
    }

    public boolean isMoveable() {
        return this.moveable;
    }

    public void setMoveable(boolean bl) {
        this.moveable = bl;
    }

    public boolean isBendable() {
        return this.bendable;
    }

    public void setBendable(boolean bl) {
        this.bendable = bl;
    }

    public boolean isConnectable() {
        return this.connectable;
    }

    public void setConnectable(boolean bl) {
        this.connectable = bl;
    }

    public boolean isDisconnectable() {
        return this.disconnectable;
    }

    public void setDisconnectable(boolean bl) {
        this.disconnectable = bl;
    }

    public boolean isCloneable() {
        return this.cloneable;
    }

    public void setCloneable(boolean bl) {
        this.cloneable = bl;
    }

    public boolean isSizeable() {
        return this.sizeable;
    }

    public void setSizeable(boolean bl) {
        this.sizeable = bl;
    }

    public boolean isDisconnectOnMove() {
        return this.disconnectOnMove && this.disconnectable;
    }

    public void setSelectNewCells(boolean bl) {
        this.selectNewCells = bl;
    }

    public boolean isSelectNewCells() {
        return this.selectNewCells;
    }

    public void setDisconnectOnMove(boolean bl) {
        this.disconnectOnMove = bl;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean bl) {
        this.gridEnabled = bl;
    }

    public int getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(int n) {
        this.tolerance = n;
    }

    public int getHandleSize() {
        return this.handleSize;
    }

    public void setHandleSize(int n) {
        this.handleSize = n;
    }

    public int getMinimumMove() {
        return this.minimumMove;
    }

    public void setMinimumMove(int n) {
        this.minimumMove = n;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        this.gridColor = color;
    }

    public Color getHandleColor() {
        return this.handleColor;
    }

    public void setHandleColor(Color color) {
        this.handleColor = color;
    }

    public Color getLockedHandleColor() {
        return this.lockedHandleColor;
    }

    public void setLockedHandleColor(Color color) {
        this.lockedHandleColor = color;
    }

    public Color getMarqueeColor() {
        return this.marqueeColor;
    }

    public void setMarqueeColor(Color color) {
        this.marqueeColor = color;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        this.highlightColor = color;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d) {
        if (d > 0.0) {
            double d2 = this.scale;
            this.scale = d;
            this.firePropertyChange(SCALE_PROPERTY, d2, d);
        }
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public int getGridMode() {
        return this.gridMode;
    }

    public void setGridSize(int n) {
        int n2 = this.gridSize;
        this.gridSize = n;
        this.firePropertyChange(GRID_SIZE_PROPERTY, n2, n);
    }

    public void setGridMode(int n) {
        if (n == 0 || n == 1 || n == 2) {
            this.gridMode = n;
            this.repaint();
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean bl) {
        boolean bl2 = this.gridVisible;
        this.gridVisible = bl;
        this.firePropertyChange(GRID_VISIBLE_PROPERTY, bl2, bl);
    }

    public boolean isPortsVisible() {
        return this.portsVisible;
    }

    public void setPortsVisible(boolean bl) {
        boolean bl2 = this.portsVisible;
        this.portsVisible = bl;
        this.firePropertyChange(PORTS_VISIBLE_PROPERTY, bl2, bl);
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean bl) {
        boolean bl2 = this.antiAliased;
        this.antiAliased = bl;
        this.firePropertyChange(ANTIALIASED_PROPERTY, bl2, bl);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, bl);
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public void setModel(GraphModel graphModel) {
        GraphModel graphModel2 = this.graphModel;
        this.graphModel = graphModel;
        this.firePropertyChange(GRAPH_MODEL_PROPERTY, graphModel2, this.graphModel);
        if (this.graphLayoutCache != null && this.graphLayoutCache.getModel() != this.graphModel) {
            this.graphLayoutCache.setModel(this.graphModel);
        }
        this.invalidate();
    }

    public GraphLayoutCache getGraphLayoutCache() {
        return this.graphLayoutCache;
    }

    public void setGraphLayoutCache(GraphLayoutCache graphLayoutCache) {
        GraphLayoutCache graphLayoutCache2 = this.graphLayoutCache;
        this.graphLayoutCache = graphLayoutCache;
        this.firePropertyChange(GRAPH_LAYOUT_CACHE_PROPERTY, graphLayoutCache2, this.graphLayoutCache);
        if (this.graphLayoutCache != null && this.graphLayoutCache.getModel() != this.getModel()) {
            this.graphLayoutCache.setModel(this.getModel());
        }
        this.invalidate();
    }

    public BasicMarqueeHandler getMarqueeHandler() {
        return this.marquee;
    }

    public void setMarqueeHandler(BasicMarqueeHandler basicMarqueeHandler) {
        BasicMarqueeHandler basicMarqueeHandler2 = this.marquee;
        this.marquee = basicMarqueeHandler;
        this.firePropertyChange(MARQUEE_HANDLER_PROPERTY, basicMarqueeHandler2, basicMarqueeHandler);
        this.invalidate();
    }

    public void setInvokesStopCellEditing(boolean bl) {
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl2, bl);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public boolean isCellEditable(Object object) {
        CellView cellView;
        if (object != null && (cellView = this.graphLayoutCache.getMapping(object, false)) != null) {
            return this.isEditable() && GraphConstants.isEditable(cellView.getAllAttributes());
        }
        return false;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            Object object = this.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY());
            String string = this.convertValueToString(object);
            return string != null && string.length() > 0 ? string : null;
        }
        return null;
    }

    public void setSelectionModel(GraphSelectionModel graphSelectionModel) {
        if (graphSelectionModel == null) {
            graphSelectionModel = EmptySelectionModel.sharedInstance();
        }
        GraphSelectionModel graphSelectionModel2 = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeGraphSelectionListener(this.selectionRedirector);
        }
        this.selectionModel = graphSelectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, graphSelectionModel2, this.selectionModel);
    }

    public GraphSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.add(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener, graphSelectionListener);
        if (this.listenerList.getListenerCount(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new GraphSelectionRedirector();
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener, graphSelectionListener);
        if (this.listenerList.getListenerCount(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeGraphSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    protected void fireValueChanged(GraphSelectionEvent graphSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$jgraph$event$GraphSelectionListener == null ? JGraph.class$("org.jgraph.event.GraphSelectionListener") : class$org$jgraph$event$GraphSelectionListener)) {
                ((GraphSelectionListener)objectArray[n + 1]).valueChanged(graphSelectionEvent);
            }
            n -= 2;
        }
    }

    public void setSelectionCell(Object object) {
        this.getSelectionModel().setSelectionCell(object);
    }

    public void setSelectionCells(Object[] objectArray) {
        this.getSelectionModel().setSelectionCells(objectArray);
    }

    public void addSelectionCell(Object object) {
        this.getSelectionModel().addSelectionCell(object);
    }

    public void addSelectionCells(Object[] objectArray) {
        this.getSelectionModel().addSelectionCells(objectArray);
    }

    public void removeSelectionCell(Object object) {
        this.getSelectionModel().removeSelectionCell(object);
    }

    public Object getSelectionCell() {
        return this.getSelectionModel().getSelectionCell();
    }

    public Object[] getSelectionCells() {
        return this.getSelectionModel().getSelectionCells();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public boolean isCellSelected(Object object) {
        return this.getSelectionModel().isCellSelected(object);
    }

    public void scrollCellToVisible(Object object) {
        Rectangle rectangle = this.getCellBounds(object);
        if (rectangle != null) {
            rectangle = new Rectangle(rectangle);
            this.scrollRectToVisible(this.toScreen(rectangle));
        }
    }

    public void scrollPointToVisible(Point point) {
        Rectangle rectangle;
        if (point != null && (rectangle = new Rectangle(point)) != null) {
            this.scrollRectToVisible(rectangle);
        }
    }

    public boolean isEditing() {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            return graphUI.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            return graphUI.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            graphUI.cancelEditing(this);
        }
    }

    public void startEditingAtCell(Object object) {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            graphUI.startEditingAtCell(this, object);
        }
    }

    public Object getEditingCell() {
        GraphUI graphUI = this.getUI();
        if (graphUI != null) {
            return graphUI.getEditingCell(this);
        }
        return null;
    }

    public void graphDidChange() {
        this.revalidate();
        this.repaint();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Object> vector = new Vector<Object>();
        objectOutputStream.defaultWriteObject();
        if (this.graphModel instanceof Serializable) {
            vector.addElement("graphModel");
            vector.addElement(this.graphModel);
        }
        if (this.graphLayoutCache instanceof Serializable) {
            vector.addElement("graphLayoutCache");
            vector.addElement(this.graphLayoutCache);
        }
        if (this.selectionModel instanceof Serializable) {
            vector.addElement(SELECTION_MODEL_PROPERTY);
            vector.addElement(this.selectionModel);
        }
        objectOutputStream.writeObject(vector);
        if (this.getUIClassID().equals(uiClassID) && this.ui != null) {
            this.ui.installUI(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals("graphModel")) {
            this.graphModel = (GraphModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("graphLayoutCache")) {
            this.graphLayoutCache = (GraphLayoutCache)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (GraphSelectionModel)vector.elementAt(++n);
            ++n;
        }
        if (this.listenerList.getListenerCount(class$org$jgraph$event$GraphSelectionListener == null ? (class$org$jgraph$event$GraphSelectionListener = JGraph.class$("org.jgraph.event.GraphSelectionListener")) : class$org$jgraph$event$GraphSelectionListener) != 0) {
            this.selectionRedirector = new GraphSelectionRedirector();
            this.selectionModel.addGraphSelectionListener(this.selectionRedirector);
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            return 2;
        }
        return 4;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    protected String paramString() {
        String string = this.editable ? "true" : "false";
        String string2 = this.invokesStopCellEditing ? "true" : "false";
        return super.paramString() + ",editable=" + string + ",invokesStopCellEditing=" + string2;
    }

    public static void main(String[] stringArray) {
        System.out.println(VERSION);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class GraphSelectionRedirector
    implements Serializable,
    GraphSelectionListener {
        protected GraphSelectionRedirector() {
        }

        public void valueChanged(GraphSelectionEvent graphSelectionEvent) {
            GraphSelectionEvent graphSelectionEvent2 = (GraphSelectionEvent)graphSelectionEvent.cloneWithSource(JGraph.this);
            JGraph.this.fireValueChanged(graphSelectionEvent2);
        }
    }

    public static class EmptySelectionModel
    extends DefaultGraphSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public EmptySelectionModel() {
            super(null);
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        public void setSelectionCells(Object[] objectArray) {
        }

        public void addSelectionCells(Object[] objectArray) {
        }

        public void removeSelectionCells(Object[] objectArray) {
        }
    }
}

