/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.Controller;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.CopyEmitter;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class UnwrapLinksEmitter
extends CopyEmitter {
    protected Stack elementStack = new Stack();
    protected Stack saveStack = null;
    protected static String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static String xhURI = "http://www.w3.org/1999/xhtml";
    protected boolean foStylesheet = false;
    protected int linkDepth = 0;
    protected int skipDepth = 0;
    protected int htmlAFingerprint = 0;
    protected int xhtmlAFingerprint = 0;
    protected boolean inSkip = false;
    protected boolean tryAgain = false;

    public UnwrapLinksEmitter(Controller controller, NamePool namePool, boolean foStylesheet) {
        super(controller, namePool);
        this.foStylesheet = foStylesheet;
        this.htmlAFingerprint = namePool.getFingerprint("", "a");
        this.xhtmlAFingerprint = namePool.getFingerprint(xhURI, "a");
    }

    public void startElement(int nameCode, Attributes attributes, int[] namespaces, int nscount) throws TransformerException {
        boolean isLink;
        int thisFingerprint = this.namePool.getFingerprint(nameCode);
        boolean bl = isLink = thisFingerprint == this.htmlAFingerprint || thisFingerprint == this.xhtmlAFingerprint;
        if (isLink) {
            ++this.linkDepth;
            boolean bl2 = this.tryAgain = this.tryAgain || this.inSkip;
        }
        if (isLink && this.linkDepth > 1 && !this.inSkip) {
            StartElementInfo elem;
            this.inSkip = true;
            this.saveStack = new Stack();
            Stack<StartElementInfo> tempStack = new Stack<StartElementInfo>();
            while (!this.elementStack.empty()) {
                elem = (StartElementInfo)this.elementStack.pop();
                this.rtfEmitter.endElement(elem.getNameCode());
                this.saveStack.push(elem);
                tempStack.push(elem);
            }
            while (!tempStack.empty()) {
                elem = (StartElementInfo)tempStack.pop();
                this.elementStack.push(elem);
            }
        }
        if (this.inSkip) {
            ++this.skipDepth;
        }
        this.rtfEmitter.startElement(nameCode, attributes, namespaces, nscount);
        StartElementInfo sei = new StartElementInfo(nameCode, attributes, namespaces, nscount);
        this.elementStack.push(sei);
    }

    public void endElement(int nameCode) throws TransformerException {
        int thisFingerprint = this.namePool.getFingerprint(nameCode);
        boolean isLink = thisFingerprint == this.htmlAFingerprint || thisFingerprint == this.xhtmlAFingerprint;
        this.rtfEmitter.endElement(nameCode);
        this.elementStack.pop();
        if (isLink) {
            --this.linkDepth;
        }
        if (this.inSkip) {
            --this.skipDepth;
            boolean bl = this.inSkip = this.skipDepth > 0;
            if (!this.inSkip) {
                while (!this.saveStack.empty()) {
                    StartElementInfo elem = (StartElementInfo)this.saveStack.pop();
                    AttributeCollection attr = (AttributeCollection)elem.getAttributes();
                    AttributeCollection newAttr = new AttributeCollection(this.namePool);
                    for (int acount = 0; acount < attr.getLength(); ++acount) {
                        String localName = attr.getLocalName(acount);
                        String type = attr.getType(acount);
                        String value = attr.getValue(acount);
                        String uri = attr.getURI(acount);
                        String prefix = "";
                        if (localName.indexOf(58) > 0) {
                            prefix = localName.substring(0, localName.indexOf(58));
                            localName = localName.substring(localName.indexOf(58) + 1);
                        }
                        if (uri.equals("") && (this.foStylesheet && localName.equals("id") || !this.foStylesheet && (localName.equals("id") || localName.equals("name")))) continue;
                        newAttr.addAttribute(prefix, uri, localName, type, value);
                    }
                    this.rtfEmitter.startElement(elem.getNameCode(), (Attributes)newAttr, elem.getNamespaces(), elem.getNSCount());
                }
            }
        }
    }

    public boolean tryAgain() throws TransformerException {
        return this.tryAgain;
    }

    private class StartElementInfo {
        private int _nameCode;
        Attributes _attributes;
        int[] _namespaces;
        int _nscount;

        public StartElementInfo(int nameCode, Attributes attributes, int[] namespaces, int nscount) {
            this._nameCode = nameCode;
            this._attributes = attributes;
            this._namespaces = namespaces;
            this._nscount = nscount;
        }

        public int getNameCode() {
            return this._nameCode;
        }

        public Attributes getAttributes() {
            return this._attributes;
        }

        public int[] getNamespaces() {
            return this._namespaces;
        }

        public int getNSCount() {
            return this._nscount;
        }
    }
}

