"""
$RCSfile: TestURL.py,v $
Unit tests for ZopeXMLMethods product

Author: Craeg Strong <cstrong@arielpartners.com>
Modified by Philipp von Weitershausen <philikon@philikon.de>

Release: 1.0
"""

__cvstag__  = '$Name:  $'[6:-2]
__date__    = '$Date: 2003/03/30 20:51:59 $'[6:-2]
__version__ = '$Revision: 1.1 $'[10:-2]

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

# Load fixture
from Testing import ZopeTestCase

# ZopeXMLMethods
from Products.ZopeXMLMethods import XSLTMethod, ProcessorChooser

ZopeTestCase.installProduct('ZopeXMLMethods')
ZopeTestCase.installProduct('PageTemplates')
try:
    ZopeTestCase.installProduct('ParsedXML')
except:
    pass
try:
    ZopeTestCase.installProduct('ExternalFile')
except:
    pass
try:
    ZopeTestCase.installProduct('ExtFile')
except:
    pass

from Testing.ZopeTestCase import _folder_name, _standard_permissions
host, port = ZopeTestCase.utils.startZServer(3)
base = 'http://%s:%d/%s' %(host, port, _folder_name)

class XSLTMethodTestCase(ZopeTestCase.ZopeTestCase):
    """
    
    Unit tests for ZopeXMLMethods Zope Product.  These tests use the
    ZopeTestCase enhanced testing product. This file is not part of
    the automated test suite, but is here to provide a convenient
    standalone way to test relative URL resolution.  This capability
    is proven problematic for many XSLT processors that are Python
    wrappers on top of C or C++ libraries.  I believe the problems are
    related to threading and locking issues.  This test file is to be
    used to help track down these problems.
    
    """

    ################################################################
    # Fixture
    ################################################################

    def beforeSetUp(self):
        get_transaction().begin()

    def afterSetUp(self):
        '''Add object to default fixture'''

        #
        # Some of our negative testcases can cause warning
        # strings to be printed out.  Suppress those,
        # because it makes it seem like there is something wrong
        # with the test when there is not.
        # CKS 9/10/2002
        #
        import warnings
        warnings.filterwarnings('ignore','',UserWarning)
        
        pass

    def beforeClose(self):
        # Commit the cleared app
        get_transaction().commit()

    def afterClear(self):
        '''Clean up after myself'''
        pass
    
    ################################################################
    # Test Cases
    ################################################################

    def test_09(self):
        """Ensure that transformation resolves URLs in documents correctly"""
        xsltFile     = open('testfiles/paramfile.xsl','rb')
        self.folder.manage_addDTMLMethod('aTransformer', '', xsltFile)
        
        xmlFile      = open('testfiles/param.xml', 'rb')
        self.folder.manage_addDTMLMethod('aSource', '', xmlFile)

        self.folder.URNnamespaces = [ "arielpartners" ]
        self.folder.XSLparameters = [ "properties" ]
        self.folder.properties    = "arielpartners/propfolder/foo/properties"

        self.folder.manage_addFolder('arielpartners')
        arielpartners = self.folder['arielpartners']
        arielpartners.manage_addFolder('propfolder')
        propfolder = arielpartners['propfolder']
        propfolder.manage_addFolder('foo')
        foo = propfolder['foo']
        
        propFile      = open('testfiles/properties.xml', 'rb')
        foo.manage_addDTMLMethod('properties','',propFile)
        #
        # We must commit the transaction so the ZServer (running in a
        # different thread) can see our new Zope objects when it
        # tries to resolve the relative URL defined in self.folder.properties
        #
        get_transaction().commit()
        
        xform = XSLTMethod.addInstance(self.folder,id='aXSLTMethod',
                                         xslTransformerId='aTransformer')
        self.assertEquals(
            self.folder.aSource.aXSLTMethod.transform(self.app.REQUEST),        
            "Hello, sneezy")


    ################################################################
    # Test Runner Setup
    ################################################################

if __name__ == '__main__':
    # Specify which processor to use
    #ProcessorChooser.default = 'libxslt 1.0.27'
    ProcessorChooser.default = 'Pyana 0.6'
        
    # report which processor we are using
    print "Using processor:", \
          ProcessorChooser.ProcessorChooser().defaultProcessor()

    framework(descriptions=1, verbosity=2) # 0=quiet 1=default 2=verbose
else:
    # While framework.py provides its own test_suite() 
    # method the testrunner utility does not.
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        suite.addTest(unittest.makeSuite(XSLTMethodTestCase))
        return suite
