'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.10/tcllib-1.10/modules/math/fourier.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "math::fourier" n 1.0.2 math "Tcl Math Library"
.BS
.SH NAME
math::fourier \- Discrete and fast fourier transforms
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBmath::fourier  1.0.2\fR
.sp
\fB::math::fourier::dft\fR \fIin_data\fR
.sp
\fB::math::fourier::inverse_dft\fR \fIin_data\fR
.sp
\fB::math::fourier::lowpass\fR \fIcutoff\fR \fIin_data\fR
.sp
\fB::math::fourier::highpass\fR \fIcutoff\fR \fIin_data\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBmath::fourier\fR package implements two versions of discrete
Fourier transforms, the ordinary transform and the fast Fourier
transform. It also provides a few simple filter procedures as an
illustrations of how such filters can be implemented.
.PP
The purpose of this document is to describe the implemented procedures
and provide some examples of their usage. As there is ample literature
on the algorithms involved, we refer to relevant text books for more
explanations. We also refer to the original Wiki page on the subject
which describes some of the considerations behind the current
implementation.
.SH "GENERAL INFORMATION"
The two top-level procedures defined are
.IP \(bu
dft data-list
.IP \(bu
inverse_dft data-list
.PP
Both take a list of \fIcomplex numbers\fR and apply a Discrete Fourier
Transform (DFT) or its inverse respectively to these lists of numbers.
A "complex number" in this case is either (i) a pair (two element list) of
numbers, interpreted as the real and imaginary parts of the complex number,
or (ii) a single number, interpreted as the real part of a complex number
whose imaginary part is zero. The return value is always in the
first format. (The DFT generally produces complex results even if the
input is purely real.) Applying first one and then the other of these
procedures to a list of complex numbers will (modulo rounding errors
due to floating point arithmetic) return the original list of numbers.
.PP
If the input length N is a power of two then these procedures will
utilize the O(N log N) Fast Fourier Transform algorithm. If input
length is not a power of two then the DFT will instead be computed
using a the naive quadratic algorithm.
.PP
Some examples:
.nf

    % dft {1 2 3 4}
    {10 0.0} {-2.0 2.0} {-2 0.0} {-2.0 -2.0}
    % inverse_dft {{10 0.0} {-2.0 2.0} {-2 0.0} {-2.0 -2.0}}
    {1.0 0.0} {2.0 0.0} {3.0 0.0} {4.0 0.0}
    % dft {1 2 3 4 5}
    {15.0 0.0} {-2.5 3.44095480118} {-2.5 0.812299240582} {-2.5 -0.812299240582} {-2.5 -3.44095480118}
    % inverse_dft {{15.0 0.0} {-2.5 3.44095480118} {-2.5 0.812299240582} {-2.5 -0.812299240582} {-2.5 -3.44095480118}}
    {1.0 0.0} {2.0 8.881784197e-17} {3.0 4.4408920985e-17} {4.0 4.4408920985e-17} {5.0 -8.881784197e-17}

.fi
.PP
In the last case, the imaginary parts <1e-16 would have been zero in exact
arithmetic, but aren't here due to rounding errors.
.PP
Internally, the procedures use a flat list format where every even
index element of a list is a real part and every odd index element
is an imaginary part. This is reflected in the variable names by Re_
and Im_ prefixes.
.PP
The package includes two simple filters. They have an analogue
equivalent in a simple electronic circuit, a resistor and a capacitance
in series. Using these filters requires the
\fBmath::complexnumbers\fR package.
.SH PROCEDURES
The public Fourier transform procedures are:
.TP
\fB::math::fourier::dft\fR \fIin_data\fR
Determine the \fIFourier transform\fR of the given list of complex
numbers. The result is a list of complex numbers representing the
(complex) amplitudes of the Fourier components.
.RS
.TP
\fIin_data\fR list List of data
.RE
.sp
.TP
\fB::math::fourier::inverse_dft\fR \fIin_data\fR
Determine the \fIinverse Fourier transform\fR of the given list of
complex numbers (interpreted as amplitudes). The result is a list of
complex numbers representing the original (complex) data
.RS
.TP
\fIin_data\fR list List of data (amplitudes)
.RE
.sp
.TP
\fB::math::fourier::lowpass\fR \fIcutoff\fR \fIin_data\fR
Filter the (complex) amplitudes so that high-frequency components
are suppressed. The implemented filter is a first-order low-pass filter,
the discrete equivalent of a simple electronic circuit with a resistor
and a capacitance.
.RS
.TP
\fIcutoff\fR float Cut-off frequency
.TP
\fIin_data\fR list List of data (amplitudes)
.RE
.sp
.TP
\fB::math::fourier::highpass\fR \fIcutoff\fR \fIin_data\fR
Filter the (complex) amplitudes so that low-frequency components
are suppressed. The implemented filter is a first-order low-pass filter,
the discrete equivalent of a simple electronic circuit with a resistor
and a capacitance.
.RS
.TP
\fIcutoff\fR float Cut-off frequency
.TP
\fIin_data\fR list List of data (amplitudes)
.RE
.sp
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fImath :: fourier\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
FFT, Fourier transform, complex numbers, mathematics