'\"
'\" Generated from file '/usr/obj/ports/tcllib-1.10/tcllib-1.10/modules/bee/bee.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2006/07/01 03:37:56 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "bee" n 0.1 bee "BitTorrent"
.BS
.SH NAME
bee \- BitTorrent Serialization Format Encoder/Decoder
.SH SYNOPSIS
package require \fBTcl  8.4\fR
.sp
package require \fBbee  ?0.1?\fR
.sp
\fB::bee::encodeString\fR \fIstring\fR
.sp
\fB::bee::encodeNumber\fR \fIinteger\fR
.sp
\fB::bee::encodeListArgs\fR \fIvalue\fR...
.sp
\fB::bee::encodeList\fR \fIlist\fR
.sp
\fB::bee::encodeDictArgs\fR \fIkey\fR \fIvalue\fR...
.sp
\fB::bee::encodeDict\fR \fIdict\fR
.sp
\fB::bee::decode\fR \fIstring\fR ?\fIendvar\fR? ?\fIstart\fR?
.sp
\fB::bee::decodeIndices\fR \fIstring\fR ?\fIendvar\fR? ?\fIstart\fR?
.sp
\fB::bee::decodeChannel\fR \fIchan\fR \fB-command\fR \fIcmdprefix\fR ?\fB-exact\fR? ?\fB-prefix\fR \fIdata\fR?
.sp
\fBcmdprefix\fR \fBeof\fR \fItoken\fR
.sp
\fBcmdprefix\fR \fBerror\fR \fItoken\fR \fImessage\fR
.sp
\fBcmdprefix\fR \fBvalue\fR \fItoken\fR \fIvalue\fR
.sp
\fB::bee::decodeCancel\fR \fItoken\fR
.sp
\fB::bee::decodePush\fR \fItoken\fR \fIstring\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBbee\fR package provides de- and encoder commands for data
in bencoding (speak 'bee'), the serialization format for data and
messages used by the BitTorrent application.
.PP
.SH "PUBLIC API"
.SS ENCODER
The package provides one encoder command for each of the basic forms,
and two commands per container, one taking a proper tcl data structure
to encode in the container, the other taking the same information as
several arguments.
.PP
.TP
\fB::bee::encodeString\fR \fIstring\fR
Returns the bee-encoding of the \fIstring\fR.
.TP
\fB::bee::encodeNumber\fR \fIinteger\fR
Returns the bee-encoding of the \fIinteger\fR number.
.TP
\fB::bee::encodeListArgs\fR \fIvalue\fR...
Takes zero or more bee-encoded values and returns the bee-encoding of
their list.
.TP
\fB::bee::encodeList\fR \fIlist\fR
Takes a list of bee-encoded values and returns the bee-encoding of the
list.
.TP
\fB::bee::encodeDictArgs\fR \fIkey\fR \fIvalue\fR...
Takes zero or more pairs of keys and values and returns the
bee-encoding of the dictionary they form. The values are expected to
be already bee-encoded, but the keys must not be. Their encoding will
be done by the command itself.
.TP
\fB::bee::encodeDict\fR \fIdict\fR
Takes a dictionary list of string keys and bee-encoded values and
returns the bee-encoding of the list. Note that the keys in the input
must not be bee-encoded already. This will be done by the command
itself.
.PP
.PP
.SS DECODER
The package provides two main decoder commands, one for decoding a
string expected to contain a complete data structure, the other for
the incremental decoding of bee-values arriving on a channel. The
latter command is asynchronous and provides the completed decoded
values to the user through a command callback.
.PP
.TP
\fB::bee::decode\fR \fIstring\fR ?\fIendvar\fR? ?\fIstart\fR?
Takes the bee-encoding in the string and returns one decoded value. In
the case of this being a container all contained values are decoded
recursively as well and the result is a properly nested tcl list
and/or dictionary.
.sp
If the optional \fIendvar\fR is set then it is the name of a variable
to store the index of the first character \fIafter\fR the decoded
value into. In other words, if the string contains more than one value
then \fIendvar\fR can be used to obtain the position of the bee-value
after the bee-value currently decoded. together with \fIstart\fR, see
below, it is possible to iterate over the string to extract all
contained values.
.sp
The optional \fIstart\fR index defaults to \fB0\fR, i.e. the
beginning of the string. It is the index of the first character of the
bee-encoded value to extract.
.TP
\fB::bee::decodeIndices\fR \fIstring\fR ?\fIendvar\fR? ?\fIstart\fR?
Takes the same arguments as \fB::bee::decode\fR and returns the same
information in \fIendvar\fR. The result however is different. Instead
of the tcl value contained in the \fIstring\fR it returns a list
describing the value with respect to type and location (indices for
the first and last character of the bee-value). In case of a container
the structure also contains the same information for all the embedded
values.
.sp
Formally the results for the various types of bee-values are:
.RS
.TP
string
A list containing three elements:
.RS
.IP \(bu
The constant string \fBstring\fR, denoting the type of the value.
.IP \(bu
An integer number greater than or equal to zero. This is the index of
the first character of the bee-value in the input \fIstring\fR.
.IP \(bu
An integer number greater than or equal to zero. This is the index of
the last character of the bee-value in the input \fIstring\fR.
.RE
.sp
\fINote\fR that this information is present in the results for all
four types of bee-values, with only the first element changing
according to the type of the value.
.TP
integer
The result is like for strings, except that the type element contains
the constant string \fBinteger\fR.
.TP
list
The result is like before, with two exceptions: One, the type element
contains the constant string \fBlist\fR. And two, the result
actually contains four elements. The last element is new, and contains
the index data as described here for all elements of the bee-list.
.TP
dictionary
The result is like for strings, except that the type element contains
the constant string \fBdict\fR. A fourth element is present as well,
with a slightly different structure than for lists. The element is a
dictionary mapping from the strings keys of the bee-dictionary to a
list containing two elements. The first of them is the index
information for the key, and the second element is the index
information for the value the key maps to. This structure is the only
which contains not only index data, but actual values from the
bee-string. While the index information of the keys is unique enough,
i.e. serviceable as keys, they are not easy to navigate when trying to
find particular element. Using the actual keys makes this much easier.
.RE
.sp
.TP
\fB::bee::decodeChannel\fR \fIchan\fR \fB-command\fR \fIcmdprefix\fR ?\fB-exact\fR? ?\fB-prefix\fR \fIdata\fR?
The command creates a decoder for a series of bee-values arriving on
the channel \fIchan\fR and returns its handle. This handle can be used
to remove the decoder again.
Setting up another bee decoder on \fIchan\fR while a bee decoder is
still active will fail with an error message.
.sp
.RS
.TP
\fB-command\fR
The command prefix \fIcmdprefix\fR specified by the \fIrequired\fR
option \fB-command\fR is used to report extracted values and
exceptional situations (error, and EOF on the channel).
The callback will be executed at the global level of the interpreter,
with two or three arguments. The exact call signatures are
.sp
.RS
.TP
\fBcmdprefix\fR \fBeof\fR \fItoken\fR
The decoder has reached eof on the channel \fIchan\fR. No further
invocations of the callback will be made after this. The channel has
already been closed at the time of the call, and the \fItoken\fR is
not valid anymore as well.
.TP
\fBcmdprefix\fR \fBerror\fR \fItoken\fR \fImessage\fR
The decoder encountered an error, which is not eof. For example a
malformed bee-value. The \fImessage\fR provides details about the
error. The decoder token is in the same state as for eof,
i.e. invalid. The channel however is kept open.
.TP
\fBcmdprefix\fR \fBvalue\fR \fItoken\fR \fIvalue\fR
The decoder received and successfully decoded a bee-value.
The format of the equivalent tcl \fIvalue\fR is the same as returned
by \fB::bee::decode\fR. The channel is still open and the decoder
token is valid. This means that the callback is able to remove the
decoder.
.RE
.sp
.TP
\fB-exact\fR
By default the decoder assumes that the remainder of the data in the
channel consists only of bee-values, and reads as much as possible per
event, without regard for boundaries between bee-values. This means
that if the the input contains non-bee data after a series of
bee-value the beginning of that data may be lost because it was
already read by the decoder, but not processed.
.sp
The \fB-exact\fR was made for this situation. When specified the
decoder will take care to not read any characters behind the currently
processed bee-value, so that any non-bee data is kept in the channel
for further processing after removal of the decoder.
.sp
.TP
\fB-prefix\fR
If this option is specified its value is assumed to be the beginning
of the bee-value and used to initialize the internal decoder
buffer. This feature is required if the creator of the decoder used
data from the channel to determine if it should create the decoder or
not. Without the option this data would be lost to the decoding.
.RE
.sp
.TP
\fB::bee::decodeCancel\fR \fItoken\fR
This command cancels the decoder set up by \fB::bee::decodeChannel\fR
and represented by the handle \fItoken\fR.
.TP
\fB::bee::decodePush\fR \fItoken\fR \fIstring\fR
This command appends the \fIstring\fR to the internal decoder
buffer. It is the runtime equivalent of the option \fB-prefix\fR of
\fB::bee::decodeChannel\fR. Use it to push data back into the decoder
when the \fBvalue\fR callback used data from the channel to
determine if it should decode another bee-value or not.
.PP
.PP
.SH "FORMAT DEFINITION"
Data in the bee serialization format is constructed from two basic
forms, and two container forms. The basic forms are strings and
integer numbers, and the containers are lists and dictionaries.
.PP
.TP
String \fIS\fR
A string \fIS\fR of length \fIL\fR is encoded by the string
"\fIL\fR\fB:\fR\fIS\fR", where the length is written out in textual
form.
.TP
Integer \fIN\fR
An integer number \fIN\fR is encoded by the string
"\fBi\fR\fIN\fR\fBe\fR".
.TP
List \fIv1\fR ... \fIvn\fR
A list of the values \fIv1\fR to \fIvn\fR is encoded by the string
"\fBl\fR\fIBV1\fR...\fIBVn\fR\fBe\fR"
where "BV\fBi\fR" is the bee-encoding of the value "v\fBi\fR".
.TP
Dict \fIk1\fR -> \fIv1\fR ...
A dictionary mapping the string key \fIk\fR\fBi\fR to the value
\fIv\fR\fBi\fR, for \fBi\fR in \fB1\fR ... \fBn\fR
is encoded by the string
"\fBd\fR\fIBK\fR\fBi\fR\fIBV\fR\fBi\fR...\fBe\fR"
for i in \fB1\fR ... \fBn\fR, where "BK\fBi\fR" is the bee-encoding
of the key string "k\fBi\fR".  and "BV\fBi\fR" is the bee-encoding of
the value "v\fBi\fR".
.sp
\fINote\fR: The bee-encoding does not retain the order of the keys in
the input, but stores in a sorted order. The sorting is done for the
"raw strings".
.PP
.PP
Note that the type of each encoded item can be determined immediately
from the first character of its representation:
.PP
.TP
i
Integer.
.TP
l
List.
.TP
d
Dictionary.
.TP
[0-9]
String.
.PP
.PP
By wrapping an integer number into \fBi\fR...\fBe\fR the format
makes sure that they are different from strings, which all begin with
a digit.
.SH EXAMPLES
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIbee\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
BitTorrent, bee, bittorrent, serialization, torrent
.SH COPYRIGHT
.nf
Copyright (c) 2004 Andreas Kupries <andreas_kupries@users.sourceforge.net>

.fi