/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.util.Random;
import org.kaffe.util.Ptr;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BigInteger
extends Number
implements Comparable {
    private static final long serialVersionUID = -8287574255936472291L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final BigInteger MINUS_ONE;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger TWO;
    private transient Ptr number;
    private transient int hash;
    static /* synthetic */ Class array$B;

    private static final byte[] randBytes(int n, Random random) {
        if (n < 0) {
            throw new IllegalArgumentException("numBits < 0");
        }
        int n2 = n % 8;
        int n3 = n / 8;
        int n4 = 0;
        if (n2 > 0) {
            n4 = 1;
        }
        byte[] byArray = new byte[n3 + n4];
        random.nextBytes(byArray);
        if (n2 > 0) {
            byArray[0] = (byte)(byArray[0] & ~(-1 << 8 - n2));
        }
        return byArray;
    }

    public static BigInteger valueOf(long l) {
        return new BigInteger(l);
    }

    public BigInteger add(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.add0(this, bigInteger);
        return bigInteger2;
    }

    private static final void checkIfBitAddressIsNotNegative(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative bit address");
        }
    }

    public BigInteger subtract(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.sub0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger multiply(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.mul0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger divide(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.div0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.rem0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        BigInteger bigInteger3 = new BigInteger();
        BigInteger.divrem0(bigInteger2, bigInteger3, this, bigInteger);
        return new BigInteger[]{bigInteger2, bigInteger3};
    }

    public BigInteger pow(int n) {
        BigInteger bigInteger = new BigInteger();
        bigInteger.pow0(this, n);
        return bigInteger;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.gcd0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger abs() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.abs0(this);
        return bigInteger;
    }

    public BigInteger negate() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.neg0(this);
        return bigInteger;
    }

    public int signum() {
        return this.compareTo(ZERO);
    }

    public BigInteger mod(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.mod0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = new BigInteger();
        bigInteger3.modpow0(this, bigInteger, bigInteger2);
        return bigInteger3;
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.modinv0(this, bigInteger);
        return bigInteger2;
    }

    private final BigInteger shift(int n) {
        if (n == 0 || this.equals(ZERO)) {
            return this;
        }
        if (this.bitLength() < -n) {
            switch (this.signum()) {
                case 0: 
                case 1: {
                    return ZERO;
                }
                case -1: {
                    return MINUS_ONE;
                }
            }
            throw new InternalError("signum not in {-1,0,1}");
        }
        BigInteger bigInteger = ZERO.setBit(Math.abs(n));
        if (n > 0) {
            return this.multiply(bigInteger);
        }
        switch (this.signum()) {
            case 1: {
                return this.divide(bigInteger);
            }
            case 0: {
                return this;
            }
            case -1: {
                BigInteger[] bigIntegerArray = this.divideAndRemainder(bigInteger);
                if (!bigIntegerArray[1].equals(ZERO)) {
                    bigIntegerArray[0] = bigIntegerArray[0].subtract(ONE);
                }
                return bigIntegerArray[0];
            }
        }
        throw new InternalError("signum not in {-1,0,1}");
    }

    public BigInteger shiftLeft(int n) {
        return this.shift(n);
    }

    public BigInteger shiftRight(int n) {
        return this.shift(-n);
    }

    public BigInteger and(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.and0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger or(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.or0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger xor(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.xor0(this, bigInteger);
        return bigInteger2;
    }

    public BigInteger not() {
        BigInteger bigInteger = new BigInteger();
        bigInteger.not0(this);
        return bigInteger;
    }

    public BigInteger andNot(BigInteger bigInteger) {
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.and0(this, bigInteger);
        bigInteger2.not0(bigInteger2);
        return bigInteger2;
    }

    public boolean testBit(int n) {
        BigInteger.checkIfBitAddressIsNotNegative(n);
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(this, n);
        return BigInteger.cmp0(bigInteger, this) == 0;
    }

    public BigInteger setBit(int n) {
        BigInteger.checkIfBitAddressIsNotNegative(n);
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(this, n);
        return bigInteger;
    }

    public BigInteger clearBit(int n) {
        BigInteger.checkIfBitAddressIsNotNegative(n);
        BigInteger bigInteger = new BigInteger();
        bigInteger.clrbit0(this, n);
        return bigInteger;
    }

    public BigInteger flipBit(int n) {
        BigInteger.checkIfBitAddressIsNotNegative(n);
        BigInteger bigInteger = new BigInteger();
        bigInteger.setbit0(bigInteger, n);
        bigInteger.xor0(bigInteger, this);
        return bigInteger;
    }

    public int getLowestSetBit() {
        return this.scansetbit0();
    }

    public int bitLength() {
        return this.bitLength0();
    }

    public int bitCount() {
        if (this.compareTo(ZERO) < 0) {
            return this.negate().hamDist0(ZERO);
        }
        return this.hamDist0(ZERO);
    }

    public boolean isProbablePrime(int n) {
        return this.probablyPrime0(n) != 0;
    }

    public static BigInteger probablePrime(int n, Random random) {
        return new BigInteger(n, 100, random);
    }

    public int compareTo(Object object) {
        return this.compareTo((BigInteger)object);
    }

    public int compareTo(BigInteger bigInteger) {
        int n = BigInteger.cmp0(this, bigInteger);
        int n2 = 0;
        if (n != 0) {
            n2 = n < 0 ? -1 : 1;
        }
        return n2;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof BigInteger && this.compareTo((BigInteger)object) == 0) {
            bl = true;
        }
        return bl;
    }

    public BigInteger min(BigInteger bigInteger) {
        int n = this.compareTo(bigInteger);
        if (n > 0) {
            return bigInteger;
        }
        return this;
    }

    public BigInteger max(BigInteger bigInteger) {
        int n = this.compareTo(bigInteger);
        if (n < 0) {
            return bigInteger;
        }
        return this;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = 0;
            int n2 = BigInteger.cmp0(this, ZERO);
            BigInteger bigInteger = this.abs();
            BigInteger bigInteger2 = new BigInteger();
            bigInteger2.setbit0(bigInteger2, 32);
            int n3 = this.bitLength() / 8;
            while (n3 > 4) {
                n ^= bigInteger.toInt0();
                bigInteger.div0(bigInteger, bigInteger2);
                n3 -= 4;
            }
            n ^= bigInteger.toInt0();
            this.hash = n *= n2;
        }
        return this.hash;
    }

    public String toString(int n) {
        if (n < 2 || n > 36) {
            n = 10;
        }
        return this.toString0(n);
    }

    public String toString() {
        return this.toString(10);
    }

    public byte[] toByteArray() {
        int n;
        byte[] byArray = new byte[1 + this.bitLength0() / 8];
        BigInteger bigInteger = this.abs();
        BigInteger bigInteger2 = new BigInteger();
        bigInteger2.setbit0(bigInteger2, 32);
        int n2 = BigInteger.cmp0(this, ZERO);
        if (n2 < 0) {
            bigInteger.sub0(bigInteger, ONE);
        }
        int n3 = byArray.length;
        while (n3 > 4) {
            n = bigInteger.toInt0();
            byArray[--n3] = (byte)n;
            byArray[--n3] = (byte)(n >> 8);
            byArray[--n3] = (byte)(n >> 16);
            byArray[--n3] = (byte)(n >> 24);
            bigInteger.div0(bigInteger, bigInteger2);
        }
        n = bigInteger.toInt0();
        switch (n3) {
            case 4: {
                byArray[--n3] = (byte)n;
                n >>= 8;
            }
            case 3: {
                byArray[--n3] = (byte)n;
                n >>= 8;
            }
            case 2: {
                byArray[--n3] = (byte)n;
                n >>= 8;
            }
            case 1: {
                byArray[--n3] = (byte)n;
            }
        }
        if (n2 < 0) {
            n3 = byArray.length;
            while (n3-- > 0) {
                byArray[n3] = ~byArray[n3];
            }
        }
        return byArray;
    }

    public int intValue() {
        if (this.signum() < 0) {
            return -this.toInt0();
        }
        return this.toInt0();
    }

    public long longValue() {
        long l = (long)this.abs().shiftRight(32).toInt0() << 32 | (long)this.toInt0() & 0xFFFFFFFFL;
        if (this.signum() < 0) {
            return -l;
        }
        return l;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        return this.toDouble0();
    }

    protected void finalize() throws Throwable {
        this.finalize0();
        super.finalize();
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("bitCount", this.bitCount());
        putField.put("bitLength", this.bitLength());
        putField.put("lowestSetBit", this.getLowestSetBit());
        putField.put("magnitude", this.toByteArray());
        putField.put("signum", this.signum());
        objectOutputStream.writeFields();
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.init0();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        byte[] byArray = (byte[])getField.get("magnitude", null);
        int n = getField.get("signum", 0);
        this.assignBytes0(n, byArray);
    }

    private final native void init0();

    private final native void finalize0();

    private final native void assignBytes0(int var1, byte[] var2);

    private final native int assignString0(String var1, int var2);

    private final native void assignLong0(long var1);

    private final native void add0(BigInteger var1, BigInteger var2);

    private final native void sub0(BigInteger var1, BigInteger var2);

    private final native void mul0(BigInteger var1, BigInteger var2);

    private final native void div0(BigInteger var1, BigInteger var2);

    private final native void rem0(BigInteger var1, BigInteger var2);

    private final native void abs0(BigInteger var1);

    private final native void neg0(BigInteger var1);

    private final native void pow0(BigInteger var1, int var2);

    private final native void gcd0(BigInteger var1, BigInteger var2);

    private final native void mod0(BigInteger var1, BigInteger var2);

    private final native void modpow0(BigInteger var1, BigInteger var2, BigInteger var3);

    private final native void modinv0(BigInteger var1, BigInteger var2);

    private final native void and0(BigInteger var1, BigInteger var2);

    private final native void or0(BigInteger var1, BigInteger var2);

    private final native void xor0(BigInteger var1, BigInteger var2);

    private final native void not0(BigInteger var1);

    private final native void clrbit0(BigInteger var1, int var2);

    private final native void setbit0(BigInteger var1, int var2);

    private final native int scansetbit0();

    private final native int probablyPrime0(int var1);

    private final native int bitLength0();

    private final native int hamDist0(BigInteger var1);

    private static final native int cmp0(BigInteger var0, BigInteger var1);

    private static final native void initialize0();

    private static final native void divrem0(BigInteger var0, BigInteger var1, BigInteger var2, BigInteger var3);

    private final native String toString0(int var1);

    private final native double toDouble0();

    private final native int toInt0();

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public BigInteger(byte[] byArray) {
        this();
        int n;
        if (byArray.length == 0) {
            throw new NumberFormatException("val.length == 0");
        }
        int n2 = n = (byArray[0] & 0x80) == 0 ? 1 : -1;
        if (n == -1) {
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = ~byArray[n3];
                ++n3;
            }
        }
        this.assignBytes0(n, byArray);
        if (n == -1) {
            this.add0(this, ONE);
        }
    }

    public BigInteger(int n, byte[] byArray) {
        this();
        switch (n) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new NumberFormatException("signum < -1 || signum > 1");
            }
        }
        if (byArray.length != 0) {
            this.assignBytes0(n, byArray);
            if (n == 0 && BigInteger.cmp0(this, ZERO) != 0) {
                throw new NumberFormatException("signum == 0 && magnitude[i] != 0");
            }
        }
    }

    public BigInteger(String string, int n) {
        this();
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Bad radix: " + n);
        }
        if (this.assignString0(string, n) == -1) {
            throw new NumberFormatException("Bad format: val = " + string + ", radix = " + n);
        }
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(int n, Random random) {
        this(1, BigInteger.randBytes(n, random));
    }

    public BigInteger(int n, int n2, Random random) {
        this();
        if (n < 2) {
            throw new ArithmeticException("bitLength < 2");
        }
        byte[] byArray = new byte[(n + 7) / 8];
        int n3 = 8 - n % 8;
        byte by = (byte)(~(-1 << n3));
        byte by2 = (byte)(256 >> n3);
        block0: while (true) {
            random.nextBytes(byArray);
            byArray[0] = (byte)(byArray[0] & by | by2);
            if (n > 2) {
                int n4 = byArray.length - 1;
                byArray[n4] = (byte)(byArray[n4] | 1);
            }
            this.assignBytes0(1, byArray);
            if (this.probablyPrime0(n2) == 1) break;
            long l = this.longValue() - 1L;
            if (n < 64) {
                l |= (long)-1 << n;
            }
            do {
                this.add0(this, TWO);
                if ((l += (long)2) == 0L && this.bitLength0() > n) continue block0;
            } while (this.probablyPrime0(n2) == 0);
            break;
        }
    }

    private BigInteger(long l) {
        this();
        this.assignLong0(l);
    }

    private BigInteger() {
        this.init0();
    }

    static {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[5];
        objectStreamFieldArray[0] = new ObjectStreamField("bitCount", Integer.TYPE);
        objectStreamFieldArray[1] = new ObjectStreamField("bitLength", Integer.TYPE);
        objectStreamFieldArray[2] = new ObjectStreamField("lowestSetBit", Integer.TYPE);
        Class clazz = array$B;
        if (clazz == null) {
            clazz = array$B = BigInteger.class("[B", true);
        }
        objectStreamFieldArray[3] = new ObjectStreamField("magnitude", clazz);
        objectStreamFieldArray[4] = new ObjectStreamField("signum", Integer.TYPE);
        serialPersistentFields = objectStreamFieldArray;
        System.loadLibrary("math");
        BigInteger.initialize0();
        MINUS_ONE = new BigInteger(-1);
        ZERO = new BigInteger();
        ONE = new BigInteger(1L);
        TWO = new BigInteger(2);
    }
}

