/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;
import org.xbill.DNS.DNSKEYRecord;
import org.xbill.DNS.KEYRecord;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.security.DHPubKey;
import org.xbill.DNS.security.DSAPubKey;
import org.xbill.DNS.security.RSAPubKey;

public class KEYConverter {
    private static final BigInteger DHPRIME768 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A3620FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger DHPRIME1024 = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger TWO = new BigInteger("2", 16);

    static int BigIntegerLength(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        return byArray[0] == 0 ? byArray.length - 1 : byArray.length;
    }

    static BigInteger readBigInteger(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = dataInputStream.read(byArray);
        if (n2 < n) {
            throw new IOException("end of input");
        }
        return new BigInteger(1, byArray);
    }

    static void writeBigInteger(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byteArrayOutputStream.write(byArray, 1, byArray.length - 1);
        } else {
            byteArrayOutputStream.write(byArray, 0, byArray.length);
        }
    }

    static void writeShort(ByteArrayOutputStream byteArrayOutputStream, int n) {
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
    }

    static RSAPublicKey parseRSA(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        if (n == 0) {
            n = dataInputStream.readUnsignedShort();
        }
        BigInteger bigInteger = KEYConverter.readBigInteger(dataInputStream, n);
        int n2 = dataInputStream.available();
        BigInteger bigInteger2 = KEYConverter.readBigInteger(dataInputStream, n2);
        RSAPubKey rSAPubKey = new RSAPubKey(bigInteger2, bigInteger);
        return rSAPubKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DHPublicKey parseDH(DataInputStream dataInputStream) throws IOException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n = 0;
        int n2 = dataInputStream.readUnsignedShort();
        if (n2 < 16 && n2 != 1 && n2 != 2) {
            return null;
        }
        if (n2 == 1 || n2 == 2) {
            n = n2 == 1 ? dataInputStream.readUnsignedByte() : dataInputStream.readUnsignedShort();
            if (n != 1 && n != 2) {
                return null;
            }
            bigInteger2 = n == 1 ? DHPRIME768 : DHPRIME1024;
        } else {
            bigInteger2 = KEYConverter.readBigInteger(dataInputStream, n2);
        }
        int n3 = dataInputStream.readUnsignedShort();
        if (n3 == 0) {
            if (n == 0) return null;
            bigInteger = TWO;
        } else {
            bigInteger = KEYConverter.readBigInteger(dataInputStream, n3);
        }
        int n4 = dataInputStream.readUnsignedShort();
        BigInteger bigInteger3 = KEYConverter.readBigInteger(dataInputStream, n4);
        return new DHPubKey(bigInteger2, bigInteger, bigInteger3);
    }

    static DSAPublicKey parseDSA(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        BigInteger bigInteger = KEYConverter.readBigInteger(dataInputStream, 20);
        BigInteger bigInteger2 = KEYConverter.readBigInteger(dataInputStream, 64 + by * 8);
        BigInteger bigInteger3 = KEYConverter.readBigInteger(dataInputStream, 64 + by * 8);
        BigInteger bigInteger4 = KEYConverter.readBigInteger(dataInputStream, 64 + by * 8);
        DSAPubKey dSAPubKey = new DSAPubKey(bigInteger2, bigInteger, bigInteger3, bigInteger4);
        return dSAPubKey;
    }

    static PublicKey parseRecord(int n, byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            switch (n) {
                case 1: 
                case 5: {
                    return KEYConverter.parseRSA(dataInputStream);
                }
                case 2: {
                    return KEYConverter.parseDH(dataInputStream);
                }
                case 3: {
                    return KEYConverter.parseDSA(dataInputStream);
                }
            }
            return null;
        }
        catch (IOException iOException) {
            if (Options.check("verboseexceptions")) {
                System.err.println(iOException);
            }
            return null;
        }
    }

    public static PublicKey parseRecord(DNSKEYRecord dNSKEYRecord) {
        int n = dNSKEYRecord.getAlgorithm();
        byte[] byArray = dNSKEYRecord.getKey();
        return KEYConverter.parseRecord(n, byArray);
    }

    public static PublicKey parseRecord(KEYRecord kEYRecord) {
        int n = kEYRecord.getAlgorithm();
        byte[] byArray = kEYRecord.getKey();
        return KEYConverter.parseRecord(n, byArray);
    }

    static byte[] buildRSA(RSAPublicKey rSAPublicKey) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BigInteger bigInteger = rSAPublicKey.getPublicExponent();
        BigInteger bigInteger2 = rSAPublicKey.getModulus();
        int n = KEYConverter.BigIntegerLength(bigInteger);
        if (n < 256) {
            byteArrayOutputStream.write(n);
        } else {
            byteArrayOutputStream.write(0);
            KEYConverter.writeShort(byteArrayOutputStream, n);
        }
        KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger);
        KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger2);
        return byteArrayOutputStream.toByteArray();
    }

    static byte[] buildDH(DHPublicKey dHPublicKey) {
        int n;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BigInteger bigInteger = dHPublicKey.getParams().getP();
        BigInteger bigInteger2 = dHPublicKey.getParams().getG();
        BigInteger bigInteger3 = dHPublicKey.getY();
        if (bigInteger2.equals(TWO) && (bigInteger.equals(DHPRIME768) || bigInteger.equals(DHPRIME1024))) {
            n2 = 1;
            n = 0;
        } else {
            n2 = KEYConverter.BigIntegerLength(bigInteger);
            n = KEYConverter.BigIntegerLength(bigInteger2);
        }
        int n3 = KEYConverter.BigIntegerLength(bigInteger3);
        KEYConverter.writeShort(byteArrayOutputStream, n2);
        if (n2 == 1) {
            if (bigInteger.bitLength() == 768) {
                byteArrayOutputStream.write(1);
            } else {
                byteArrayOutputStream.write(2);
            }
        } else {
            KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger);
        }
        KEYConverter.writeShort(byteArrayOutputStream, n);
        if (n > 0) {
            KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger2);
        }
        KEYConverter.writeShort(byteArrayOutputStream, n3);
        KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger3);
        return byteArrayOutputStream.toByteArray();
    }

    static byte[] buildDSA(DSAPublicKey dSAPublicKey) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BigInteger bigInteger = dSAPublicKey.getParams().getQ();
        BigInteger bigInteger2 = dSAPublicKey.getParams().getP();
        BigInteger bigInteger3 = dSAPublicKey.getParams().getG();
        BigInteger bigInteger4 = dSAPublicKey.getY();
        int n = (bigInteger2.toByteArray().length - 64) / 8;
        byteArrayOutputStream.write(n);
        KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger);
        KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger2);
        KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger3);
        KEYConverter.writeBigInteger(byteArrayOutputStream, bigInteger4);
        return byteArrayOutputStream.toByteArray();
    }

    public static KEYRecord buildRecord(Name name, int n, long l, int n2, int n3, PublicKey publicKey) {
        byte[] byArray;
        int n4;
        if (publicKey instanceof RSAPublicKey) {
            n4 = 1;
            byArray = KEYConverter.buildRSA((RSAPublicKey)publicKey);
        } else if (publicKey instanceof DHPublicKey) {
            n4 = 2;
            byArray = KEYConverter.buildDH((DHPublicKey)publicKey);
        } else if (publicKey instanceof DSAPublicKey) {
            n4 = 3;
            byArray = KEYConverter.buildDSA((DSAPublicKey)publicKey);
        } else {
            return null;
        }
        if (byArray == null) {
            return null;
        }
        return new KEYRecord(name, n, l, n2, n3, n4, byArray);
    }
}

