/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.xbill.DNS.TextParseException;

final class FormattedTime {
    private static NumberFormat w2 = new DecimalFormat();
    private static NumberFormat w4;

    public static final String format(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        StringBuffer stringBuffer = new StringBuffer();
        gregorianCalendar.setTime(date);
        stringBuffer.append(w4.format(gregorianCalendar.get(1)));
        stringBuffer.append(w2.format(gregorianCalendar.get(2) + 1));
        stringBuffer.append(w2.format(gregorianCalendar.get(5)));
        stringBuffer.append(w2.format(gregorianCalendar.get(11)));
        stringBuffer.append(w2.format(gregorianCalendar.get(12)));
        stringBuffer.append(w2.format(gregorianCalendar.get(13)));
        return stringBuffer.toString();
    }

    public static final Date parse(String string) throws TextParseException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        if (string.length() != 14) {
            throw new TextParseException("Invalid time encoding: " + string);
        }
        try {
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(4, 6)) - 1;
            int n3 = Integer.parseInt(string.substring(6, 8));
            int n4 = Integer.parseInt(string.substring(8, 10));
            int n5 = Integer.parseInt(string.substring(10, 12));
            int n6 = Integer.parseInt(string.substring(12, 14));
            gregorianCalendar.set(n, n2, n3, n4, n5, n6);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TextParseException("Invalid time encoding: " + string);
        }
        return gregorianCalendar.getTime();
    }

    private FormattedTime() {
    }

    static {
        w2.setMinimumIntegerDigits(2);
        w4 = new DecimalFormat();
        w4.setMinimumIntegerDigits(4);
        w4.setGroupingUsed(false);
    }
}

