/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.midi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.tritonus.share.TDebug;

public class MidiUtils {
    public static int getUnsignedInteger(byte n) {
        return n < 0 ? n + 256 : n;
    }

    public static int get14bitValue(int n, int n2) {
        return n & 0x7F | (n2 & 0x7F) << 7;
    }

    public static int get14bitMSB(int n) {
        return n >> 7 & 0x7F;
    }

    public static int get14bitLSB(int n) {
        return n & 0x7F;
    }

    public static byte[] getVariableLengthQuantity(long l) {
        ByteArrayOutputStream byteArrayOutputStream;
        block2: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                MidiUtils.writeVariableLengthQuantity(l, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                if (!TDebug.TraceAllExceptions) break block2;
                TDebug.out(iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static int writeVariableLengthQuantity(long l, OutputStream outputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = (int)(l >> 21 & 0x7FL);
        if (n2 != 0) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
            bl = true;
        }
        if ((n2 = (int)(l >> 14 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
            bl = true;
        }
        if ((n2 = (int)(l >> 7 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
        }
        n2 = (int)(l & 0x7FL);
        if (outputStream != null) {
            outputStream.write(n2);
        }
        return ++n;
    }
}

