/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.mixer.esd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import org.tritonus.lowlevel.esd.EsdSample;
import org.tritonus.sampled.mixer.esd.EsdUtils;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.mixer.TDataLine;
import org.tritonus.share.sampled.mixer.TMixer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class EsdClip
extends TDataLine
implements Clip {
    private static final Class[] CONTROL_CLASSES = new Class[0];
    private static final int BUFFER_FRAMES = 16384;
    private Mixer m_mixer;
    private EsdSample m_esdSample;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public void open(AudioFormat audioFormat, byte[] byArray, int n, int n2) throws LineUnavailableException {
        int n3 = n2 * audioFormat.getFrameSize();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n3);
        try {
            AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, n2);
            this.open(audioInputStream);
        }
        catch (IOException iOException) {
            if (TDebug.TraceAllExceptions) {
                TDebug.out(iOException);
            }
            throw new LineUnavailableException();
        }
    }

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        AudioFormat audioFormat = audioInputStream.getFormat();
        Class clazz = class$javax$sound$sampled$Clip;
        if (clazz == null) {
            clazz = class$javax$sound$sampled$Clip = EsdClip.class("[Ljavax.sound.sampled.Clip;", false);
        }
        DataLine.Info info = new DataLine.Info(clazz, audioFormat, -1);
        this.setLineInfo(info);
        int n = audioFormat.getFrameSize();
        long l = audioInputStream.getFrameLength() * (long)n;
        int n2 = 0x1000 | EsdUtils.getEsdFormat(audioFormat);
        if (TDebug.TraceClip) {
            TDebug.out("format: " + n2);
            TDebug.out("sample rate: " + audioFormat.getSampleRate());
        }
        this.m_esdSample.open(n2, (int)audioFormat.getSampleRate(), (int)l);
        if (TDebug.TraceClip) {
            TDebug.out("size in esd: " + audioInputStream.getFrameLength() * (long)n);
        }
        int n3 = 16384 * n;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        while (n4 != -1) {
            block7: {
                try {
                    n4 = audioInputStream.read(byArray, 0, byArray.length);
                }
                catch (IOException iOException) {
                    if (!TDebug.TraceClip && !TDebug.TraceAllExceptions) break block7;
                    TDebug.out(iOException);
                }
            }
            if (n4 < 0) continue;
            n5 += n4;
            if (TDebug.TraceClip) {
                TDebug.out("EsdClip.open(): total bytes: " + n5);
                TDebug.out("EsdClip.open(): Trying to write: " + n4);
            }
            int n6 = this.m_esdSample.write(byArray, 0, n4);
            if (!TDebug.TraceClip) continue;
            TDebug.out("EsdClip.open(): Written: " + n6);
        }
        this.open();
    }

    public int getFrameLength() {
        return -1;
    }

    public long getMicrosecondLength() {
        return -1;
    }

    public void setFramePosition(int n) {
    }

    public void setMicrosecondPosition(long l) {
    }

    public int getFramePosition() {
        return -1;
    }

    public long getMicrosecondPosition() {
        return -1;
    }

    public void setLoopPoints(int n, int n2) {
    }

    public void loop(int n) {
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.loop(int): called; count = " + n);
        }
        if (n == 0) {
            if (TDebug.TraceClip) {
                TDebug.out("EsdClip.loop(int): starting sample (once)");
            }
            this.m_esdSample.play();
        } else {
            if (TDebug.TraceClip) {
                TDebug.out("EsdClip.loop(int): starting sample (forever)");
            }
            this.m_esdSample.loop();
        }
    }

    public void flush() {
    }

    public void drain() {
    }

    public void close() {
        this.m_esdSample.free();
        this.m_esdSample.close();
    }

    public void open() {
    }

    public void start() {
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.start(): called");
        }
        if (TDebug.TraceClip) {
            TDebug.out("EsdClip.start(): calling 'loop(0)' [hack]");
        }
        this.loop(0);
    }

    public void stop() {
        this.m_esdSample.kill();
    }

    public int available() {
        return -1;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public EsdClip(TMixer tMixer) {
        super(tMixer, null);
        this.m_mixer = tMixer;
        this.m_esdSample = new EsdSample();
    }
}

