/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.sampled.file.WaveTool;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class WaveAudioFileReader
extends TAudioFileReader {
    private static final int READ_LIMIT = 1000;

    protected void advanceChunk(DataInputStream dataInputStream, long l, long l2) throws IOException {
        if (l > 0L) {
            dataInputStream.skip((l + 1L & 0xFFFFFFFFFFFFFFFEL) - l2);
        }
    }

    protected long findChunk(DataInputStream dataInputStream, int n) throws UnsupportedAudioFileException, IOException {
        int n2;
        long l = 0L;
        do {
            this.advanceChunk(dataInputStream, l, 0L);
            try {
                n2 = dataInputStream.readInt();
            }
            catch (IOException iOException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(iOException);
                }
                throw new UnsupportedAudioFileException("unsupported WAVE file: required chunk not found.");
            }
            l = WaveAudioFileReader.readLittleEndianInt(dataInputStream) & 0xFFFFFFFF;
        } while (n2 != n);
        return l;
    }

    protected AudioFormat readFormatChunk(DataInputStream dataInputStream, long l) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding;
        int n;
        String string = "";
        int n2 = 14;
        if (l < 14L) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: format chunk is too small");
        }
        short s = WaveAudioFileReader.readLittleEndianShort(dataInputStream);
        short s2 = WaveAudioFileReader.readLittleEndianShort(dataInputStream);
        if (s2 <= 0) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: number of channels must be positive");
        }
        int n3 = WaveAudioFileReader.readLittleEndianInt(dataInputStream);
        if (n3 <= 0) {
            throw new UnsupportedAudioFileException("corrupt WAVE file: sample rate must be positive");
        }
        int n4 = WaveAudioFileReader.readLittleEndianInt(dataInputStream);
        short s3 = WaveAudioFileReader.readLittleEndianShort(dataInputStream);
        int n5 = 0;
        float f = n3;
        short s4 = 0;
        switch (s) {
            case 1: {
                if (l < 16L) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: format chunk is too small");
                }
                n = WaveAudioFileReader.readLittleEndianShort(dataInputStream);
                if (n <= 0) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: sample size must be positive");
                }
                AudioFormat.Encoding encoding2 = encoding = n <= 8 ? AudioFormat.Encoding.PCM_UNSIGNED : AudioFormat.Encoding.PCM_SIGNED;
                if (TDebug.TraceAudioFileReader) {
                    string = string + ", wBitsPerSample=" + n;
                }
                n2 += 2;
                break;
            }
            case 6: {
                n = 8;
                encoding = AudioFormat.Encoding.ALAW;
                break;
            }
            case 7: {
                n = 8;
                encoding = AudioFormat.Encoding.ULAW;
                break;
            }
            case 49: {
                if (l < 20L) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra GSM bytes are missing");
                }
                n = WaveAudioFileReader.readLittleEndianShort(dataInputStream);
                s4 = WaveAudioFileReader.readLittleEndianShort(dataInputStream);
                if (s4 < 2) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra GSM bytes are corrupt");
                }
                int n6 = WaveAudioFileReader.readLittleEndianShort(dataInputStream) & (char)-1;
                if (TDebug.TraceAudioFileReader) {
                    string = string + ", wBitsPerSample=" + n + ", cbSize=" + s4 + ", wSamplesPerBlock=" + n6;
                }
                n = -1;
                encoding = WaveTool.GSM0610;
                n5 = s3;
                f = (float)n3 / (float)n6;
                n2 += 6;
                break;
            }
            case 17: {
                if (l < 16L) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra GSM bytes are missing");
                }
                n = WaveAudioFileReader.readLittleEndianShort(dataInputStream);
                s4 = WaveAudioFileReader.readLittleEndianShort(dataInputStream);
                if (s4 < 2) {
                    throw new UnsupportedAudioFileException("corrupt WAVE file: extra IMA ADPCM bytes are corrupt");
                }
                int n7 = WaveAudioFileReader.readLittleEndianShort(dataInputStream) & (char)-1;
                if (TDebug.TraceAudioFileReader) {
                    string = string + ", wBitsPerSample=" + n + ", cbSize=" + s4 + ", wSamplesPerBlock=" + n7;
                }
                n = -1;
                encoding = WaveTool.GSM0610;
                n5 = s3;
                f = (float)n3 / (float)n7;
                n2 += 6;
                break;
            }
            default: {
                throw new UnsupportedAudioFileException("unsupported WAVE file: unknown format code " + s);
            }
        }
        if (n5 == 0) {
            n5 = WaveAudioFileReader.calculateFrameSize(n, s2);
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("WaveAudioFileReader.readFormatChunk():");
            TDebug.out("  read values: wFormatTag=" + s + ", nChannels=" + s2 + ", nSamplesPerSec=" + n3 + ", nAvgBytesPerSec=" + n4 + ", nBlockAlign==" + s3 + string);
            TDebug.out("  constructed values: encoding=" + encoding + ", sampleRate=" + (float)n3 + ", sampleSizeInBits=" + n + ", channels=" + s2 + ", frameSize=" + n5 + ", frameRate=" + f);
        }
        this.advanceChunk(dataInputStream, l, n2);
        return new AudioFormat(encoding, n3, n, s2, n5, f, false);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        if (n != 1380533830) {
            throw new UnsupportedAudioFileException("not a WAVE file: wrong header magic");
        }
        long l2 = WaveAudioFileReader.readLittleEndianInt(dataInputStream) & 0xFFFFFFFF;
        n = dataInputStream.readInt();
        if (n != 1463899717) {
            throw new UnsupportedAudioFileException("not a WAVE file: wrong header magic");
        }
        long l3 = this.findChunk(dataInputStream, 1718449184);
        AudioFormat audioFormat = this.readFormatChunk(dataInputStream, l3);
        long l4 = this.findChunk(dataInputStream, 1684108385);
        long l5 = l4 / (long)audioFormat.getFrameSize();
        if (audioFormat.getEncoding().equals(WaveTool.GSM0610)) {
            l5 = l4;
        }
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("WaveAudioFileReader.getAudioFileFormat(): total length: " + l2 + ", frame length = " + l5);
        }
        return new TAudioFileFormat(AudioFileFormat.Type.WAVE, audioFormat, (int)l5, (int)(l2 + 8L));
    }

    public WaveAudioFileReader() {
        super(1000);
    }
}

