/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.midi.device.alsa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;
import org.tritonus.lowlevel.alsa.AlsaSeq;
import org.tritonus.lowlevel.alsa.AlsaSeqClientInfo;
import org.tritonus.lowlevel.alsa.AlsaSeqPortInfo;
import org.tritonus.midi.device.alsa.AlsaMidiDevice;
import org.tritonus.midi.device.alsa.AlsaSynthesizer;
import org.tritonus.share.TDebug;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlsaMidiDeviceProvider
extends MidiDeviceProvider {
    private static final MidiDevice.Info[] EMPTY_INFO_ARRAY = new MidiDevice.Info[0];
    private static final int READ_CAPABILITY = 33;
    private static final int WRITE_CAPABILITY = 66;
    private static List m_devices;
    private static AlsaSeq m_alsaSeq;
    static /* synthetic */ Class class$org$tritonus$midi$device$alsa$AlsaMidiDeviceProvider;

    public MidiDevice.Info[] getDeviceInfo() {
        MidiDevice.Info[] infoArray;
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDeviceInfo(): begin");
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = m_devices.iterator();
        while (iterator.hasNext()) {
            infoArray = (MidiDevice.Info[])iterator.next();
            MidiDevice.Info info = infoArray.getDeviceInfo();
            arrayList.add(info);
        }
        infoArray = (MidiDevice.Info[])arrayList.toArray(EMPTY_INFO_ARRAY);
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDeviceInfo(): end");
        }
        return infoArray;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDevice(): begin");
        }
        MidiDevice midiDevice = null;
        Iterator iterator = m_devices.iterator();
        while (iterator.hasNext()) {
            MidiDevice midiDevice2 = (MidiDevice)iterator.next();
            MidiDevice.Info info2 = midiDevice2.getDeviceInfo();
            if (info == null || !info.equals(info2)) continue;
            midiDevice = midiDevice2;
            break;
        }
        if (midiDevice == null) {
            throw new IllegalArgumentException("no device for " + info);
        }
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.getDevice(): end");
        }
        return midiDevice;
    }

    private final void scanPorts() {
        if (TDebug.TraceMidiDeviceProvider || TDebug.TracePortScan) {
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): begin");
        }
        Iterator iterator = m_alsaSeq.getClientInfos();
        while (iterator.hasNext()) {
            AlsaSeqClientInfo alsaSeqClientInfo = (AlsaSeqClientInfo)iterator.next();
            int n = alsaSeqClientInfo.getClient();
            if (TDebug.TracePortScan) {
                TDebug.out("AlsaMidiDeviceProvider.scanPorts(): client: " + n);
            }
            Iterator iterator2 = m_alsaSeq.getPortInfos(n);
            while (iterator2.hasNext()) {
                AlsaSeqPortInfo alsaSeqPortInfo = (AlsaSeqPortInfo)iterator2.next();
                this.handlePort(alsaSeqClientInfo, alsaSeqPortInfo);
            }
        }
        if (TDebug.TraceMidiDeviceProvider || TDebug.TracePortScan) {
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): end");
        }
    }

    private final void handlePort(AlsaSeqClientInfo alsaSeqClientInfo, AlsaSeqPortInfo alsaSeqPortInfo) {
        int n = alsaSeqClientInfo.getClient();
        int n2 = alsaSeqPortInfo.getPort();
        int n3 = alsaSeqPortInfo.getType();
        int n4 = alsaSeqPortInfo.getCapability();
        int n5 = alsaSeqPortInfo.getSynthVoices();
        if (TDebug.TracePortScan) {
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): port: " + n2);
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): type: " + n3);
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): cap: " + n4);
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): midi channels: " + alsaSeqPortInfo.getMidiChannels());
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): midi voices: " + alsaSeqPortInfo.getMidiVoices());
            TDebug.out("AlsaMidiDeviceProvider.scanPorts(): synth voices: " + alsaSeqPortInfo.getSynthVoices());
        }
        if ((n3 & 2) != 0) {
            AlsaMidiDevice alsaMidiDevice = null;
            if ((n3 & 0x1C00) != 0) {
                boolean bl;
                boolean bl2 = false;
                if ((n4 & 0x42) == 66) {
                    bl2 = true;
                }
                if (bl = bl2) {
                    alsaMidiDevice = new AlsaSynthesizer(n, n2, n5);
                } else if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.getDevice(): port does not allows write subscription, not used");
                }
            } else {
                boolean bl;
                boolean bl3 = false;
                if ((n4 & 0x21) == 33) {
                    bl3 = true;
                }
                boolean bl4 = bl3;
                boolean bl5 = false;
                if ((n4 & 0x42) == 66) {
                    bl5 = bl = true;
                }
                if (bl4 || bl) {
                    alsaMidiDevice = new AlsaMidiDevice(n, n2, bl4, bl);
                } else if (TDebug.TraceMidiDeviceProvider) {
                    TDebug.out("AlsaMidiDeviceProvider.getDevice(): port allows neither read nor write subscription, not used");
                }
            }
            if (alsaMidiDevice != null) {
                m_devices.add(alsaMidiDevice);
            }
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AlsaMidiDeviceProvider() {
        Class clazz;
        if (TDebug.TraceMidiDeviceProvider) {
            TDebug.out("AlsaMidiDeviceProvider.<init>(): begin");
        }
        if ((clazz = class$org$tritonus$midi$device$alsa$AlsaMidiDeviceProvider) == null) {
            clazz = class$org$tritonus$midi$device$alsa$AlsaMidiDeviceProvider = AlsaMidiDeviceProvider.class("[Lorg.tritonus.midi.device.alsa.AlsaMidiDeviceProvider;", false);
        }
        Class clazz2 = clazz;
        synchronized (clazz) {
            block8: {
                if (m_devices == null) {
                    m_devices = new ArrayList();
                    if (TDebug.TraceMidiDeviceProvider) {
                        TDebug.out("AlsaMidiDeviceProvider.<init>(): creating AlsaSeq...");
                    }
                    m_alsaSeq = new AlsaSeq("Tritonus ALSA device manager");
                    if (TDebug.TraceMidiDeviceProvider) {
                        TDebug.out("AlsaMidiDeviceProvider.<init>(): ...done");
                    }
                    this.scanPorts();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (!TDebug.TraceMidiDeviceProvider) break block8;
                TDebug.out("AlsaMidiDeviceProvider.<init>(): end");
            }
            return;
        }
    }
}

