/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class CompoundEdit
extends AbstractUndoableEdit {
    private static final long serialVersionUID = -6512679249930119683L;
    protected Vector edits = new Vector();
    private boolean inProgress = true;

    public void undo() throws CannotUndoException {
        super.undo();
        int n = this.edits.size() - 1;
        while (n >= 0) {
            ((UndoableEdit)this.edits.elementAt(n)).undo();
            --n;
        }
    }

    public void redo() throws CannotRedoException {
        super.redo();
        int n = 0;
        while (n < this.edits.size()) {
            ((UndoableEdit)this.edits.elementAt(n)).redo();
            ++n;
        }
    }

    protected UndoableEdit lastEdit() {
        if (this.edits.size() == 0) {
            return null;
        }
        return (UndoableEdit)this.edits.elementAt(this.edits.size() - 1);
    }

    public void die() {
        int n = this.edits.size() - 1;
        while (n >= 0) {
            ((UndoableEdit)this.edits.elementAt(n)).die();
            --n;
        }
        super.die();
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.inProgress) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.add(undoableEdit);
            return true;
        }
        if (undoableEdit2.addEdit(undoableEdit)) {
            return true;
        }
        if (undoableEdit.replaceEdit(undoableEdit2)) {
            this.edits.set(this.edits.size() - 1, undoableEdit);
            return true;
        }
        this.edits.add(undoableEdit);
        return true;
    }

    public void end() {
        this.inProgress = false;
    }

    public boolean canUndo() {
        boolean bl = false;
        if (!this.inProgress && super.canUndo()) {
            bl = true;
        }
        return bl;
    }

    public boolean canRedo() {
        boolean bl = false;
        if (!this.inProgress && super.canRedo()) {
            bl = true;
        }
        return bl;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isSignificant() {
        int n = this.edits.size() - 1;
        while (n >= 0) {
            if (((UndoableEdit)this.edits.elementAt(n)).isSignificant()) {
                return true;
            }
            --n;
        }
        return false;
    }

    public String getPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit == null) {
            return super.getPresentationName();
        }
        return undoableEdit.getPresentationName();
    }

    public String getUndoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit == null) {
            return super.getUndoPresentationName();
        }
        return undoableEdit.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit == null) {
            return super.getRedoPresentationName();
        }
        return undoableEdit.getRedoPresentationName();
    }

    public String toString() {
        return super.toString() + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }
}

