/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.rtf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFParseException;
import javax.swing.text.rtf.RTFScanner;
import javax.swing.text.rtf.TextToken;
import javax.swing.text.rtf.Token;

class RTFParser {
    private RTFScanner scanner;
    private Document doc;
    private int pos;

    public Document getDocument() {
        return this.doc;
    }

    public void parse() throws IOException, BadLocationException {
        this.parseFile();
    }

    private final void parseFile() throws IOException, BadLocationException {
        Token token = this.scanner.readToken();
        if (token.type != 1) {
            throw new RTFParseException("expected left curly braces");
        }
        this.parseHeader();
        this.parseDocument();
        Token token2 = this.scanner.readToken();
        if (token2.type != 2) {
            throw new RTFParseException("expected right curly braces");
        }
    }

    private final void parseHeader() {
    }

    private final void parseDocument() throws IOException, BadLocationException {
        boolean bl = false;
        do {
            Token token = this.scanner.readToken();
            switch (token.type) {
                case 4: {
                    TextToken textToken = (TextToken)token;
                    this.doc.insertString(this.pos, textToken.text, null);
                    this.pos += textToken.text.length();
                    break;
                }
                case -1: {
                    bl = true;
                    break;
                }
            }
        } while (!bl);
    }

    private RTFParser(Document document, int n) {
        this.doc = document;
        this.pos = n;
    }

    public RTFParser(InputStream inputStream, Document document, int n) {
        this(document, n);
        this.scanner = new RTFScanner(inputStream);
    }

    public RTFParser(Reader reader, Document document, int n) {
        this(document, n);
        this.scanner = new RTFScanner(reader);
    }
}

