/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StyleContext
implements Serializable,
AbstractDocument.AttributeContext {
    private static final long serialVersionUID = 8042858831190784241L;
    public static final String DEFAULT_STYLE = "default";
    static Hashtable sharedAttributeSets = new Hashtable();
    static Hashtable sharedFonts = new Hashtable();
    static StyleContext defaultStyleContext = new StyleContext();
    static final int compressionThreshold = 9;
    private static HashSet staticAttributeKeys = new HashSet();
    NamedStyle defaultStyle;
    EventListenerList listenerList;
    Hashtable styleTable;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    protected SmallAttributeSet createSmallAttributeSet(AttributeSet attributeSet) {
        return new SmallAttributeSet(attributeSet);
    }

    protected MutableAttributeSet createLargeAttributeSet(AttributeSet attributeSet) {
        return new SimpleAttributeSet(attributeSet);
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    public Style addStyle(String string, Style style) {
        NamedStyle namedStyle = new NamedStyle(string, style);
        if (string != null) {
            this.styleTable.put(string, namedStyle);
        }
        return namedStyle;
    }

    public void removeStyle(String string) {
        this.styleTable.remove(string);
    }

    public Style getStyle(String string) {
        return (Style)this.styleTable.get(string);
    }

    public Enumeration getStyleNames() {
        return this.styleTable.keys();
    }

    public Font getFont(AttributeSet attributeSet) {
        String string = StyleConstants.getFontFamily(attributeSet);
        int n = 0;
        if (StyleConstants.isBold(attributeSet)) {
            ++n;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n += 2;
        }
        int n2 = StyleConstants.getFontSize(attributeSet);
        return this.getFont(string, n, n2);
    }

    public Font getFont(String string, int n, int n2) {
        SimpleFontSpec simpleFontSpec = new SimpleFontSpec(string, n, n2);
        if (sharedFonts.containsKey(simpleFontSpec)) {
            return (Font)sharedFonts.get(simpleFontSpec);
        }
        Font font = new Font(string, n, n2);
        sharedFonts.put(simpleFontSpec, font);
        return font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Color getForeground(AttributeSet attributeSet) {
        return StyleConstants.getForeground(attributeSet);
    }

    public Color getBackground(AttributeSet attributeSet) {
        return StyleConstants.getBackground(attributeSet);
    }

    protected int getCompressionThreshold() {
        return 9;
    }

    public static StyleContext getDefaultStyleContext() {
        return defaultStyleContext;
    }

    public AttributeSet addAttribute(AttributeSet attributeSet, Object object, Object object2) {
        if (attributeSet instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attributeSet).addAttribute(object, object2);
            return attributeSet;
        }
        MutableAttributeSet mutableAttributeSet = this.createLargeAttributeSet(attributeSet);
        mutableAttributeSet.addAttribute(object, object2);
        if (mutableAttributeSet.getAttributeCount() >= this.getCompressionThreshold()) {
            return mutableAttributeSet;
        }
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(mutableAttributeSet);
        if (sharedAttributeSets.containsKey(smallAttributeSet)) {
            smallAttributeSet = (SmallAttributeSet)sharedAttributeSets.get(smallAttributeSet);
        } else {
            sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
        }
        return smallAttributeSet;
    }

    public AttributeSet addAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        if (attributeSet instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attributeSet).addAttributes(attributeSet2);
            return attributeSet;
        }
        MutableAttributeSet mutableAttributeSet = this.createLargeAttributeSet(attributeSet);
        mutableAttributeSet.addAttributes(attributeSet2);
        if (mutableAttributeSet.getAttributeCount() >= this.getCompressionThreshold()) {
            return mutableAttributeSet;
        }
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(mutableAttributeSet);
        if (sharedAttributeSets.containsKey(smallAttributeSet)) {
            smallAttributeSet = (SmallAttributeSet)sharedAttributeSets.get(smallAttributeSet);
        } else {
            sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
        }
        return smallAttributeSet;
    }

    public AttributeSet getEmptySet() {
        AttributeSet attributeSet = this.createSmallAttributeSet(null);
        if (sharedAttributeSets.containsKey(attributeSet)) {
            attributeSet = (AttributeSet)sharedAttributeSets.get(attributeSet);
        } else {
            sharedAttributeSets.put(attributeSet, attributeSet);
        }
        return attributeSet;
    }

    public void reclaim(AttributeSet attributeSet) {
        if (sharedAttributeSets.containsKey(attributeSet)) {
            sharedAttributeSets.remove(attributeSet);
        }
    }

    public AttributeSet removeAttribute(AttributeSet attributeSet, Object object) {
        if (attributeSet instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attributeSet).removeAttribute(object);
            if (attributeSet.getAttributeCount() < this.getCompressionThreshold()) {
                SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(attributeSet);
                if (!sharedAttributeSets.containsKey(smallAttributeSet)) {
                    sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
                }
                attributeSet = (AttributeSet)sharedAttributeSets.get(smallAttributeSet);
            }
            return attributeSet;
        }
        MutableAttributeSet mutableAttributeSet = this.createLargeAttributeSet(attributeSet);
        mutableAttributeSet.removeAttribute(object);
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(mutableAttributeSet);
        if (sharedAttributeSets.containsKey(smallAttributeSet)) {
            smallAttributeSet = (SmallAttributeSet)sharedAttributeSets.get(smallAttributeSet);
        } else {
            sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
        }
        return smallAttributeSet;
    }

    public AttributeSet removeAttributes(AttributeSet attributeSet, AttributeSet attributeSet2) {
        return this.removeAttributes(attributeSet, attributeSet2.getAttributeNames());
    }

    public AttributeSet removeAttributes(AttributeSet attributeSet, Enumeration enumeration) {
        if (attributeSet instanceof MutableAttributeSet) {
            ((MutableAttributeSet)attributeSet).removeAttributes(enumeration);
            if (attributeSet.getAttributeCount() < this.getCompressionThreshold()) {
                SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(attributeSet);
                if (!sharedAttributeSets.containsKey(smallAttributeSet)) {
                    sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
                }
                attributeSet = (AttributeSet)sharedAttributeSets.get(smallAttributeSet);
            }
            return attributeSet;
        }
        MutableAttributeSet mutableAttributeSet = this.createLargeAttributeSet(attributeSet);
        mutableAttributeSet.removeAttributes(enumeration);
        SmallAttributeSet smallAttributeSet = this.createSmallAttributeSet(mutableAttributeSet);
        if (sharedAttributeSets.containsKey(smallAttributeSet)) {
            smallAttributeSet = (SmallAttributeSet)sharedAttributeSets.get(smallAttributeSet);
        } else {
            sharedAttributeSets.put(smallAttributeSet, smallAttributeSet);
        }
        return smallAttributeSet;
    }

    public static Object getStaticAttribute(Object object) {
        throw new InternalError("not implemented");
    }

    public static Object getStaticAttributeKey(Object object) {
        throw new InternalError("not implemented");
    }

    public static void readAttributeSet(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        throw new InternalError("not implemented");
    }

    public static void writeAttributeSet(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        throw new InternalError("not implemented");
    }

    public void readAttributes(ObjectInputStream objectInputStream, MutableAttributeSet mutableAttributeSet) throws ClassNotFoundException, IOException {
        throw new InternalError("not implemented");
    }

    public void writeAttributes(ObjectOutputStream objectOutputStream, AttributeSet attributeSet) throws IOException {
        throw new InternalError("not implemented");
    }

    public static void registerStaticAttributeKey(Object object) {
        staticAttributeKeys.add(object);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.defaultStyle = new NamedStyle(DEFAULT_STYLE, null);
    }

    public StyleContext() {
        this.this();
        this.listenerList = new EventListenerList();
        this.styleTable = new Hashtable();
        this.styleTable.put(DEFAULT_STYLE, this.defaultStyle);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SmallAttributeSet
    implements AttributeSet {
        final Object[] attrs;

        public Object clone() {
            return new SmallAttributeSet(this.attrs);
        }

        public boolean containsAttribute(Object object, Object object2) {
            int n = 0;
            while (n < this.attrs.length) {
                if (this.attrs[n].equals(object) && this.attrs[n + 1].equals(object2)) {
                    return true;
                }
                n += 2;
            }
            return false;
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            Enumeration enumeration = attributeSet.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object object2 = enumeration.nextElement();
                if (this.containsAttribute(object2, object = attributeSet.getAttribute(object2))) continue;
                return false;
            }
            return true;
        }

        public AttributeSet copyAttributes() {
            return (AttributeSet)this.clone();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof AttributeSet && this.isEqual((AttributeSet)object)) {
                bl = true;
            }
            return bl;
        }

        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            int n = 0;
            while (n < this.attrs.length) {
                if (this.attrs[n].equals(object)) {
                    return this.attrs[n + 1];
                }
                n += 2;
            }
            if (!object.equals(ResolveAttribute) && (attributeSet = this.getResolveParent()) != null && attributeSet instanceof AttributeSet) {
                return attributeSet.getAttribute(object);
            }
            return null;
        }

        public int getAttributeCount() {
            return this.attrs.length / 2;
        }

        public Enumeration getAttributeNames() {
            return new Enumeration(){
                int i;

                public final boolean hasMoreElements() {
                    boolean bl = false;
                    if (this.i < SmallAttributeSet.this.attrs.length) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object nextElement() {
                    this.i += 2;
                    return SmallAttributeSet.this.attrs[this.i - 2];
                }

                private final /* synthetic */ void this() {
                    this.i = 0;
                }
                {
                    this.this();
                }
            };
        }

        public AttributeSet getResolveParent() {
            return (AttributeSet)this.getAttribute(ResolveAttribute);
        }

        public int hashCode() {
            return Arrays.asList(this.attrs).hashCode();
        }

        public boolean isDefined(Object object) {
            int n = 0;
            while (n < this.attrs.length) {
                if (this.attrs[n].equals(object)) {
                    return true;
                }
                n += 2;
            }
            return false;
        }

        public boolean isEqual(AttributeSet attributeSet) {
            boolean bl = false;
            if (this.getAttributeCount() == attributeSet.getAttributeCount() && this.containsAttributes(attributeSet)) {
                bl = true;
            }
            return bl;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[StyleContext.SmallattributeSet:");
            int n = 0;
            while (n < this.attrs.length - 1) {
                stringBuffer.append(" (");
                stringBuffer.append(this.attrs[n].toString());
                stringBuffer.append("=");
                stringBuffer.append(this.attrs[n + 1].toString());
                stringBuffer.append(")");
                ++n;
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        public SmallAttributeSet(AttributeSet attributeSet) {
            if (attributeSet == null) {
                this.attrs = new Object[0];
            } else {
                int n = attributeSet.getAttributeCount();
                int n2 = 0;
                this.attrs = new Object[n * 2];
                Enumeration enumeration = attributeSet.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement();
                    this.attrs[n2++] = object;
                    this.attrs[n2++] = attributeSet.getAttribute(object);
                }
            }
        }

        public SmallAttributeSet(Object[] objectArray) {
            if (objectArray == null) {
                this.attrs = new Object[0];
            } else {
                this.attrs = new Object[objectArray.length];
                System.arraycopy(objectArray, 0, this.attrs, 0, objectArray.length);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class NamedStyle
    implements Serializable,
    Style {
        private static final long serialVersionUID = -6690628971806226374L;
        protected ChangeEvent changeEvent;
        protected EventListenerList listenerList;
        AttributeSet attributes;
        String name;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
            this.fireStateChanged();
        }

        public void addChangeListener(ChangeListener changeListener) {
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            this.listenerList.add(clazz, changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            this.listenerList.remove(clazz, changeListener);
        }

        public EventListener[] getListeners(Class clazz) {
            return this.listenerList.getListeners(clazz);
        }

        public ChangeListener[] getChangeListeners() {
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = class$javax$swing$event$ChangeListener = StyleContext.class("[Ljavax.swing.event.ChangeListener;", false);
            }
            return (ChangeListener[])this.getListeners(clazz);
        }

        protected void fireStateChanged() {
            ChangeListener[] changeListenerArray = this.getChangeListeners();
            int n = 0;
            while (n < changeListenerArray.length) {
                changeListenerArray[n].stateChanged(this.changeEvent);
                ++n;
            }
        }

        public void addAttribute(Object object, Object object2) {
            this.attributes = StyleContext.this.addAttribute(this.attributes, object, object2);
            this.fireStateChanged();
        }

        public void addAttributes(AttributeSet attributeSet) {
            this.attributes = StyleContext.this.addAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public Object getAttribute(Object object) {
            return this.attributes.getAttribute(object);
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public void removeAttribute(Object object) {
            this.attributes = StyleContext.this.removeAttribute(this.attributes, object);
            this.fireStateChanged();
        }

        public void removeAttributes(AttributeSet attributeSet) {
            this.attributes = StyleContext.this.removeAttributes(this.attributes, attributeSet);
            this.fireStateChanged();
        }

        public void removeAttributes(Enumeration enumeration) {
            this.attributes = StyleContext.this.removeAttributes(this.attributes, enumeration);
            this.fireStateChanged();
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public void setResolveParent(AttributeSet attributeSet) {
            if (attributeSet != null) {
                this.attributes = StyleContext.this.addAttribute(this.attributes, ResolveAttribute, attributeSet);
            }
            this.fireStateChanged();
        }

        public String toString() {
            return "[NamedStyle: name=" + this.name + ", attrs=" + this.attributes.toString() + ']';
        }

        public NamedStyle() {
            this(null, null);
        }

        public NamedStyle(Style style) {
            this(null, style);
        }

        public NamedStyle(String string, Style style) {
            this.name = string;
            this.attributes = StyleContext.this.getEmptySet();
            this.changeEvent = new ChangeEvent(this);
            this.listenerList = new EventListenerList();
            this.setResolveParent(style);
        }
    }

    private static class SimpleFontSpec {
        String family;
        int style;
        int size;

        public boolean equals(Object object) {
            boolean bl = false;
            if (object != null && object instanceof SimpleFontSpec && ((SimpleFontSpec)object).family.equals(this.family) && ((SimpleFontSpec)object).style == this.style && ((SimpleFontSpec)object).size == this.size) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return this.family.hashCode() + this.style + this.size;
        }

        public SimpleFontSpec(String string, int n, int n2) {
            this.family = string;
            this.style = n;
            this.size = n2;
        }
    }
}

