/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu;
    private transient PopupMenuListener popupMenuListener = new PopupMenuHandler();
    TopWindowListener topWindowListener = new TopWindowListener();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.popupMenu = (JPopupMenu)jComponent;
        this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        this.popupMenu.setBorderPainted(true);
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
        this.installDefaults();
        this.installListeners();
    }

    public void installDefaults() {
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    protected void installListeners() {
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
    }

    protected void installKeyboardActions() {
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        this.popupMenu.setBackground(null);
        this.popupMenu.setBorder(null);
        this.popupMenu.setFont(null);
        this.popupMenu.setForeground(null);
    }

    protected void uninstallListeners() {
        this.popupMenu.removePopupMenuListener(this.popupMenuListener);
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class PopupMenuHandler
    implements PopupMenuListener {
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            Component component = BasicPopupMenuUI.this.popupMenu.getInvoker();
            Component component2 = SwingUtilities.getRoot(component);
            if (component2 != null) {
                component2.removeComponentListener(BasicPopupMenuUI.this.topWindowListener);
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Component component = BasicPopupMenuUI.this.popupMenu.getInvoker();
            Component component2 = SwingUtilities.getRoot(component);
            component2.addComponentListener(BasicPopupMenuUI.this.topWindowListener);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            if (menuSelectionManager.getSelectedPath().length == 0) {
                MenuElement[] menuElementArray = new MenuElement[2];
                menuElementArray[0] = BasicPopupMenuUI.this.popupMenu;
                Component[] componentArray = BasicPopupMenuUI.this.popupMenu.getComponents();
                if (componentArray.length != 0 && componentArray[0] instanceof MenuElement) {
                    menuElementArray[1] = (MenuElement)((Object)componentArray[0]);
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }

        private PopupMenuHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TopWindowListener
    implements ComponentListener {
        public void componentResized(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentShown(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        private TopWindowListener() {
        }
    }
}

