/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NullCipher;
import javax.crypto.ShortBufferException;

public class CipherOutputStream
extends FilterOutputStream {
    private static final int FIRST_TIME = 0;
    private static final int SECOND_TIME = 1;
    private static final int SEASONED = 2;
    private Cipher cipher;
    private byte[][] inBuffer;
    private int inLength;
    private byte[] outBuffer;
    private int state;
    private boolean isStream;

    public void close() throws IOException {
        try {
            int n;
            if (this.state != 0) {
                n = this.cipher.update(this.inBuffer[0], 0, this.inBuffer[0].length, this.outBuffer);
                this.out.write(this.outBuffer, 0, n);
            }
            n = this.cipher.doFinal(this.inBuffer[0], 0, this.inLength, this.outBuffer);
            this.out.write(this.outBuffer, 0, n);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new IOException(illegalBlockSizeException.toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new IOException(badPaddingException.toString());
        }
        catch (ShortBufferException shortBufferException) {
            throw new IOException(shortBufferException.toString());
        }
        this.out.flush();
        this.out.close();
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int n) throws IOException {
        if (this.isStream) {
            byte[] byArray = new byte[]{(byte)n};
            try {
                this.cipher.update(byArray, 0, 1, byArray, 0);
            }
            catch (ShortBufferException shortBufferException) {
                throw new IOException(shortBufferException.toString());
            }
            this.out.write(byArray);
            return;
        }
        this.inBuffer[1][this.inLength++] = (byte)n;
        if (this.inLength == this.inBuffer[1].length) {
            this.process();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isStream) {
            this.out.write(this.cipher.update(byArray, n, n2));
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = Math.min(this.inBuffer[1].length - this.inLength, n2 - n3);
            System.arraycopy(byArray, n + n3, this.inBuffer[1], this.inLength, n4);
            n3 += n4;
            this.inLength += n4;
            if (this.inLength != this.inBuffer[1].length) continue;
            this.process();
        }
    }

    private final void process() throws IOException {
        if (this.state == 1) {
            this.state = 2;
        } else {
            byte[] byArray = this.inBuffer[0];
            this.inBuffer[0] = this.inBuffer[1];
            this.inBuffer[1] = byArray;
        }
        if (this.state == 0) {
            this.inLength = 0;
            this.state = 1;
            return;
        }
        try {
            this.cipher.update(this.inBuffer[0], 0, this.inBuffer[0].length, this.outBuffer);
        }
        catch (ShortBufferException shortBufferException) {
            throw new IOException(shortBufferException.toString());
        }
        this.out.write(this.outBuffer);
        this.inLength = 0;
    }

    public CipherOutputStream(OutputStream outputStream, Cipher cipher) {
        super(outputStream);
        if (cipher != null) {
            this.cipher = cipher;
            boolean bl = false;
            if (cipher.getBlockSize() == 1) {
                bl = this.isStream = true;
            }
            if (!bl) {
                this.inBuffer = new byte[2][];
                this.inBuffer[0] = new byte[cipher.getBlockSize()];
                this.inBuffer[1] = new byte[cipher.getBlockSize()];
                this.inLength = 0;
                this.state = 0;
            }
        } else {
            this.cipher = new NullCipher();
        }
    }

    protected CipherOutputStream(OutputStream outputStream) {
        super(outputStream);
    }
}

