/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        super.finish();
        int n = this.def.getTotalIn();
        int n2 = (int)(this.crc.getValue() & (long)-1);
        byte[] byArray = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24), (byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        this.out.write(byArray);
    }

    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 4096);
    }

    public GZIPOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream, new Deflater(-1, true), n);
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        byte[] byArray = new byte[10];
        byArray[0] = 31;
        byArray[1] = -117;
        byArray[2] = 8;
        byArray[4] = (byte)n2;
        byArray[5] = (byte)(n2 >> 8);
        byArray[6] = (byte)(n2 >> 16);
        byArray[7] = (byte)(n2 >> 24);
        byArray[9] = -1;
        byte[] byArray2 = byArray;
        outputStream.write(byArray2);
    }
}

