/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;
    private int threshold;
    private final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set keys;
    private transient Collection values;
    private transient Set entries;

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public Enumeration keys() {
        return new KeyEnumerator();
    }

    public Enumeration elements() {
        return new ValueEnumerator();
    }

    public synchronized boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n = this.buckets.length - 1;
        while (n >= 0) {
            HashEntry hashEntry = this.buckets[n];
            while (hashEntry != null) {
                if (hashEntry.value.equals(object)) {
                    return true;
                }
                hashEntry = hashEntry.next;
            }
            --n;
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                return hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Object put(Object var1_1, Object var2_2) {
        var3_3 = this.hash(var1_1);
        var4_4 = this.buckets[var3_3];
        if (var2_2 != null) ** GOTO lbl10
        throw new NullPointerException();
lbl-1000:
        // 1 sources

        {
            if (var4_4.key.equals(var1_1)) {
                var5_5 = var4_4.value;
                var4_4.value = var2_2;
                return var5_5;
            }
            var4_4 = var4_4.next;
lbl10:
            // 2 sources

            ** while (var4_4 != null)
        }
lbl11:
        // 1 sources

        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            var3_3 = this.hash(var1_1);
        }
        var4_4 = new HashEntry(var1_1, var2_2);
        var4_4.next = this.buckets[var3_3];
        this.buckets[var3_3] = var4_4;
        return null;
    }

    public synchronized Object remove(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (hashEntry.key.equals(object)) {
                ++this.modCount;
                if (hashEntry2 == null) {
                    this.buckets[n] = hashEntry.next;
                } else {
                    hashEntry2.next = hashEntry.next;
                }
                --this.size;
                return hashEntry.value;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public synchronized void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (entry instanceof AbstractMap.BasicMapEntry) {
                AbstractMap.BasicMapEntry basicMapEntry = (AbstractMap.BasicMapEntry)entry;
                this.put(basicMapEntry.key, basicMapEntry.value);
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public synchronized Object clone() {
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        hashtable.buckets = new HashEntry[this.buckets.length];
        hashtable.putAllInternal(this);
        hashtable.keys = null;
        hashtable.values = null;
        hashtable.entries = null;
        return hashtable;
    }

    public synchronized String toString() {
        EntryIterator entryIterator = new EntryIterator();
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = this.size;
        while (n > 0) {
            stringBuffer.append(entryIterator.next());
            if (n > 1) {
                stringBuffer.append(", ");
            }
            --n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Set keySet() {
        if (this.keys == null) {
            AbstractSet abstractSet = new AbstractSet(){

                public final int size() {
                    return Hashtable.this.size;
                }

                public final Iterator iterator() {
                    return new KeyIterator();
                }

                public final void clear() {
                    Hashtable.this.clear();
                }

                public final boolean contains(Object object) {
                    if (object == null) {
                        return false;
                    }
                    return Hashtable.this.containsKey(object);
                }

                public final boolean remove(Object object) {
                    boolean bl = false;
                    if (Hashtable.this.remove(object) != null) {
                        bl = true;
                    }
                    return bl;
                }
            };
            this.keys = new Collections.SynchronizedSet((Object)this, abstractSet);
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            AbstractCollection abstractCollection = new AbstractCollection(){

                public final int size() {
                    return Hashtable.this.size;
                }

                public final Iterator iterator() {
                    return new ValueIterator();
                }

                public final void clear() {
                    Hashtable.this.clear();
                }
            };
            this.values = new Collections.SynchronizedCollection(this, abstractCollection);
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entries == null) {
            AbstractSet abstractSet = new AbstractSet(){

                public final int size() {
                    return Hashtable.this.size;
                }

                public final Iterator iterator() {
                    return new EntryIterator();
                }

                public final void clear() {
                    Hashtable.this.clear();
                }

                public final boolean contains(Object object) {
                    boolean bl = false;
                    if (Hashtable.this.getEntry(object) != null) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean remove(Object object) {
                    HashEntry hashEntry = Hashtable.this.getEntry(object);
                    if (hashEntry != null) {
                        Hashtable.this.remove(hashEntry.key);
                        return true;
                    }
                    return false;
                }
            };
            this.entries = new Collections.SynchronizedSet((Object)this, abstractSet);
        }
        return this.entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)object).entrySet());
    }

    public synchronized int hashCode() {
        EntryIterator entryIterator = new EntryIterator();
        int n = 0;
        int n2 = this.size;
        while (n2 > 0) {
            n += entryIterator.next().hashCode();
            --n2;
        }
        return n;
    }

    private final int hash(Object object) {
        int n = object.hashCode() % this.buckets.length;
        return n < 0 ? -n : n;
    }

    HashEntry getEntry(Object object) {
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Object object2 = ((Map.Entry)object).getKey();
        if (object2 == null) {
            return null;
        }
        int n = this.hash(object2);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (hashEntry.equals(object)) {
                return hashEntry;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    void putAllInternal(Map map) {
        Iterator iterator = map.entrySet().iterator();
        this.size = 0;
        while (iterator.hasNext()) {
            ++this.size;
            Map.Entry entry = (Map.Entry)iterator.next();
            Object object = entry.getKey();
            int n = this.hash(object);
            HashEntry hashEntry = new HashEntry(object, entry.getValue());
            hashEntry.next = this.buckets[n];
            this.buckets[n] = hashEntry;
        }
    }

    protected void rehash() {
        HashEntry[] hashEntryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new HashEntry[n];
        int n2 = hashEntryArray.length - 1;
        while (n2 >= 0) {
            HashEntry hashEntry = hashEntryArray[n2];
            while (hashEntry != null) {
                HashEntry hashEntry2;
                int n3 = this.hash(hashEntry.key);
                HashEntry hashEntry3 = this.buckets[n3];
                if (hashEntry3 != null) {
                    hashEntry2 = hashEntry3.next;
                    while (hashEntry2 != null) {
                        hashEntry3 = hashEntry2;
                        hashEntry2 = hashEntry3.next;
                    }
                    hashEntry3.next = hashEntry;
                } else {
                    this.buckets[n3] = hashEntry;
                }
                hashEntry2 = hashEntry.next;
                hashEntry.next = null;
                hashEntry = hashEntry2;
            }
            --n2;
        }
    }

    private final synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.buckets.length);
        objectOutputStream.writeInt(this.size);
        EntryIterator entryIterator = new EntryIterator();
        while (entryIterator.hasNext()) {
            HashEntry hashEntry = (HashEntry)entryIterator.next();
            objectOutputStream.writeObject(hashEntry.key);
            objectOutputStream.writeObject(hashEntry.value);
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.buckets = new HashEntry[objectInputStream.readInt()];
        int n = objectInputStream.readInt();
        while (--n >= 0) {
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
        }
    }

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map map) {
        this(Math.max(map.size() * 2, 11), 0.75f);
        this.putAll(map);
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new HashEntry[n];
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class KeyEnumerator
    extends EntryEnumerator {
        public final Object nextElement() {
            HashEntry hashEntry = (HashEntry)super.nextElement();
            Object object = null;
            if (hashEntry != null) {
                object = hashEntry.key;
            }
            return object;
        }

        private KeyEnumerator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class ValueEnumerator
    extends EntryEnumerator {
        public final Object nextElement() {
            HashEntry hashEntry = (HashEntry)super.nextElement();
            Object object = null;
            if (hashEntry != null) {
                object = hashEntry.value;
            }
            return object;
        }

        private ValueEnumerator() {
        }
    }

    private static final class HashEntry
    extends AbstractMap.BasicMapEntry {
        HashEntry next;

        public final Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            return super.setValue(object);
        }

        HashEntry(Object object, Object object2) {
            super(object, object2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EntryIterator
    implements Iterator {
        int knownMod;
        int count;
        int idx;
        HashEntry last;
        HashEntry next;

        public boolean hasNext() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            boolean bl = false;
            if (this.count > 0) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                if (this.idx <= 0) {
                    return null;
                }
                hashEntry = Hashtable.this.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            this.last = hashEntry;
            return hashEntry;
        }

        public void remove() {
            if (this.knownMod != Hashtable.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            Hashtable.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }

        private final /* synthetic */ void this() {
            this.knownMod = Hashtable.this.modCount;
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        EntryIterator() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class EntryEnumerator
    implements Enumeration {
        int count;
        int idx;
        HashEntry next;

        public boolean hasMoreElements() {
            boolean bl = false;
            if (this.count > 0) {
                bl = true;
            }
            return bl;
        }

        public Object nextElement() {
            if (this.count == 0) {
                throw new NoSuchElementException("Hashtable Enumerator");
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                if (this.idx <= 0) {
                    return null;
                }
                hashEntry = Hashtable.this.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            return hashEntry;
        }

        private final /* synthetic */ void this() {
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
        }

        EntryEnumerator() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ValueIterator
    extends EntryIterator {
        public Object next() {
            return ((HashEntry)super.next()).value;
        }

        private ValueIterator() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class KeyIterator
    extends EntryIterator {
        public Object next() {
            return ((HashEntry)super.next()).key;
        }

        private KeyIterator() {
        }
    }
}

