/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public class ArrayList
extends AbstractList
implements List,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8683452581122892189L;
    private static final int DEFAULT_CAPACITY = 10;
    private int size;
    private transient Object[] data;

    public void trimToSize() {
        if (this.size != this.data.length) {
            Object[] objectArray = new Object[this.size];
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
            this.data = objectArray;
        }
    }

    public void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            Object[] objectArray = new Object[Math.max(n2 * 2, n)];
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
            this.data = objectArray;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(Object object) {
        boolean bl = false;
        if (this.indexOf(object) != -1) {
            bl = true;
        }
        return bl;
    }

    public int indexOf(Object object) {
        int n = 0;
        while (n < this.size) {
            if (ArrayList.equals(object, this.data[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size - 1;
        while (n >= 0) {
            if (ArrayList.equals(object, this.data[n])) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public Object clone() {
        ArrayList arrayList = null;
        try {
            arrayList = (ArrayList)super.clone();
            arrayList.data = (Object[])this.data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return arrayList;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        } else if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        System.arraycopy(this.data, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object get(int n) {
        this.checkBoundExclusive(n);
        return this.data[n];
    }

    public Object set(int n, Object object) {
        this.checkBoundExclusive(n);
        Object object2 = this.data[n];
        this.data[n] = object;
        return object2;
    }

    public boolean add(Object object) {
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = object;
        return true;
    }

    public void add(int n, Object object) {
        this.checkBoundInclusive(n);
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        if (n != this.size) {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.data[n] = object;
        ++this.size;
    }

    public Object remove(int n) {
        this.checkBoundExclusive(n);
        Object object = this.data[n];
        ++this.modCount;
        if (n != --this.size) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        this.data[this.size] = null;
        return object;
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.data, 0, this.size, null);
            this.size = 0;
        }
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n, Collection collection) {
        this.checkBoundInclusive(n);
        Iterator iterator = collection.iterator();
        int n2 = collection.size();
        ++this.modCount;
        if (n2 + this.size > this.data.length) {
            this.ensureCapacity(this.size + n2);
        }
        int n3 = n + n2;
        if (this.size > 0 && n != this.size) {
            System.arraycopy(this.data, n, this.data, n3, this.size - n);
        }
        this.size += n2;
        while (n < n3) {
            this.data[n] = iterator.next();
            ++n;
        }
        boolean bl = false;
        if (n2 > 0) {
            bl = true;
        }
        return bl;
    }

    protected void removeRange(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 0) {
            ++this.modCount;
            System.arraycopy(this.data, n2, this.data, n, this.size - n2);
            this.size -= n3;
        } else if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    private final void checkBoundInclusive(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private final void checkBoundExclusive(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    boolean removeAllInternal(Collection collection) {
        int n = 0;
        while (n < this.size) {
            if (collection.contains(this.data[n])) break;
            ++n;
        }
        if (n == this.size) {
            return false;
        }
        ++this.modCount;
        int n2 = n++;
        while (n < this.size) {
            if (!collection.contains(this.data[n])) {
                this.data[n2++] = this.data[n];
            }
            ++n;
        }
        this.size -= n - n2;
        return true;
    }

    boolean retainAllInternal(Collection collection) {
        int n = 0;
        while (n < this.size) {
            if (!collection.contains(this.data[n])) break;
            ++n;
        }
        if (n == this.size) {
            return false;
        }
        ++this.modCount;
        int n2 = n++;
        while (n < this.size) {
            if (collection.contains(this.data[n])) {
                this.data[n2++] = this.data[n];
            }
            ++n;
        }
        this.size -= n - n2;
        return true;
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.data.length;
        objectOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < this.size) {
            objectOutputStream.writeObject(this.data[n2]);
            ++n2;
        }
    }

    private final void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.data = new Object[n];
        int n2 = 0;
        while (n2 < this.size) {
            this.data[n2] = objectInputStream.readObject();
            ++n2;
        }
    }

    public ArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new Object[n];
    }

    public ArrayList() {
        this(10);
    }

    public ArrayList(Collection collection) {
        this((int)((float)collection.size() * 1.1f));
        this.addAll(collection);
    }
}

