/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.ShortBufferImpl;

public abstract class ShortBuffer
extends Buffer
implements Comparable {
    int array_offset = 0;
    short[] backing_buffer;

    public static ShortBuffer allocate(int n) {
        return new ShortBufferImpl(n);
    }

    public static final ShortBuffer wrap(short[] sArray, int n, int n2) {
        return new ShortBufferImpl(sArray, 0, sArray.length, n + n2, n, -1, false);
    }

    public static final ShortBuffer wrap(short[] sArray) {
        return ShortBuffer.wrap(sArray, 0, sArray.length);
    }

    public ShortBuffer get(short[] sArray, int n, int n2) {
        ShortBuffer.checkArraySize(sArray.length, n, n2);
        this.checkForUnderflow(n2);
        int n3 = n;
        while (n3 < n + n2) {
            sArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public ShortBuffer get(short[] sArray) {
        return this.get(sArray, 0, sArray.length);
    }

    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(shortBuffer.remaining());
        if (shortBuffer.remaining() > 0) {
            short[] sArray = new short[shortBuffer.remaining()];
            shortBuffer.get(sArray);
            this.put(sArray);
        }
        return this;
    }

    public ShortBuffer put(short[] sArray, int n, int n2) {
        ShortBuffer.checkArraySize(sArray.length, n, n2);
        this.checkForOverflow(n2);
        int n3 = n;
        while (n3 < n + n2) {
            this.put(sArray[n3]);
            ++n3;
        }
        return this;
    }

    public final ShortBuffer put(short[] sArray) {
        return this.put(sArray, 0, sArray.length);
    }

    public final boolean hasArray() {
        boolean bl = false;
        if (this.backing_buffer != null && !this.isReadOnly()) {
            bl = true;
        }
        return bl;
    }

    public final short[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int n = this.get(this.position()) + 31;
        int n2 = 1;
        int n3 = this.position() + 1;
        while (n3 < this.limit()) {
            n += (this.get(n3) + 30) * (n2 *= 31);
            ++n3;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof ShortBuffer) {
            boolean bl = false;
            if (this.compareTo(object) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object object) {
        ShortBuffer shortBuffer = (ShortBuffer)object;
        int n = Math.min(this.remaining(), shortBuffer.remaining());
        int n2 = this.position();
        int n3 = shortBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            short s;
            short s2;
            if ((s2 = this.get(n2++)) != (s = shortBuffer.get(n3++))) {
                if (s2 < s) {
                    return -1;
                }
                return 1;
            }
            ++n4;
        }
        return this.remaining() - shortBuffer.remaining();
    }

    public abstract ByteOrder order();

    public abstract short get();

    public abstract ShortBuffer put(short var1);

    public abstract short get(int var1);

    public abstract ShortBuffer put(int var1, short var2);

    public abstract ShortBuffer compact();

    public abstract boolean isDirect();

    public abstract ShortBuffer slice();

    public abstract ShortBuffer duplicate();

    public abstract ShortBuffer asReadOnlyBuffer();

    ShortBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }
}

