/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.classpath.SystemProperties;
import java.io.DeleteFileHelper;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.VMFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class File
implements Serializable,
Comparable {
    private static final long serialVersionUID = 301077366599181567L;
    public static final String separator = SystemProperties.getProperty("file.separator");
    private static final String dupSeparator = separator + separator;
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = SystemProperties.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    private static long last_tmp;
    private static int n_created;
    private String path;

    public boolean canRead() {
        if (!this.exists()) {
            return false;
        }
        return VMFile.canRead(this.path);
    }

    public boolean canWrite() {
        this.checkWrite();
        if (!VMFile.exists(this.path)) {
            return false;
        }
        if (VMFile.isDirectory(this.path)) {
            return VMFile.canWriteDirectory(this);
        }
        return VMFile.canWrite(this.path);
    }

    public boolean createNewFile() throws IOException {
        this.checkWrite();
        return VMFile.create(this.path);
    }

    public synchronized boolean delete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        return VMFile.delete(this.path);
    }

    public boolean equals(Object object) {
        if (!(object instanceof File)) {
            return false;
        }
        File file = (File)object;
        return this.path.equals(file.path);
    }

    public boolean exists() {
        this.checkRead();
        return VMFile.exists(this.path);
    }

    private final String normalizePath(String string) {
        if (separatorChar == '\\' && (string = string.replace('/', '\\')).length() > 2 && string.charAt(0) == '\\' && (string.charAt(1) >= 'a' && string.charAt(1) <= 'z' || string.charAt(1) >= 'A' && string.charAt(1) <= 'Z') && string.charAt(2) == ':') {
            string = string.substring(1);
        }
        int n = string.indexOf(dupSeparator);
        int n2 = string.length();
        if (dupSeparator.equals("\\\\") && n == 0) {
            n = string.indexOf(dupSeparator, 1);
        }
        if (n == -1) {
            if (n2 > 1 && string.charAt(n2 - 1) == separatorChar) {
                if (separatorChar != '\\' || n2 != 3 || string.charAt(1) != ':') {
                    return string.substring(0, n2 - 1);
                }
            } else {
                return string;
            }
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n3, n));
            while (string.charAt(n) == separatorChar) {
                if (++n != n2) continue;
                return stringBuffer.toString();
            }
            stringBuffer.append(separatorChar);
            n3 = n;
            n = string.indexOf(dupSeparator, n3);
        }
        int n4 = n2 > 1 && string.charAt(n2 - 1) == separatorChar ? (separatorChar == '\\' && n2 == 3 && string.charAt(1) == ':' ? n2 : n2 - 1) : n2;
        stringBuffer.append(string.substring(n3, n4));
        return stringBuffer.toString();
    }

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.path;
        }
        if (separatorChar == '\\' && this.path.length() > 0 && this.path.charAt(0) == '\\') {
            return System.getProperty("user.dir").substring(0, 2) + this.path;
        }
        if (separatorChar == '\\' && this.path.length() > 1 && this.path.charAt(1) == ':' && (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z')) {
            String string = null;
            try {
                string = new File(this.path.substring(0, 2)).getCanonicalPath();
            }
            catch (IOException iOException) {
                string = this.path.substring(0, 2) + '\\';
            }
            if (this.path.length() > 2) {
                return string + '\\' + this.path.substring(2, this.path.length());
            }
            return string;
        }
        if (this.path.equals("")) {
            return System.getProperty("user.dir");
        }
        return System.getProperty("user.dir") + separatorChar + this.path;
    }

    public File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public String getCanonicalPath() throws IOException {
        if (separatorChar == '\\' && this.path.length() == 2 && (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z') && this.path.charAt(1) == ':') {
            return VMFile.toCanonicalForm(this.path);
        }
        return VMFile.toCanonicalForm(this.getAbsolutePath());
    }

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    public String getName() {
        return VMFile.getName(this.path);
    }

    public String getParent() {
        String string = null;
        int n = 0;
        if (this.path.equals("")) {
            return null;
        }
        if (separatorChar == '/' && this.path.charAt(0) == '/') {
            string = "/";
            n = 1;
        } else if (separatorChar == '\\' && this.path.length() > 1 && (this.path.charAt(0) == '\\' && this.path.charAt(1) == '\\' || (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z') && this.path.charAt(1) == ':')) {
            string = this.path.substring(0, 2);
            n = 2;
        }
        if (n < this.path.length()) {
            String string2 = this.path.substring(n, this.path.length());
            int n2 = string2.lastIndexOf(separatorChar);
            if (n2 == -1) {
                return string;
            }
            if (n2 == string2.length() - 1) {
                return null;
            }
            if (n2 == 0) {
                ++n2;
            }
            if (string != null) {
                return string + string2.substring(0, n2);
            }
            return string2.substring(0, n2);
        }
        return null;
    }

    public File getParentFile() {
        String string = this.getParent();
        return string != null ? new File(string) : null;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode() ^ 0x12D591;
    }

    public boolean isAbsolute() {
        if (separatorChar == '\\') {
            boolean bl = false;
            if (this.path.startsWith(dupSeparator) || this.path.length() > 2 && (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z') && this.path.charAt(1) == ':' && this.path.charAt(2) == '\\') {
                bl = true;
            }
            return bl;
        }
        return this.path.startsWith(separator);
    }

    public boolean isDirectory() {
        this.checkRead();
        return VMFile.isDirectory(this.path);
    }

    public boolean isFile() {
        this.checkRead();
        return VMFile.isFile(this.path);
    }

    public boolean isHidden() {
        return VMFile.isHidden(this.path);
    }

    public long lastModified() {
        this.checkRead();
        return VMFile.lastModified(this.path);
    }

    public long length() {
        this.checkRead();
        return VMFile.length(this.path);
    }

    public String[] list(FilenameFilter filenameFilter) {
        this.checkRead();
        if (!this.exists() || !this.isDirectory()) {
            return null;
        }
        String[] stringArray = VMFile.list(this.path);
        if (stringArray == null) {
            return null;
        }
        if (filenameFilter == null) {
            return stringArray;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (filenameFilter.accept(this, stringArray[n2])) {
                ++n;
            } else {
                stringArray[n2] = null;
            }
            ++n2;
        }
        String[] stringArray2 = new String[n];
        n = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3] != null) {
                stringArray2[n++] = stringArray[n3];
            }
            ++n3;
        }
        return stringArray2;
    }

    public String[] list() {
        return this.list(null);
    }

    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        String[] stringArray = this.list(filenameFilter);
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(this, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    public File[] listFiles(FileFilter fileFilter) {
        File[] fileArray = this.listFiles((FilenameFilter)null);
        if (fileArray == null) {
            return null;
        }
        if (fileFilter == null) {
            return fileArray;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileFilter.accept(fileArray[n2])) {
                ++n;
            }
            ++n2;
        }
        File[] fileArray2 = new File[n];
        n = 0;
        int n3 = 0;
        while (n3 < fileArray.length) {
            if (fileFilter.accept(fileArray[n3])) {
                fileArray2[n] = fileArray[n3];
                ++n;
            }
            ++n3;
        }
        return fileArray2;
    }

    public String toString() {
        return this.path;
    }

    public URI toURI() {
        String string = this.getAbsolutePath();
        if (this.isDirectory() || this.path.equals("")) {
            string = string + separatorChar;
        }
        if (separatorChar == '\\') {
            string = separatorChar + string;
        }
        try {
            return new URI("file", null, null, -1, string.replace(separatorChar, '/'), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (InternalError)new InternalError("Unconvertible file: " + this).initCause(uRISyntaxException);
        }
    }

    public URL toURL() throws MalformedURLException {
        if (separatorChar == '\\') {
            return new URL("file:/" + this.getAbsolutePath().replace('\\', '/') + (this.isDirectory() ? "/" : ""));
        }
        return new URL("file:" + this.getAbsolutePath() + (this.isDirectory() ? "/" : ""));
    }

    public boolean mkdir() {
        this.checkWrite();
        return VMFile.mkdir(this.path);
    }

    public boolean mkdirs() {
        boolean bl;
        String string = this.getParent();
        if (string == null) {
            return this.mkdir();
        }
        File file = new File(string);
        if (!file.exists() && !(bl = file.mkdirs())) {
            return false;
        }
        return this.mkdir();
    }

    public static synchronized File createTempFile(String string, String string2, File file) throws IOException {
        Object object;
        if (file == null) {
            object = System.getProperty("java.io.tmpdir");
            if (object == null) {
                throw new IOException("Cannot determine system temporary directory");
            }
            file = new File((String)object);
            if (!VMFile.exists(file.path)) {
                throw new IOException("System temporary directory " + file.getName() + " does not exist.");
            }
            if (!VMFile.isDirectory(file.path)) {
                throw new IOException("System temporary directory " + file.getName() + " is not really a directory.");
            }
        }
        if (string.length() < 3) {
            throw new IllegalArgumentException("Prefix too short: " + string);
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        do {
            long l;
            if ((l = System.currentTimeMillis()) > last_tmp) {
                last_tmp = l;
                n_created = 0;
            } else {
                ++n_created;
            }
            String string3 = Long.toHexString(l);
            if (n_created > 0) {
                string3 = string3 + '_' + Integer.toHexString(n_created);
            }
            String string4 = string + string3 + string2;
            object = new File(file, string4);
        } while (VMFile.exists(((File)object).path));
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(((File)object).getAbsolutePath());
        }
        VMFile.create(((File)object).getAbsolutePath());
        return object;
    }

    public boolean setReadOnly() {
        this.checkWrite();
        if (!VMFile.exists(this.path)) {
            return false;
        }
        return VMFile.setReadOnly(this.path);
    }

    public static File[] listRoots() {
        return VMFile.listRoots();
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return File.createTempFile(string, string2, null);
    }

    public int compareTo(File file) {
        return this.path.compareTo(file.path);
    }

    public int compareTo(Object object) {
        return this.compareTo((File)object);
    }

    public synchronized boolean renameTo(File file) {
        this.checkWrite();
        file.checkWrite();
        return VMFile.renameTo(this.path, file.path);
    }

    public boolean setLastModified(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative modification time: " + l);
        }
        this.checkWrite();
        return VMFile.setLastModified(this.path, l);
    }

    private final void checkWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.path);
        }
    }

    private final void checkRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.path);
        }
    }

    public void deleteOnExit() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.path);
        }
        DeleteFileHelper.add(this);
    }

    private final void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeChar(separatorChar);
    }

    private final void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        char c = objectInputStream.readChar();
        if (c != separatorChar) {
            this.path = this.path.replace(c, separatorChar);
        }
    }

    public File(String string) {
        this.path = this.normalizePath(string);
    }

    public File(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        if (string != null) {
            if (string.length() > 0) {
                this.path = string.charAt(string.length() - 1) == separatorChar || string2.length() == 0 ? this.normalizePath(string + string2) : this.normalizePath(string + separatorChar + string2);
            } else {
                if (separatorChar == '\\') {
                    int n = 0;
                    while (string2.length() > n && (string2.charAt(n) == separatorChar || string2.charAt(n) == '/')) {
                        ++n;
                    }
                    string2 = string2.substring(n);
                }
                this.path = this.normalizePath(separatorChar + string2);
            }
        } else {
            this.path = this.normalizePath(string2);
        }
    }

    public File(File file, String string) {
        this(file == null ? null : file.path, string);
    }

    public File(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("uri is null");
        }
        if (!uRI.getScheme().equals("file")) {
            throw new IllegalArgumentException("invalid uri protocol");
        }
        String string = uRI.getPath();
        if (string == null) {
            throw new IllegalArgumentException("URI \"" + uRI + "\" is not hierarchical");
        }
        this.path = this.normalizePath(string);
    }
}

