/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.xmlschema;

import gnu.xml.validation.datatype.SimpleType;
import gnu.xml.validation.datatype.Type;
import gnu.xml.validation.xmlschema.AttributeDeclaration;
import gnu.xml.validation.xmlschema.ElementDeclaration;
import gnu.xml.validation.xmlschema.ValidationException;
import gnu.xml.validation.xmlschema.XMLSchema;
import gnu.xml.validation.xmlschema.XMLSchemaAttributeTypeInfo;
import gnu.xml.validation.xmlschema.XMLSchemaElementTypeInfo;
import gnu.xml.validation.xmlschema.XMLSchemaTypeInfoProvider;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import javax.xml.validation.TypeInfoProvider;
import javax.xml.validation.ValidatorHandler;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.helpers.NamespaceSupport;

final class XMLSchemaValidatorHandler
extends ValidatorHandler {
    final XMLSchema schema;
    final TypeInfoProvider typeInfoProvider;
    final NamespaceSupport namespaceSupport;
    final DatatypeLibrary typeLibrary;
    Locator loc;
    ContentHandler contentHandler;
    ErrorHandler errorHandler;
    LSResourceResolver resourceResolver;
    final LinkedList context;
    final ArrayList attributes;

    public final ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public final void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public final LSResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public final void setResourceResolver(LSResourceResolver lSResourceResolver) {
        this.resourceResolver = lSResourceResolver;
    }

    public final TypeInfoProvider getTypeInfoProvider() {
        return this.typeInfoProvider;
    }

    final TypeInfo getElementTypeInfo() {
        return (XMLSchemaElementTypeInfo)this.context.getFirst();
    }

    final TypeInfo getAttributeTypeInfo(int n) {
        return (XMLSchemaAttributeTypeInfo)this.attributes.get(n);
    }

    final boolean isIdAttribute(int n) {
        XMLSchemaAttributeTypeInfo xMLSchemaAttributeTypeInfo = (XMLSchemaAttributeTypeInfo)this.attributes.get(n);
        return xMLSchemaAttributeTypeInfo.id;
    }

    final boolean isSpecified(int n) {
        XMLSchemaAttributeTypeInfo xMLSchemaAttributeTypeInfo = (XMLSchemaAttributeTypeInfo)this.attributes.get(n);
        return xMLSchemaAttributeTypeInfo.specified;
    }

    public final void setDocumentLocator(Locator locator) {
        this.loc = locator;
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public final void startDocument() throws SAXException {
        this.namespaceSupport.reset();
        this.context.clear();
        this.attributes.clear();
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public final void endDocument() throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public final void startPrefixMapping(String string, String string2) throws SAXException {
        this.namespaceSupport.declarePrefix(string, string2);
        if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(string, string2);
        }
    }

    public final void endPrefixMapping(String string) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(string);
        }
    }

    public final void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        this.namespaceSupport.pushContext();
        QName qName = new QName(string, string2);
        ElementDeclaration elementDeclaration = (ElementDeclaration)this.schema.elementDeclarations.get(qName);
        String string4 = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        string4 = string4.trim();
        String string5 = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        Type type = elementDeclaration.datatype;
        if (string4.length() > 0) {
            try {
                object = this.resolveType(string4);
                type = object;
            }
            catch (DatatypeException datatypeException) {
                ValidationException validationException = new ValidationException("Can't resolve type " + string4, this.loc);
                validationException.initCause(datatypeException);
                throw validationException;
            }
        }
        object = new XMLSchemaElementTypeInfo(this.schema, elementDeclaration, type);
        if (elementDeclaration == null) {
            throw new ValidationException("No declaration for " + qName, this.loc);
        }
        if (elementDeclaration.isAbstract) {
            throw new ValidationException("Declaration for " + qName + " is abstract", this.loc);
        }
        if (string5.length() > 0) {
            if (!elementDeclaration.nillable) {
                throw new ValidationException("Declaration for " + qName + " is nillable but xsi:nil present", this.loc);
            }
            if ("true".equals(string5)) {
                ((XMLSchemaElementTypeInfo)object).nil = true;
                if (elementDeclaration.type == 2) {
                    throw new ValidationException("Declaration for " + qName + " is fixed but xsi:nil is true", this.loc);
                }
            }
        }
        if (!this.context.isEmpty()) {
            XMLSchemaElementTypeInfo xMLSchemaElementTypeInfo = (XMLSchemaElementTypeInfo)this.context.getFirst();
            if (xMLSchemaElementTypeInfo.nil) {
                throw new ValidationException("Parent of " + string3 + " is declared xsi:nil", this.loc);
            }
        }
        this.context.addFirst(object);
        int n = attributes.getLength();
        Attributes2Impl attributes2Impl = new Attributes2Impl();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string6 = attributes.getURI(n3);
            String string7 = attributes.getLocalName(n3);
            String string8 = attributes.getQName(n3);
            String string9 = attributes.getValue(n3);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(string6)) {
                QName qName2 = new QName(string6, string7);
                AttributeDeclaration attributeDeclaration = (AttributeDeclaration)this.schema.attributeDeclarations.get(qName2);
                boolean bl = false;
                if (attributeDeclaration != null) {
                    bl = true;
                }
                boolean bl2 = bl;
                String string10 = attributeDeclaration != null ? attributeDeclaration.datatype.toString() : "CDATA";
                XMLSchemaAttributeTypeInfo xMLSchemaAttributeTypeInfo = new XMLSchemaAttributeTypeInfo(this.schema, attributeDeclaration, true);
                this.attributes.add(xMLSchemaAttributeTypeInfo);
                attributes2Impl.addAttribute(string6, string7, string8, string10, string9);
                attributes2Impl.setDeclared(n2, bl2);
                attributes2Impl.setSpecified(n2, true);
                ++n2;
            }
            ++n3;
        }
        if (this.contentHandler != null) {
            this.contentHandler.startElement(string, string2, string3, attributes2Impl);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        this.context.removeFirst();
        this.attributes.clear();
        this.namespaceSupport.popContext();
        if (this.contentHandler != null) {
            this.contentHandler.endElement(string, string2, string3);
        }
    }

    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        XMLSchemaElementTypeInfo xMLSchemaElementTypeInfo = (XMLSchemaElementTypeInfo)this.context.getFirst();
        if (xMLSchemaElementTypeInfo.nil) {
            throw new ValidationException(xMLSchemaElementTypeInfo.decl.name.toString() + " is declared xsi:nil", this.loc);
        }
        if (this.contentHandler != null) {
            this.contentHandler.characters(cArray, n, n2);
        }
    }

    public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(cArray, n, n2);
        }
    }

    public final void processingInstruction(String string, String string2) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(string, string2);
        }
    }

    public final void skippedEntity(String string) throws SAXException {
        if (this.contentHandler != null) {
            this.contentHandler.skippedEntity(string);
        }
    }

    final Type resolveType(String string) throws DatatypeException {
        String string2;
        QName qName = QName.valueOf(string);
        String string3 = qName.getPrefix();
        String string4 = qName.getLocalPart();
        if (string3 != null && string3.length() > 0 && !"http://www.w3.org/2001/XMLSchema".equals(string2 = this.namespaceSupport.getURI(string3))) {
            return null;
        }
        if ("anyType".equals(string4)) {
            return Type.ANY_TYPE;
        }
        return (SimpleType)this.typeLibrary.createDatatype(string4);
    }

    XMLSchemaValidatorHandler(XMLSchema xMLSchema) {
        this.schema = xMLSchema;
        this.typeInfoProvider = new XMLSchemaTypeInfoProvider(this);
        this.namespaceSupport = new NamespaceSupport();
        this.context = new LinkedList();
        this.attributes = new ArrayList();
        this.typeLibrary = new DatatypeLibraryLoader().createDatatypeLibrary("http://www.w3.org/2001/XMLSchema");
    }
}

