/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;
import gnu.regexp.RETokenPOSIX;

final class RETokenNamedProperty
extends REToken {
    static final byte[] LETTER = new byte[]{2, 1, 3, 4, 5};
    static final byte[] MARK = new byte[]{6, 8, 7};
    static final byte[] SEPARATOR = new byte[]{12, 13, 14};
    static final byte[] SYMBOL = new byte[]{25, 26, 27, 28};
    static final byte[] NUMBER = new byte[]{9, 10, 11};
    static final byte[] PUNCTUATION = new byte[]{20, 21, 22, 23, 24, 29, 30};
    static final byte[] OTHER;
    String name;
    boolean insens;
    boolean negate;
    Handler handler;

    final int getMinimumLength() {
        return 1;
    }

    final int getMaximumLength() {
        return 1;
    }

    final REMatch matchThis(CharIndexed charIndexed, REMatch rEMatch) {
        char c = charIndexed.charAt(rEMatch.index);
        boolean bl = this.matchOneChar(c);
        if (bl) {
            ++rEMatch.index;
            return rEMatch;
        }
        return null;
    }

    private final boolean matchOneChar(char c) {
        if (c == (char)-1) {
            return false;
        }
        boolean bl = this.handler.includes(c);
        if (this.insens) {
            boolean bl2 = false;
            if (bl || this.handler.includes(Character.toUpperCase(c)) || this.handler.includes(Character.toLowerCase(c))) {
                bl2 = bl = true;
            }
        }
        if (this.negate) {
            bl ^= true;
        }
        return bl;
    }

    final boolean returnsFixedLengthMatches() {
        return true;
    }

    final int findFixedLengthMatches(CharIndexed charIndexed, REMatch rEMatch, int n) {
        char c;
        int n2;
        int n3 = rEMatch.index;
        for (n2 = 0; n2 < n && this.matchOneChar(c = charIndexed.charAt(n3++)); ++n2) {
        }
        return n2;
    }

    final void dump(StringBuffer stringBuffer) {
        stringBuffer.append("\\").append(this.negate ? "P" : "p").append("{" + this.name + '}');
    }

    private final Handler getHandler(String string) throws REException {
        if (string.equals("Lower") || string.equals("Upper") || string.equals("Alpha") || string.equals("Digit") || string.equals("Alnum") || string.equals("Punct") || string.equals("Graph") || string.equals("Print") || string.equals("Blank") || string.equals("Cntrl") || string.equals("XDigit") || string.equals("Space")) {
            return new POSIXHandler(string);
        }
        if (string.startsWith("In")) {
            try {
                string = string.substring(2);
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.forName(string);
                return new UnicodeBlockHandler(unicodeBlock);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new REException("Invalid Unicode block name: " + string, 10, 0);
            }
        }
        if (string.startsWith("Is")) {
            string = string.substring(2);
        }
        if (string.equals("L")) {
            return new UnicodeCategoriesHandler(LETTER);
        }
        if (string.equals("M")) {
            return new UnicodeCategoriesHandler(MARK);
        }
        if (string.equals("Z")) {
            return new UnicodeCategoriesHandler(SEPARATOR);
        }
        if (string.equals("S")) {
            return new UnicodeCategoriesHandler(SYMBOL);
        }
        if (string.equals("N")) {
            return new UnicodeCategoriesHandler(NUMBER);
        }
        if (string.equals("P")) {
            return new UnicodeCategoriesHandler(PUNCTUATION);
        }
        if (string.equals("C")) {
            return new UnicodeCategoriesHandler(OTHER);
        }
        if (string.equals("Mc")) {
            return new UnicodeCategoryHandler(8);
        }
        if (string.equals("Pc")) {
            return new UnicodeCategoryHandler(23);
        }
        if (string.equals("Cc")) {
            return new UnicodeCategoryHandler(15);
        }
        if (string.equals("Sc")) {
            return new UnicodeCategoryHandler(26);
        }
        if (string.equals("Pd")) {
            return new UnicodeCategoryHandler(20);
        }
        if (string.equals("Nd")) {
            return new UnicodeCategoryHandler(9);
        }
        if (string.equals("Me")) {
            return new UnicodeCategoryHandler(7);
        }
        if (string.equals("Pe")) {
            return new UnicodeCategoryHandler(22);
        }
        if (string.equals("Pf")) {
            return new UnicodeCategoryHandler(30);
        }
        if (string.equals("Cf")) {
            return new UnicodeCategoryHandler(16);
        }
        if (string.equals("Pi")) {
            return new UnicodeCategoryHandler(29);
        }
        if (string.equals("Nl")) {
            return new UnicodeCategoryHandler(10);
        }
        if (string.equals("Zl")) {
            return new UnicodeCategoryHandler(13);
        }
        if (string.equals("Ll")) {
            return new UnicodeCategoryHandler(2);
        }
        if (string.equals("Sm")) {
            return new UnicodeCategoryHandler(25);
        }
        if (string.equals("Lm")) {
            return new UnicodeCategoryHandler(4);
        }
        if (string.equals("Sk")) {
            return new UnicodeCategoryHandler(27);
        }
        if (string.equals("Mn")) {
            return new UnicodeCategoryHandler(6);
        }
        if (string.equals("Lo")) {
            return new UnicodeCategoryHandler(5);
        }
        if (string.equals("No")) {
            return new UnicodeCategoryHandler(11);
        }
        if (string.equals("Po")) {
            return new UnicodeCategoryHandler(24);
        }
        if (string.equals("So")) {
            return new UnicodeCategoryHandler(28);
        }
        if (string.equals("Zp")) {
            return new UnicodeCategoryHandler(14);
        }
        if (string.equals("Co")) {
            return new UnicodeCategoryHandler(18);
        }
        if (string.equals("Zs")) {
            return new UnicodeCategoryHandler(12);
        }
        if (string.equals("Ps")) {
            return new UnicodeCategoryHandler(21);
        }
        if (string.equals("Cs")) {
            return new UnicodeCategoryHandler(19);
        }
        if (string.equals("Lt")) {
            return new UnicodeCategoryHandler(3);
        }
        if (string.equals("Cn")) {
            return new UnicodeCategoryHandler(0);
        }
        if (string.equals("Lu")) {
            return new UnicodeCategoryHandler(1);
        }
        throw new REException("unsupported name " + string, 10, 0);
    }

    RETokenNamedProperty(int n, String string, boolean bl, boolean bl2) throws REException {
        super(n);
        this.name = string;
        this.insens = bl;
        this.negate = bl2;
        this.handler = this.getHandler(string);
    }

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 15;
        byArray[1] = 16;
        byArray[2] = 18;
        byArray[3] = 19;
        OTHER = byArray;
    }

    private static abstract class Handler {
        public abstract boolean includes(char var1);

        private Handler() {
        }
    }

    private static class POSIXHandler
    extends Handler {
        private RETokenPOSIX retoken;

        public boolean includes(char c) {
            return this.retoken.matchOneChar(c);
        }

        public POSIXHandler(String string) {
            int n = RETokenPOSIX.intValue(string.toLowerCase());
            if (n == -1) {
                throw new RuntimeException("Unknown posix ID: " + string);
            }
            this.retoken = new RETokenPOSIX(0, n, false, false);
        }
    }

    private static class UnicodeBlockHandler
    extends Handler {
        private Character.UnicodeBlock block;

        public boolean includes(char c) {
            Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
            boolean bl = false;
            if (unicodeBlock != null && unicodeBlock.equals(this.block)) {
                bl = true;
            }
            return bl;
        }

        public UnicodeBlockHandler(Character.UnicodeBlock unicodeBlock) {
            this.block = unicodeBlock;
        }
    }

    private static class UnicodeCategoriesHandler
    extends Handler {
        private byte[] categories;

        public boolean includes(char c) {
            int n = Character.getType(c);
            int n2 = 0;
            while (n2 < this.categories.length) {
                if (n == this.categories[n2]) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public UnicodeCategoriesHandler(byte[] byArray) {
            this.categories = byArray;
        }
    }

    private static class UnicodeCategoryHandler
    extends Handler {
        private int category;

        public boolean includes(char c) {
            boolean bl = false;
            if (Character.getType(c) == this.category) {
                bl = true;
            }
            return bl;
        }

        public UnicodeCategoryHandler(byte by) {
            this.category = by;
        }
    }
}

