/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLSocket;
import gnu.javax.net.ssl.provider.SessionContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class SSLServerSocket
extends javax.net.ssl.SSLServerSocket {
    private SessionContext sessions;
    private SortedSet enabledProtocols;
    private List enabledSuites;
    private boolean clientMode;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private boolean createSessions;
    private SRPTrustManager srpTrustManager;
    private X509TrustManager trustManager;
    private X509KeyManager keyManager;
    private SecureRandom random;

    public String[] getSupportedCipherSuites() {
        return (String[])CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getEnabledCipherSuites() {
        List list2 = this.enabledSuites;
        synchronized (list2) {
            String[] stringArray = new String[this.enabledSuites.size()];
            int n = 0;
            Iterator iterator = this.enabledSuites.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = iterator.next().toString();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEnabledCipherSuites(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (CipherSuite.forName(stringArray[n]) == null) {
                throw new IllegalArgumentException("unsupported suite: " + stringArray[n]);
            }
            ++n;
        }
        List list2 = this.enabledSuites;
        synchronized (list2) {
            this.enabledSuites.clear();
            int n2 = 0;
            while (n2 < stringArray.length) {
                CipherSuite cipherSuite = CipherSuite.forName(stringArray[n2]);
                if (!this.enabledSuites.contains(cipherSuite)) {
                    this.enabledSuites.add(cipherSuite);
                }
                ++n2;
            }
            return;
        }
    }

    public String[] getSupportedProtocols() {
        return new String[]{"SSLv3", "TLSv1", "TLSv1.1"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getEnabledProtocols() {
        SortedSet sortedSet = this.enabledProtocols;
        synchronized (sortedSet) {
            String[] stringArray = new String[this.enabledProtocols.size()];
            int n = 0;
            Iterator iterator = this.enabledProtocols.iterator();
            while (iterator.hasNext()) {
                stringArray[n++] = iterator.next().toString();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setEnabledProtocols(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!(stringArray[n].equalsIgnoreCase("SSLv3") || stringArray[n].equalsIgnoreCase("TLSv1") || stringArray[n].equalsIgnoreCase("TLSv1.1"))) {
                throw new IllegalArgumentException("unsupported protocol: " + stringArray[n]);
            }
            ++n;
        }
        SortedSet sortedSet = this.enabledProtocols;
        synchronized (sortedSet) {
            this.enabledProtocols.clear();
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equalsIgnoreCase("SSLv3")) {
                    this.enabledProtocols.add(ProtocolVersion.SSL_3);
                } else if (stringArray[n2].equalsIgnoreCase("TLSv1")) {
                    this.enabledProtocols.add(ProtocolVersion.TLS_1);
                } else {
                    this.enabledProtocols.add(ProtocolVersion.TLS_1_1);
                }
                ++n2;
            }
            return;
        }
    }

    public void setUseClientMode(boolean bl) {
        this.clientMode = bl;
    }

    public boolean getUseClientMode() {
        return this.clientMode;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setEnabledSessionCreation(boolean bl) {
        this.setEnableSessionCreation(bl);
    }

    public void setEnableSessionCreation(boolean bl) {
        this.createSessions = bl;
    }

    public boolean getEnableSessionCreation() {
        return this.createSessions;
    }

    public Socket accept() throws IOException {
        SSLSocket sSLSocket = new SSLSocket();
        this.implAccept(sSLSocket);
        sSLSocket.setUseClientMode(this.clientMode);
        sSLSocket.setNeedClientAuth(this.needClientAuth);
        sSLSocket.setWantClientAuth(this.wantClientAuth);
        sSLSocket.setEnableSessionCreation(this.createSessions);
        sSLSocket.setSessionContext(this.sessions);
        sSLSocket.setEnabledCipherSuites(new ArrayList(this.enabledSuites));
        sSLSocket.setEnabledProtocols(new TreeSet(this.enabledProtocols));
        sSLSocket.setSRPTrustManager(this.srpTrustManager);
        sSLSocket.setTrustManager(this.trustManager);
        sSLSocket.setKeyManager(this.keyManager);
        sSLSocket.setRandom(this.random);
        return sSLSocket;
    }

    void setSessionContext(SessionContext sessionContext) {
        this.sessions = sessionContext;
    }

    void setKeyManager(X509KeyManager x509KeyManager) {
        this.keyManager = x509KeyManager;
    }

    void setTrustManager(X509TrustManager x509TrustManager) {
        this.trustManager = x509TrustManager;
    }

    void setSRPTrustManager(SRPTrustManager sRPTrustManager) {
        this.srpTrustManager = sRPTrustManager;
    }

    void setRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    private final /* synthetic */ void this() {
        this.enabledProtocols = new TreeSet(SSLSocket.supportedProtocols);
        this.enabledSuites = new ArrayList(SSLSocket.supportedSuites);
        this.clientMode = false;
        this.needClientAuth = false;
        this.wantClientAuth = false;
        this.createSessions = true;
    }

    SSLServerSocket() throws IOException {
        this.this();
    }

    SSLServerSocket(int n) throws IOException {
        super(n);
        this.this();
    }

    SSLServerSocket(int n, int n2) throws IOException {
        super(n, n2);
        this.this();
    }

    SSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        super(n, n2, inetAddress);
        this.this();
    }
}

