/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import javax.crypto.interfaces.DHPublicKey;

final class ClientKeyExchange
implements Handshake.Body {
    private final Object exObject;

    static final ClientKeyExchange read(InputStream inputStream, CipherSuite cipherSuite, PublicKey publicKey) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (cipherSuite.getKeyExchange().equals("RSA")) {
            int n = 0;
            n = cipherSuite.getVersion() == ProtocolVersion.SSL_3 ? (((RSAKey)((Object)publicKey)).getModulus().bitLength() + 7) / 8 : dataInputStream.readUnsignedShort();
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            return new ClientKeyExchange(byArray);
        }
        if (cipherSuite.getKeyExchange().equals("SRP")) {
            byte[] byArray = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully(byArray);
            return new ClientKeyExchange(new BigInteger(1, byArray));
        }
        if (publicKey == null || !(publicKey instanceof DHPublicKey)) {
            byte[] byArray = new byte[dataInputStream.readUnsignedShort()];
            dataInputStream.readFully(byArray);
            return new ClientKeyExchange(new BigInteger(1, byArray));
        }
        return new ClientKeyExchange(new byte[0]);
    }

    public final void write(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("use write(java.io.OutputStream,ProtocolVersion) instead");
    }

    public final void write(OutputStream outputStream, ProtocolVersion protocolVersion) throws IOException {
        if (this.exObject instanceof byte[]) {
            byte[] byArray = (byte[])this.exObject;
            if (byArray.length > 0) {
                if (protocolVersion != ProtocolVersion.SSL_3) {
                    outputStream.write(byArray.length >>> 8 & 0xFF);
                    outputStream.write(byArray.length & 0xFF);
                }
                outputStream.write(byArray);
            }
        } else {
            byte[] byArray = ((BigInteger)this.exObject).toByteArray();
            if (byArray[0] == 0) {
                outputStream.write(byArray.length - 1 >>> 8 & 0xFF);
                outputStream.write(byArray.length - 1 & 0xFF);
                outputStream.write(byArray, 1, byArray.length - 1);
            } else {
                outputStream.write(byArray.length >>> 8 & 0xFF);
                outputStream.write(byArray.length & 0xFF);
                outputStream.write(byArray);
            }
        }
    }

    final Object getExchangeObject() {
        return this.exObject;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        if (this.exObject instanceof byte[] && ((byte[])this.exObject).length > 0) {
            printWriter.println("  encryptedPreMasterSecret =");
            printWriter.print(Util.hexDump((byte[])this.exObject, "    "));
        } else if (this.exObject instanceof BigInteger) {
            printWriter.println("  clientPublic = " + ((BigInteger)this.exObject).toString(16) + ';');
        }
        printWriter.println("} ClientKeyExchange;");
        return stringWriter.toString();
    }

    ClientKeyExchange(byte[] byArray) {
        this.exObject = byArray;
    }

    ClientKeyExchange(BigInteger bigInteger) {
        this.exObject = bigInteger;
    }
}

