/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRLE8
extends BMPDecoder {
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public BufferedImage decode(ImageInputStream imageInputStream) throws IOException, BMPException {
        IndexColorModel indexColorModel = this.readPalette(imageInputStream);
        this.skipToImage(imageInputStream);
        Dimension dimension = this.infoHeader.getSize();
        int n = (int)dimension.getHeight();
        int n2 = (int)dimension.getWidth();
        byte[] byArray = this.uncompress(n2, n, imageInputStream);
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = new SinglePixelPackedSampleModel(0, n2, n, new int[]{255});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n2 * n, 0);
        WritableRaster writableRaster = Raster.createWritableRaster(singlePixelPackedSampleModel, dataBufferByte, null);
        return new BufferedImage(indexColorModel, writableRaster, false, null);
    }

    private final byte[] uncompress(int n, int n2, ImageInputStream imageInputStream) throws BMPException, IOException {
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[n * n2];
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        try {
            while (n3 + n4 * n < n * n2) {
                int n5;
                int n6;
                if (imageInputStream.read(byArray) != 2) {
                    throw new IOException("Error reading compressed data.");
                }
                if (byArray[0] == 0) {
                    switch (byArray[1]) {
                        case 1: {
                            return byArray2;
                        }
                        case 0: {
                            n3 = 0;
                            ++n4;
                            break;
                        }
                        case 2: {
                            if (imageInputStream.read(byArray) != 2) {
                                throw new IOException("Error reading compressed data.");
                            }
                            n6 = byArray[0] & 0xFF;
                            n5 = byArray[1] & 0xFF;
                            n3 += n6;
                            n4 += n5;
                            break;
                        }
                        default: {
                            int n7;
                            int n8 = n7 = byArray[1] & 0xFF;
                            n7 += n7 & 1;
                            byte[] byArray3 = new byte[n7];
                            if (imageInputStream.read(byArray3) != n7) {
                                throw new IOException("Error reading compressed data.");
                            }
                            System.arraycopy(byArray3, 0, byArray2, n3 + n * (n2 - n4 - 1), n8);
                            n3 += n8;
                            break;
                        }
                    }
                    continue;
                }
                n6 = byArray[0] & 0xFF;
                n5 = 0;
                while (n5 < n6) {
                    byArray2[(n2 - n4 - 1) * n + n3++] = byArray[1];
                    ++n5;
                }
            }
            return byArray2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BMPException("Invalid RLE data.");
        }
    }

    public DecodeRLE8(BMPFileHeader bMPFileHeader, BMPInfoHeader bMPInfoHeader) {
        super(bMPFileHeader, bMPInfoHeader);
    }
}

