/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.javax.crypto.sasl.srp.SecurityContext;
import gnu.javax.crypto.sasl.srp.StoreEntry;
import java.util.HashMap;

public class ServerStore {
    private static ServerStore singleton = null;
    private static final HashMap sid2ssc = new HashMap();
    private static final HashMap sid2ttl = new HashMap();
    private static final Object lock = new Object();
    private static int counter = 0;

    static final synchronized ServerStore instance() {
        if (singleton == null) {
            singleton = new ServerStore();
        }
        return singleton;
    }

    static final synchronized byte[] getNewSessionID() {
        String string = String.valueOf(++counter);
        return ("SID-" + "0000000000".substring(0, 10 - string.length()) + string).getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isAlive(byte[] byArray) {
        boolean bl = false;
        if (byArray == null || byArray.length == 0) return bl;
        Object object = lock;
        synchronized (object) {
            String string = new String(byArray);
            StoreEntry storeEntry = (StoreEntry)sid2ttl.get(string);
            if (storeEntry == null || (bl = storeEntry.isAlive())) return bl;
            sid2ssc.remove(string);
            sid2ttl.remove(string);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void cacheSession(int n, SecurityContext securityContext) {
        Object object = lock;
        synchronized (object) {
            String string = new String(securityContext.getSID());
            sid2ssc.put(string, securityContext);
            sid2ttl.put(string, new StoreEntry(n));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SecurityContext restoreSession(byte[] byArray) {
        String string = new String(byArray);
        Object object = lock;
        synchronized (object) {
            SecurityContext securityContext = (SecurityContext)sid2ssc.remove(string);
            sid2ttl.remove(string);
            return securityContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void invalidateSession(byte[] byArray) {
        String string = new String(byArray);
        Object object = lock;
        synchronized (object) {
            sid2ssc.remove(string);
            sid2ttl.remove(string);
            return;
        }
    }

    private ServerStore() {
    }
}

