/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import gnu.javax.crypto.sasl.ServerMechanism;
import gnu.javax.crypto.sasl.anonymous.AnonymousServer;
import gnu.javax.crypto.sasl.crammd5.CramMD5Server;
import gnu.javax.crypto.sasl.plain.PlainServer;
import gnu.javax.crypto.sasl.srp.SRPServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class ServerFactory
implements SaslServerFactory {
    public static final Set getNames() {
        return Collections.unmodifiableSet(new HashSet(Arrays.asList(ServerFactory.getNamesInternal(null))));
    }

    private static final String[] getNamesInternal(Map map) {
        String[] stringArray = new String[]{"SRP", "CRAM-MD5", "PLAIN", "ANONYMOUS"};
        ArrayList arrayList = new ArrayList(4);
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n++]);
        }
        if (map == null) {
            return (String[])arrayList.toArray(new String[0]);
        }
        if (ServerFactory.hasPolicy("javax.security.sasl.policy.credentials", map)) {
            return new String[0];
        }
        if (ServerFactory.hasPolicy("javax.security.sasl.policy.noplaintext", map)) {
            arrayList.remove("PLAIN");
        }
        if (ServerFactory.hasPolicy("javax.security.sasl.policy.noactive", map)) {
            arrayList.remove("CRAM-MD5");
            arrayList.remove("PLAIN");
        }
        if (ServerFactory.hasPolicy("javax.security.sasl.policy.nodictionary", map)) {
            arrayList.remove("CRAM-MD5");
            arrayList.remove("PLAIN");
        }
        if (ServerFactory.hasPolicy("javax.security.sasl.policy.noanonymous", map)) {
            arrayList.remove("ANONYMOUS");
        }
        if (ServerFactory.hasPolicy("javax.security.sasl.policy.forward", map)) {
            arrayList.remove("CRAM-MD5");
            arrayList.remove("ANONYMOUS");
            arrayList.remove("PLAIN");
        }
        return (String[])arrayList.toArray(new String[0]);
    }

    public static final ServerMechanism getInstance(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim().toUpperCase()).equals("SRP")) {
            return new SRPServer();
        }
        if (string.equals("CRAM-MD5")) {
            return new CramMD5Server();
        }
        if (string.equals("PLAIN")) {
            return new PlainServer();
        }
        if (string.equals("ANONYMOUS")) {
            return new AnonymousServer();
        }
        return null;
    }

    public SaslServer createSaslServer(String string, String string2, String string3, Map map, CallbackHandler callbackHandler) throws SaslException {
        ServerMechanism serverMechanism = ServerFactory.getInstance(string);
        if (serverMechanism != null) {
            HashMap hashMap = new HashMap();
            if (map != null) {
                hashMap.putAll(map);
            }
            hashMap.put("gnu.crypto.sasl.protocol", string2);
            hashMap.put("gnu.crypto.sasl.server.name", string3);
            hashMap.put("gnu.crypto.sasl.callback.handler", callbackHandler);
            serverMechanism.init(hashMap);
        }
        return serverMechanism;
    }

    public String[] getMechanismNames(Map map) {
        return ServerFactory.getNamesInternal(map);
    }

    private static final boolean hasPolicy(String string, Map map) {
        return "true".equalsIgnoreCase(String.valueOf(map.get(string)));
    }
}

