/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.javax.crypto.keyring.Entry;
import gnu.javax.crypto.keyring.EnvelopeEntry;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.MeteredInputStream;
import gnu.javax.crypto.keyring.Properties;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class CompressedEntry
extends EnvelopeEntry {
    public static final int TYPE = 4;

    public static CompressedEntry decode(DataInputStream dataInputStream) throws IOException {
        CompressedEntry compressedEntry = new CompressedEntry();
        compressedEntry.properties.decode(dataInputStream);
        String string = compressedEntry.properties.get("algorithm");
        if (string == null) {
            throw new MalformedKeyringException("no compression algorithm");
        }
        if (!string.equalsIgnoreCase("DEFLATE")) {
            throw new MalformedKeyringException("unsupported compression algorithm: " + string);
        }
        int n = dataInputStream.readInt();
        MeteredInputStream meteredInputStream = new MeteredInputStream(dataInputStream, n);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(meteredInputStream);
        DataInputStream dataInputStream2 = new DataInputStream(inflaterInputStream);
        compressedEntry.decodeEnvelope(dataInputStream2);
        return compressedEntry;
    }

    protected void encodePayload() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(deflaterOutputStream);
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            ((Entry)iterator.next()).encode(dataOutputStream);
        }
        deflaterOutputStream.finish();
        this.payload = byteArrayOutputStream.toByteArray();
    }

    public CompressedEntry(Properties properties) {
        super(4, properties);
        this.properties.put("algorithm", "DEFLATE");
    }

    private CompressedEntry() {
        this(new Properties());
    }
}

