/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.hash.Sha160;
import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.util.PRNG;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.crypto.key.dh.RFC2631;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GnuDHKeyPairGenerator
implements IKeyPairGenerator {
    private static final String NAME = "dh";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 5;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.dh.prng";
    public static final String DH_PARAMETERS = "gnu.crypto.dh.params";
    public static final String PRIME_SIZE = "gnu.crypto.dh.L";
    public static final String EXPONENT_SIZE = "gnu.crypto.dh.m";
    public static final String PREFERRED_ENCODING_FORMAT = "gnu.crypto.dh.encoding";
    public static final int DEFAULT_PRIME_SIZE = 512;
    public static final int DEFAULT_EXPONENT_SIZE = 160;
    private static final int DEFAULT_ENCODING_FORMAT = 1;
    private Sha160 sha;
    private SecureRandom rnd;
    private int l;
    private int m;
    private BigInteger seed;
    private BigInteger counter;
    private BigInteger q;
    private BigInteger p;
    private BigInteger j;
    private BigInteger g;
    private PRNG prng;
    private int preferredFormat;

    private static final void debug(String string) {
        err.println(">>> dh: " + string);
    }

    public String name() {
        return NAME;
    }

    public void setup(Map map) {
        Object object;
        this.rnd = (SecureRandom)map.get(SOURCE_OF_RANDOMNESS);
        Object object2 = map.get(DH_PARAMETERS);
        if (object2 instanceof DHGenParameterSpec) {
            object = (DHGenParameterSpec)object2;
            this.l = ((DHGenParameterSpec)object).getPrimeSize();
            this.m = ((DHGenParameterSpec)object).getExponentSize();
        } else if (object2 instanceof DHParameterSpec) {
            object = (DHParameterSpec)object2;
            this.l = ((DHParameterSpec)object).getP().bitLength();
            this.m = ((DHParameterSpec)object).getL();
        } else {
            object = (Integer)map.get(PRIME_SIZE);
            this.l = object == null ? 512 : (Integer)object;
            object = (Integer)map.get(EXPONENT_SIZE);
            int n = this.m = object == null ? 160 : (Integer)object;
        }
        if (this.l % 256 != 0 || this.l < 512) {
            throw new IllegalArgumentException("invalid modulus size");
        }
        if (this.m % 8 != 0 || this.m < 160) {
            throw new IllegalArgumentException("invalid exponent size");
        }
        if (this.m > this.l) {
            throw new IllegalArgumentException("exponent size > modulus size");
        }
        object = (Integer)map.get(PREFERRED_ENCODING_FORMAT);
        int n = 1;
        if (object != null) {
            n = (Integer)object;
        }
        this.preferredFormat = n;
    }

    public KeyPair generate() {
        BigInteger bigInteger;
        BigInteger[] bigIntegerArray;
        if (this.p == null) {
            bigIntegerArray = new RFC2631(this.m, this.l, this.rnd).generateParameters();
            this.seed = bigIntegerArray[0];
            this.counter = bigIntegerArray[1];
            this.q = bigIntegerArray[2];
            this.p = bigIntegerArray[3];
            this.j = bigIntegerArray[4];
            this.g = bigIntegerArray[5];
        }
        bigIntegerArray = this.q.subtract(BigInteger.ONE);
        byte[] byArray = new byte[(this.m + 7) / 8];
        do {
            this.nextRandomBytes(byArray);
        } while ((bigInteger = new BigInteger(1, byArray)).bitLength() != this.m || bigInteger.compareTo(BigInteger.ONE) <= 0 || bigInteger.compareTo((BigInteger)bigIntegerArray) >= 0);
        BigInteger bigInteger2 = this.g.modPow(bigInteger, this.p);
        GnuDHPrivateKey gnuDHPrivateKey = new GnuDHPrivateKey(this.preferredFormat, this.q, this.p, this.g, bigInteger);
        GnuDHPublicKey gnuDHPublicKey = new GnuDHPublicKey(this.preferredFormat, this.q, this.p, this.g, bigInteger2);
        return new KeyPair(gnuDHPublicKey, gnuDHPrivateKey);
    }

    private final void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private final PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }

    private final /* synthetic */ void this() {
        this.sha = new Sha160();
        this.rnd = null;
        this.prng = null;
    }

    public GnuDHKeyPairGenerator() {
        this.this();
    }
}

