/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.mac;

import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mac.MacFactory;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.MacSpi;

class MacAdapter
extends MacSpi
implements Cloneable {
    protected IMac mac;
    protected Map attributes;

    public Object clone() throws CloneNotSupportedException {
        return new MacAdapter((IMac)this.mac.clone(), new HashMap(this.attributes));
    }

    protected byte[] engineDoFinal() {
        byte[] byArray = this.mac.digest();
        this.engineReset();
        return byArray;
    }

    protected int engineGetMacLength() {
        return this.mac.macSize();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("unknown key format " + key.getFormat());
        }
        this.attributes.put("gnu.crypto.mac.key.material", key.getEncoded());
        this.mac.reset();
        this.mac.init(this.attributes);
    }

    protected void engineReset() {
        this.mac.reset();
    }

    protected void engineUpdate(byte by) {
        this.mac.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
    }

    protected MacAdapter(String string) {
        this.mac = MacFactory.getInstance(string);
        this.attributes = new HashMap();
    }

    private MacAdapter(IMac iMac, Map map) {
        this.mac = iMac;
        this.attributes = map;
    }
}

