/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.javax.crypto.cipher.BaseCipher;
import gnu.javax.crypto.cipher.DES;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.Iterator;

public class TripleDES
extends BaseCipher {
    public static final int BLOCK_SIZE = 8;
    public static final int KEY_SIZE = 24;
    private DES des = new DES();

    public static void adjustParity(byte[] byArray, int n) {
        DES.adjustParity(byArray, n);
        DES.adjustParity(byArray, n + 8);
        DES.adjustParity(byArray, n + 16);
    }

    public static boolean isParityAdjusted(byte[] byArray, int n) {
        boolean bl = false;
        if (DES.isParityAdjusted(byArray, n) && DES.isParityAdjusted(byArray, n + 8) && DES.isParityAdjusted(byArray, n + 16)) {
            bl = true;
        }
        return bl;
    }

    public Object clone() {
        return new TripleDES();
    }

    public Iterator blockSizes() {
        return Collections.singleton(new Integer(8)).iterator();
    }

    public Iterator keySizes() {
        return Collections.singleton(new Integer(24)).iterator();
    }

    public Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 24) {
            throw new InvalidKeyException("TripleDES key must be 24 bytes");
        }
        if (!TripleDES.isParityAdjusted(byArray, 0)) {
            TripleDES.adjustParity(byArray, 0);
        }
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        System.arraycopy(byArray, 8, byArray3, 0, 8);
        System.arraycopy(byArray, 16, byArray4, 0, 8);
        Context context = new Context();
        context.k1 = (DES.Context)this.des.makeKey(byArray2, n);
        context.k2 = (DES.Context)this.des.makeKey(byArray3, n);
        context.k3 = (DES.Context)this.des.makeKey(byArray4, n);
        return context;
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        byte[] byArray3 = new byte[8];
        this.des.encrypt(byArray, n, byArray3, 0, ((Context)object).k1, n3);
        this.des.decrypt(byArray3, 0, byArray3, 0, ((Context)object).k2, n3);
        this.des.encrypt(byArray3, 0, byArray2, n2, ((Context)object).k3, n3);
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        byte[] byArray3 = new byte[8];
        this.des.decrypt(byArray, n, byArray3, 0, ((Context)object).k3, n3);
        this.des.encrypt(byArray3, 0, byArray3, 0, ((Context)object).k2, n3);
        this.des.decrypt(byArray3, 0, byArray2, n2, ((Context)object).k1, n3);
    }

    public TripleDES() {
        super("tripledes", 8, 24);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class Context {
        DES.Context k1;
        DES.Context k2;
        DES.Context k3;

        private Context() {
        }
    }
}

