/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.color;

import java.awt.color.ICC_Profile;
import java.nio.ByteBuffer;

public class ColorLookUpTable {
    private static float[] D50 = new float[]{0.96422f, 1.0f, 0.82521f};
    int nIn;
    int nOut;
    int nInTableEntries;
    int nOutTableEntries;
    int gridpoints;
    int nClut;
    double[][] inTable;
    short[][] outTable;
    double[] clut;
    float[][] inMatrix;
    boolean useMatrix = false;
    int[] multiplier;
    int[] offsets;
    boolean inputLab;
    boolean outputLab;

    private final void readClut16(byte[] byArray) {
        int n;
        int n2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.nIn = byArray[8] & 0xFF;
        this.nOut = byArray[9] & 0xFF;
        this.nInTableEntries = byteBuffer.getShort(48);
        this.nOutTableEntries = byteBuffer.getShort(50);
        this.gridpoints = byArray[10] & 0xFF;
        this.inMatrix = new float[3][3];
        int n3 = 0;
        while (n3 < 3) {
            n2 = 0;
            while (n2 < 3) {
                this.inMatrix[n3][n2] = (float)byteBuffer.getInt(12 + (n3 * 3 + n2) * 4) / 65536.0f;
                ++n2;
            }
            ++n3;
        }
        this.inTable = new double[this.nIn][this.nInTableEntries];
        n3 = 0;
        while (n3 < this.nIn) {
            n2 = 0;
            while (n2 < this.nInTableEntries) {
                this.inTable[n3][n2] = (double)(byteBuffer.getShort(52 + (n3 * this.nInTableEntries + n2) * 2) & (char)-1) / 65536.0;
                ++n2;
            }
            ++n3;
        }
        this.nClut = this.nOut;
        this.multiplier = new int[this.nIn];
        this.multiplier[this.nIn - 1] = this.nOut;
        n3 = 0;
        while (n3 < this.nIn) {
            this.nClut *= this.gridpoints;
            if (n3 > 0) {
                this.multiplier[this.nIn - n3 - 1] = this.multiplier[this.nIn - n3] * this.gridpoints;
            }
            ++n3;
        }
        n3 = 52 + this.nIn * this.nInTableEntries * 2;
        this.clut = new double[this.nClut];
        n2 = 0;
        while (n2 < this.nClut) {
            this.clut[n2] = (double)(byteBuffer.getShort(n3 + n2 * 2) & (char)-1) / 65536.0;
            ++n2;
        }
        this.outTable = new short[this.nOut][this.nOutTableEntries];
        n2 = 0;
        while (n2 < this.nOut) {
            n = 0;
            while (n < this.nOutTableEntries) {
                this.outTable[n2][n] = byteBuffer.getShort(n3 + (this.nClut + n2 * this.nOutTableEntries + n) * 2);
                ++n;
            }
            ++n2;
        }
        this.offsets = new int[1 << this.nIn];
        this.offsets[0] = 0;
        n2 = 0;
        while (n2 < this.nIn) {
            n = 1 << n2;
            int n4 = 0;
            while (n4 < n) {
                this.offsets[n + n4] = this.offsets[n4] + this.multiplier[n2];
                ++n4;
            }
            ++n2;
        }
    }

    private final void readClut8(byte[] byArray) {
        int n;
        int n2;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.nIn = byArray[8] & 0xFF;
        this.nOut = byArray[9] & 0xFF;
        this.nInTableEntries = 256;
        this.nOutTableEntries = 256;
        this.gridpoints = byArray[10] & 0xFF;
        this.inMatrix = new float[3][3];
        int n3 = 0;
        while (n3 < 3) {
            n2 = 0;
            while (n2 < 3) {
                this.inMatrix[n3][n2] = (float)byteBuffer.getInt(12 + (n3 * 3 + n2) * 4) / 65536.0f;
                ++n2;
            }
            ++n3;
        }
        this.inTable = new double[this.nIn][this.nInTableEntries];
        n3 = 0;
        while (n3 < this.nIn) {
            n2 = 0;
            while (n2 < this.nInTableEntries) {
                this.inTable[n3][n2] = (double)(byteBuffer.get(48 + (n3 * this.nInTableEntries + n2)) & 0xFF) / 255.0;
                ++n2;
            }
            ++n3;
        }
        this.nClut = this.nOut;
        this.multiplier = new int[this.nIn];
        this.multiplier[this.nIn - 1] = this.nOut;
        n3 = 0;
        while (n3 < this.nIn) {
            this.nClut *= this.gridpoints;
            if (n3 > 0) {
                this.multiplier[this.nIn - n3 - 1] = this.multiplier[this.nIn - n3] * this.gridpoints;
            }
            ++n3;
        }
        n3 = 48 + this.nIn * this.nInTableEntries;
        this.clut = new double[this.nClut];
        n2 = 0;
        while (n2 < this.nClut) {
            this.clut[n2] = (double)(byteBuffer.get(n3 + n2) & 0xFF) / 255.0;
            ++n2;
        }
        this.outTable = new short[this.nOut][this.nOutTableEntries];
        n2 = 0;
        while (n2 < this.nOut) {
            n = 0;
            while (n < this.nOutTableEntries) {
                this.outTable[n2][n] = (short)(byteBuffer.get(n3 + this.nClut + n2 * this.nOutTableEntries + n) * 257);
                ++n;
            }
            ++n2;
        }
        this.offsets = new int[1 << this.nIn];
        this.offsets[0] = 0;
        n2 = 0;
        while (n2 < this.nIn) {
            n = 1 << n2;
            int n4 = 0;
            while (n4 < n) {
                this.offsets[n + n4] = this.offsets[n4] + this.multiplier[n2];
                ++n4;
            }
            ++n2;
        }
    }

    float[] lookup(float[] fArray) {
        int n;
        int n2;
        float[] fArray2 = new float[fArray.length];
        if (this.useMatrix) {
            n2 = 0;
            while (n2 < 3) {
                fArray2[n2] = fArray[0] * this.inMatrix[n2][0] + fArray[1] * this.inMatrix[n2][1] + fArray[2] * this.inMatrix[n2][2];
                ++n2;
            }
        } else if (this.inputLab) {
            fArray2 = this.XYZtoLab(fArray);
        } else {
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        }
        n2 = 0;
        while (n2 < this.nIn) {
            int n3 = (int)Math.floor((double)fArray2[n2] * (double)(this.nInTableEntries - 1));
            if (n3 >= this.nInTableEntries - 1) {
                fArray2[n2] = (float)this.inTable[n2][this.nInTableEntries - 1];
            } else if (n3 < 0) {
                fArray2[n2] = (float)this.inTable[n2][0];
            } else {
                double d = (double)fArray2[n2] * ((double)this.nInTableEntries - 1.0) - (double)n3;
                fArray2[n2] = (float)(this.inTable[n2][n3] * (1.0 - d) + this.inTable[n2][n3 + 1] * d);
            }
            ++n2;
        }
        double[] dArray = new double[this.nOut];
        double[] dArray2 = new double[1 << this.nIn];
        double[] dArray3 = new double[this.nIn];
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.nIn) {
            n = (int)Math.floor((double)fArray2[n5] * ((double)this.gridpoints - 1.0));
            double d = (double)fArray2[n5] * ((double)this.gridpoints - 1.0) - (double)n;
            if (n >= this.gridpoints - 1) {
                n = this.gridpoints - 1;
                d = 1.0;
            } else if (n < 0) {
                n = 0;
            }
            dArray3[n5] = d;
            n4 += n * this.multiplier[n5];
            ++n5;
        }
        dArray2[0] = 1.0;
        n5 = 0;
        while (n5 < this.nIn) {
            n = 1 << n5;
            int n6 = 0;
            while (n6 < n) {
                dArray2[n + n6] = dArray2[n6] * dArray3[n5];
                int n7 = n6++;
                dArray2[n7] = dArray2[n7] * (1.0 - dArray3[n5]);
            }
            ++n5;
        }
        n5 = 0;
        while (n5 < this.nOut) {
            dArray[n5] = dArray2[0] * this.clut[n4 + n5];
            ++n5;
        }
        n5 = 1;
        while (n5 < 1 << this.nIn) {
            n = n4 + this.offsets[n5];
            int n8 = 0;
            while (n8 < this.nOut) {
                int n9 = n8;
                dArray[n9] = dArray[n9] + dArray2[n5] * this.clut[n + n8];
                ++n8;
            }
            ++n5;
        }
        float[] fArray3 = new float[this.nOut];
        n = 0;
        while (n < this.nOut) {
            int n10 = (int)Math.floor(dArray[n] * ((double)this.nOutTableEntries - 1.0));
            if (n10 >= this.nOutTableEntries - 1) {
                fArray3[n] = this.outTable[n][this.nOutTableEntries - 1];
            } else if (n10 < 0) {
                fArray3[n] = this.outTable[n][0];
            } else {
                double d = dArray[n] * ((double)this.nOutTableEntries - 1.0) - (double)n10;
                fArray3[n] = (float)((double)(this.outTable[n][n10] & (char)-1) * (1.0 - d) + (double)(this.outTable[n][n10 + 1] & (char)-1) * d) / 65536.0f;
            }
            ++n;
        }
        if (this.outputLab) {
            return this.LabtoXYZ(fArray3);
        }
        return fArray3;
    }

    private final float[] LabtoXYZ(float[] fArray) {
        fArray[0] = (float)(100.392156862745 * (double)fArray[0]);
        fArray[1] = fArray[1] * 256.0f - 128.0f;
        fArray[2] = fArray[2] * 256.0f - 128.0f;
        float[] fArray2 = new float[3];
        fArray2[1] = (fArray[0] + 16.0f) / 116.0f;
        fArray2[0] = fArray[1] / 500.0f + fArray2[1];
        fArray2[2] = fArray2[1] - fArray[2] / 200.0f;
        int n = 0;
        while (n < 3) {
            double d = fArray2[n] * fArray2[n] * fArray2[n];
            fArray2[n] = d <= 0.008856 ? (fArray2[n] - 0.13793103f) / 7.787f : (float)d;
            fArray2[n] = D50[n] * fArray2[n];
            ++n;
        }
        return fArray2;
    }

    private final float[] XYZtoLab(float[] fArray) {
        float[] fArray2 = new float[3];
        int n = 0;
        while (n < 3) {
            fArray2[n] = fArray[n] / D50[n];
            fArray2[n] = fArray2[n] <= 0.008856f ? 7.787069f * fArray2[n] + 0.13793103f : (float)Math.exp(0.3333333333333333 * Math.log(fArray2[n]));
            ++n;
        }
        float[] fArray3 = new float[]{116.0f * fArray2[1] - 16.0f, 500.0f * (fArray2[0] - fArray2[1]), 200.0f * (fArray2[1] - fArray2[2])};
        fArray3[0] = (float)((double)fArray3[0] / 100.392156862745);
        fArray3[1] = (fArray3[1] + 128.0f) / 256.0f;
        fArray3[2] = (fArray3[2] + 128.0f) / 256.0f;
        int n2 = 0;
        while (n2 < 3) {
            if (fArray3[n2] < 0.0f) {
                fArray3[n2] = 0.0f;
            }
            if (fArray3[n2] > 1.0f) {
                fArray3[n2] = 1.0f;
            }
            ++n2;
        }
        return fArray3;
    }

    public ColorLookUpTable(ICC_Profile iCC_Profile, int n) {
        switch (n) {
            case 1093812784: 
            case 1093812785: 
            case 1093812786: {
                if (iCC_Profile.getColorSpaceType() == 0) {
                    this.useMatrix = true;
                }
                this.inputLab = false;
                boolean bl = false;
                if (iCC_Profile.getPCSType() == 1) {
                    bl = true;
                }
                this.outputLab = bl;
                break;
            }
            case 1110589744: 
            case 1110589745: 
            case 1110589746: {
                if (iCC_Profile.getPCSType() == 0) {
                    this.useMatrix = true;
                }
                boolean bl = false;
                if (iCC_Profile.getPCSType() == 1) {
                    bl = true;
                }
                this.inputLab = bl;
                this.outputLab = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a clut-type tag.");
            }
        }
        byte[] byArray = iCC_Profile.getData(n);
        if (byArray == null) {
            throw new IllegalArgumentException("Unsuitable profile, does not contain a CLUT.");
        }
        if (byArray[0] != 109 || byArray[1] != 102 || byArray[2] != 116) {
            throw new IllegalArgumentException("Unsuitable profile, invalid CLUT data.");
        }
        if (byArray[3] == 50) {
            this.readClut16(byArray);
        } else if (byArray[3] == 49) {
            this.readClut8(byArray);
        } else {
            throw new IllegalArgumentException("Unknown/invalid CLUT type.");
        }
    }
}

