/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.ClassTypeWriter;
import gnu.bytecodecvssnap.ConstantPool;
import gnu.bytecodecvssnap.CpoolClass;
import gnu.bytecodecvssnap.CpoolEntry;
import gnu.bytecodecvssnap.CpoolNameAndType;
import java.io.DataOutputStream;
import java.io.IOException;

public class CpoolRef
extends CpoolEntry {
    CpoolClass clas;
    CpoolNameAndType nameAndType;
    int tag;

    public int getTag() {
        return this.tag;
    }

    public final CpoolClass getCpoolClass() {
        return this.clas;
    }

    public final CpoolNameAndType getNameAndType() {
        return this.nameAndType;
    }

    static final int hashCode(CpoolClass cpoolClass, CpoolNameAndType cpoolNameAndType) {
        return cpoolClass.hashCode() ^ cpoolNameAndType.hashCode();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = CpoolRef.hashCode(this.clas, this.nameAndType);
        }
        return this.hash;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeShort(this.clas.index);
        dataOutputStream.writeShort(this.nameAndType.index);
    }

    public void print(ClassTypeWriter classTypeWriter, int n) {
        String string;
        switch (this.tag) {
            case 9: {
                string = "Field";
                break;
            }
            case 10: {
                string = "Method";
                break;
            }
            case 11: {
                string = "InterfaceMethod";
                break;
            }
            default: {
                string = "<Unknown>Ref";
            }
        }
        if (n > 0) {
            classTypeWriter.print(string);
            if (n == 2) {
                classTypeWriter.print(" class: ");
                classTypeWriter.printOptionalIndex(this.clas);
            } else {
                classTypeWriter.print(' ');
            }
        }
        this.clas.print(classTypeWriter, 0);
        if (n < 2) {
            classTypeWriter.print('.');
        } else {
            classTypeWriter.print(" name_and_type: ");
            classTypeWriter.printOptionalIndex(this.nameAndType);
            classTypeWriter.print('<');
        }
        this.nameAndType.print(classTypeWriter, 0);
        if (n == 2) {
            classTypeWriter.print('>');
        }
    }

    CpoolRef(int n) {
        this.tag = n;
    }

    CpoolRef(ConstantPool constantPool, int n, int n2, CpoolClass cpoolClass, CpoolNameAndType cpoolNameAndType) {
        super(constantPool, n);
        this.tag = n2;
        this.clas = cpoolClass;
        this.nameAndType = cpoolNameAndType;
    }
}

