#!/usr/local/bin/wish8.4 -f
#  'CBB' -- Check Book Balancer
#
#   common.tcl -- commonly used tcl routines.
#
#  Written by Curtis Olson.  Started August 25, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: common.tcl,v 2.5 1996/12/17 14:53:54 curt Exp $
# (Log is kept at end of this file)


#------------------------------------------------------------------------------
# Ok message for general use
#------------------------------------------------------------------------------

proc cbbWindow.ok mesg {
    global cbb

    set w ".ok"

    if {[winfo exists $w] == 1} {
        destroy $w
    }

    option add *font $cbb(msg_text_font)
    
    toplevel $w

    wm title $w "Info / Warning"
    wm iconname $w "Info / Warning"
    frame $w.frame -borderwidth 2 -relief groove

    message $w.frame.m -width 300 -text $mesg
    button $w.frame.dismiss -text " Dismiss " -command "destroy $w" \
	    -font $cbb(button_font)

    pack $w.frame -side top -fill both -expand 1 -padx 4 -pady 4
    pack $w.frame.dismiss -side bottom -fill x -padx 6 -pady 6
    pack $w.frame.m -side top -fill both -expand 1
}


#------------------------------------------------------------------------------
# Yes/No message for general use
#------------------------------------------------------------------------------

proc cbbWindow.yesno { mesg } {
    global cbb yesno

    set w ".yesno"

    if "[winfo exists $w] == 1" {
        destroy $w
    }

    option add *font $cbb(msg_text_font)
    
    toplevel $w

    wm title $w "Yes / No"
    wm iconname $w "Yes / No"
    frame $w.frame -borderwidth 2 -relief groove

    message $w.frame.m -width 300 -text $mesg
    frame $w.frame.btn -borderwidth 0
    button $w.frame.btn.yes -text " Yes " -font $cbb(button_font) \
	    -command "set yesno(result) yes; destroy $w"
    button $w.frame.btn.no -text " No " -font $cbb(button_font) \
	    -command "set yesno(result) no; destroy $w"
    button $w.frame.btn.maybe -text " Cancel " -font $cbb(button_font) \
	    -command "set yesno(result) cancel; destroy $w"

    pack $w.frame -side top -fill both -expand 1 -padx 4 -pady 4
    pack $w.frame.btn -side bottom -fill x
    pack $w.frame.btn.yes $w.frame.btn.no $w.frame.btn.maybe \
	-side left -fill x -expand 1 -padx 8 -pady 8
    pack $w.frame.m -side top -fill both -expand 1
}


# use the system's pwd instead of builtin tcl-pwd, since the system's version
# seems to handle soft links better.
proc mypwd {} {
    global env

    # set pwdhandle [open |pwd r+]
    # gets $pwdhandle pwd
    # close $pwdhandle

    #puts "[array names env PWD]"

    if { "[array names env PWD]" == "" } {
	#puts "Using pwd()"
	return "[pwd]"
    } else {
	#puts "Using mypwd()"
	return "$env(PWD)"
    }
}


# get the current system date
proc get_sys_date {} {
    set datehandle [open |date r+]
    gets $datehandle now_today
    close $datehandle

    return $now_today
}


# ----------------------------------------------------------------------------
# $Log: common.tcl,v $
# Revision 2.5  1996/12/17 14:53:54  curt
# Updated copyright date.
#
# Revision 2.4  1996/12/14 17:15:21  curt
# The great overhaul of December '96.
#
# Revision 2.3  1996/12/11 18:33:31  curt
# Ran a spell checker.
#
# Revision 2.2  1996/12/08 07:39:58  curt
# Rearranged quite a bit of code.
# Put most global variables in cbb() structure.
#
# Revision 2.1  1996/12/07 20:38:14  curt
# Renamed *.tk -> *.tcl
#
# Revision 2.3  1996/09/30 15:14:36  curt
# Updated CBB URL, and hardwired wish path.
#
# Revision 2.2  1996/07/13 02:57:39  curt
# Version 0.65
# Packing Changes
# Documentation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.1  1996/02/27  05:35:38  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:41:50  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
