/*
 * ugetc.h -- $Id$
 * play interface for non-event-driven programs
 * -- incompatible with p_stdinit/p_stdout functions
 *
 * Copyright (c) 1998.  See accompanying LEGAL file for details.
 */

/* assumes <stdio.h> has been included */

#include "extern_c.h"

/* non-play main programs may be able to use these as drop-in
 *   replacements for getc and/or fgets in order to use gist
 * - in particular, u_getc can be the readline rl_getc_function
 * - such programs must also define u_abort_hook as appropriate
 * - the code may call u_pending_events() to handle all pending
 *   events and expired alarms without blocking */
extern int u_getc(FILE *stream);
extern char *u_fgets(char *s, int size, FILE *stream);
extern void u_pending_events(void);

END_EXTERN_C
