/* valaswitchlabel.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASWITCHLABEL_H__
#define __VALA_VALASWITCHLABEL_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabelPrivate ValaSwitchLabelPrivate;

/**
 * Represents a switch label in the source code.
 */
struct _ValaSwitchLabel {
	ValaCodeNode parent_instance;
	ValaSwitchLabelPrivate * priv;
};

struct _ValaSwitchLabelClass {
	ValaCodeNodeClass parent_class;
};


ValaSwitchLabel* vala_switch_label_new (ValaExpression* expr, ValaSourceReference* source);
ValaSwitchLabel* vala_switch_label_new_with_default (ValaSourceReference* source);
ValaExpression* vala_switch_label_get_expression (ValaSwitchLabel* self);
void vala_switch_label_set_expression (ValaSwitchLabel* self, ValaExpression* value);
GType vala_switch_label_get_type (void);


G_END_DECLS

#endif
