/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.UserDatabaseForm;

public final class SaveUserDatabaseAction
extends Action {
    private MBeanServer mserver = null;
    public static String USERDB_FACTORY = "org.apache.catalina.users.MemoryUserDatabaseFactory";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        if (this.isCancelled(request)) {
            return mapping.findForward("List UserDatabases Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, resources.getMessage(locale, "users.error.token"));
            return null;
        }
        UserDatabaseForm userDatabaseForm = (UserDatabaseForm)form;
        String objectName = userDatabaseForm.getObjectName();
        if (objectName == null) {
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{userDatabaseForm.getName(), "org.apache.catalina.UserDatabase"};
            ObjectName oname = null;
            try {
                String domain = userDatabaseForm.getDomain();
                oname = new ObjectName(domain + ":type=Resource" + ",resourcetype=Global" + ",class=" + "org.apache.catalina.UserDatabase" + ",name=" + params[0]);
                if (this.mserver.isRegistered(oname)) {
                    ActionMessages errors = new ActionMessages();
                    errors.add("name", new ActionMessage("resources.invalid.name"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                oname = new ObjectName(domain + ":type=NamingResources" + ",resourcetype=Global");
                objectName = (String)this.mserver.invoke(oname, "addResource", params, signature);
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.invoke", (Object)"addResource"), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.invoke", (Object)"addResource"));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName oname = new ObjectName(objectName);
            attribute = "pathname";
            this.mserver.setAttribute(oname, new Attribute(attribute, userDatabaseForm.getPath()));
            attribute = "factory";
            this.mserver.setAttribute(oname, new Attribute(attribute, userDatabaseForm.getFactory()));
            attribute = "description";
            this.mserver.setAttribute(oname, new Attribute(attribute, userDatabaseForm.getDescription()));
        }
        catch (Exception e) {
            this.getServlet().log(resources.getMessage(locale, "users.error.set.attribute", (Object)attribute), (Throwable)e);
            response.sendError(500, resources.getMessage(locale, "users.error.set.attribute", (Object)attribute));
            return null;
        }
        return mapping.findForward("UserDatabases List Setup");
    }
}

